/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.LoopingListIterator;
import org.junit.Assert;
import org.junit.Test;

public class LoopingListIteratorTest {
    @Test
    public void testConstructorEx() throws Exception {
        try {
            new LoopingListIterator(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testLooping0() throws Exception {
        ArrayList list = new ArrayList();
        LoopingListIterator loop = new LoopingListIterator(list);
        Assert.assertFalse((boolean)loop.hasNext());
        Assert.assertFalse((boolean)loop.hasPrevious());
        try {
            loop.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            loop.previous();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testLooping1() throws Exception {
        List<String> list = Arrays.asList("a");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assert.assertTrue((boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertTrue((boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertTrue((boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertTrue((boolean)loop.hasPrevious());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
        Assert.assertTrue((boolean)loop.hasPrevious());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
        Assert.assertTrue((boolean)loop.hasPrevious());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
    }

    @Test
    public void testLooping2() throws Exception {
        List<String> list = Arrays.asList("a", "b");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assert.assertTrue((boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertTrue((boolean)loop.hasNext());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertTrue((boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        loop.reset();
        Assert.assertTrue((boolean)loop.hasPrevious());
        Assert.assertEquals((Object)"b", (Object)loop.previous());
        Assert.assertTrue((boolean)loop.hasPrevious());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
        Assert.assertTrue((boolean)loop.hasPrevious());
        Assert.assertEquals((Object)"b", (Object)loop.previous());
    }

    @Test
    public void testJoggingNotOverBoundary() {
        List<String> list = Arrays.asList("a", "b");
        LoopingListIterator loop = new LoopingListIterator(list);
        loop.reset();
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.previous());
        Assert.assertEquals((Object)"b", (Object)loop.next());
    }

    @Test
    public void testJoggingOverBoundary() {
        List<String> list = Arrays.asList("a", "b");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assert.assertEquals((Object)"b", (Object)loop.previous());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.previous());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
    }

    @Test
    public void testRemovingElementsAndIteratingForward() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingListIterator loop = new LoopingListIterator(list);
        Assert.assertTrue((boolean)loop.hasNext());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        loop.remove();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)loop.hasNext());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        loop.remove();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)loop.hasNext());
        Assert.assertEquals((Object)"c", (Object)loop.next());
        loop.remove();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertFalse((boolean)loop.hasNext());
        try {
            loop.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemovingElementsAndIteratingBackwards() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingListIterator loop = new LoopingListIterator(list);
        Assert.assertTrue((boolean)loop.hasPrevious());
        Assert.assertEquals((Object)"c", (Object)loop.previous());
        loop.remove();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)loop.hasPrevious());
        Assert.assertEquals((Object)"b", (Object)loop.previous());
        loop.remove();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)loop.hasPrevious());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
        loop.remove();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertFalse((boolean)loop.hasPrevious());
        try {
            loop.previous();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testReset() {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        loop.reset();
        Assert.assertEquals((Object)"a", (Object)loop.next());
        loop.reset();
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertEquals((Object)"c", (Object)loop.next());
        loop.reset();
        Assert.assertEquals((Object)"c", (Object)loop.previous());
        Assert.assertEquals((Object)"b", (Object)loop.previous());
        loop.reset();
        Assert.assertEquals((Object)"c", (Object)loop.previous());
        loop.reset();
        Assert.assertEquals((Object)"c", (Object)loop.previous());
        Assert.assertEquals((Object)"b", (Object)loop.previous());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
    }

    @Test
    public void testAdd() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("b", "e", "f"));
        LoopingListIterator loop = new LoopingListIterator(list);
        loop.add((Object)"a");
        Assert.assertEquals((Object)"b", (Object)loop.next());
        loop.reset();
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        loop.add((Object)"c");
        Assert.assertEquals((Object)"e", (Object)loop.next());
        Assert.assertEquals((Object)"e", (Object)loop.previous());
        Assert.assertEquals((Object)"c", (Object)loop.previous());
        Assert.assertEquals((Object)"c", (Object)loop.next());
        loop.add((Object)"d");
        loop.reset();
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertEquals((Object)"c", (Object)loop.next());
        Assert.assertEquals((Object)"d", (Object)loop.next());
        Assert.assertEquals((Object)"e", (Object)loop.next());
        Assert.assertEquals((Object)"f", (Object)loop.next());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        list = new ArrayList<String>(Arrays.asList("b", "e", "f"));
        loop = new LoopingListIterator(list);
        loop.add((Object)"a");
        Assert.assertEquals((Object)"a", (Object)loop.previous());
        loop.reset();
        Assert.assertEquals((Object)"f", (Object)loop.previous());
        Assert.assertEquals((Object)"e", (Object)loop.previous());
        loop.add((Object)"d");
        Assert.assertEquals((Object)"d", (Object)loop.previous());
        loop.add((Object)"c");
        Assert.assertEquals((Object)"c", (Object)loop.previous());
        loop.reset();
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertEquals((Object)"c", (Object)loop.next());
        Assert.assertEquals((Object)"d", (Object)loop.next());
        Assert.assertEquals((Object)"e", (Object)loop.next());
        Assert.assertEquals((Object)"f", (Object)loop.next());
        Assert.assertEquals((Object)"a", (Object)loop.next());
    }

    @Test
    public void testNextAndPreviousIndex() {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assert.assertEquals((long)0L, (long)loop.nextIndex());
        Assert.assertEquals((long)2L, (long)loop.previousIndex());
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((long)1L, (long)loop.nextIndex());
        Assert.assertEquals((long)0L, (long)loop.previousIndex());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
        Assert.assertEquals((long)0L, (long)loop.nextIndex());
        Assert.assertEquals((long)2L, (long)loop.previousIndex());
        Assert.assertEquals((Object)"c", (Object)loop.previous());
        Assert.assertEquals((long)2L, (long)loop.nextIndex());
        Assert.assertEquals((long)1L, (long)loop.previousIndex());
        Assert.assertEquals((Object)"b", (Object)loop.previous());
        Assert.assertEquals((long)1L, (long)loop.nextIndex());
        Assert.assertEquals((long)0L, (long)loop.previousIndex());
        Assert.assertEquals((Object)"a", (Object)loop.previous());
        Assert.assertEquals((long)0L, (long)loop.nextIndex());
        Assert.assertEquals((long)2L, (long)loop.previousIndex());
    }

    @Test
    public void testSet() {
        List<String> list = Arrays.asList("q", "r", "z");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assert.assertEquals((Object)"z", (Object)loop.previous());
        loop.set((Object)"c");
        loop.reset();
        Assert.assertEquals((Object)"q", (Object)loop.next());
        loop.set((Object)"a");
        Assert.assertEquals((Object)"r", (Object)loop.next());
        loop.set((Object)"b");
        loop.reset();
        Assert.assertEquals((Object)"a", (Object)loop.next());
        Assert.assertEquals((Object)"b", (Object)loop.next());
        Assert.assertEquals((Object)"c", (Object)loop.next());
    }
}

