/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.ResettableListIterator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ListIteratorWrapper;

public class ListIteratorWrapper2Test<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    protected List<E> list1 = null;

    public ListIteratorWrapper2Test(String testName) {
        super(testName);
    }

    public void setUp() {
        this.list1 = new ArrayList();
        this.list1.add("One");
        this.list1.add("Two");
        this.list1.add("Three");
        this.list1.add("Four");
        this.list1.add("Five");
        this.list1.add("Six");
    }

    @Override
    public ResettableListIterator<E> makeEmptyIterator() {
        ArrayList list = new ArrayList();
        return new ListIteratorWrapper(list.listIterator());
    }

    @Override
    public ResettableListIterator<E> makeObject() {
        return new ListIteratorWrapper(this.list1.listIterator());
    }

    public void testIterator() {
        Object iterValue;
        ResettableListIterator<E> iter = this.makeObject();
        for (String testValue : this.testArray) {
            iterValue = iter.next();
            ListIteratorWrapper2Test.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
        ListIteratorWrapper2Test.assertTrue((String)"Iterator should now be empty", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
        }
        catch (Exception e) {
            ListIteratorWrapper2Test.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
        for (int i = this.testArray.length - 1; i > -1; --i) {
            String testValue = this.testArray[i];
            Object iterValue2 = iter.previous();
            ListIteratorWrapper2Test.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue2);
        }
        try {
            iter.previous();
        }
        catch (Exception e) {
            ListIteratorWrapper2Test.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
        for (String testValue : this.testArray) {
            iterValue = iter.next();
            ListIteratorWrapper2Test.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
    }

    @Override
    public void testRemove() {
        ResettableListIterator<E> iter = this.makeObject();
        ListIteratorWrapper2Test.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)0, (int)iter.nextIndex());
        try {
            iter.remove();
            ListIteratorWrapper2Test.fail((String)"ListIteratorWrapper#remove() should fail; must be initially positioned first");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ListIteratorWrapper2Test.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)0, (int)iter.nextIndex());
        int sz = this.list1.size();
        ListIteratorWrapper2Test.assertEquals(this.list1.get(0), iter.next());
        ListIteratorWrapper2Test.assertEquals((int)0, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)1, (int)iter.nextIndex());
        iter.remove();
        ListIteratorWrapper2Test.assertEquals((int)(--sz), (int)this.list1.size());
        ListIteratorWrapper2Test.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)0, (int)iter.nextIndex());
        try {
            iter.remove();
            ListIteratorWrapper2Test.fail((String)"ListIteratorWrapper#remove() should fail; must be repositioned first");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ListIteratorWrapper2Test.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)0, (int)iter.nextIndex());
        ListIteratorWrapper2Test.assertEquals(this.list1.get(0), iter.next());
        ListIteratorWrapper2Test.assertEquals((int)0, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)1, (int)iter.nextIndex());
        ListIteratorWrapper2Test.assertEquals(this.list1.get(1), iter.next());
        ListIteratorWrapper2Test.assertEquals((int)1, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)2, (int)iter.nextIndex());
        ListIteratorWrapper2Test.assertEquals(this.list1.get(1), iter.previous());
        ListIteratorWrapper2Test.assertEquals((int)0, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)1, (int)iter.nextIndex());
        iter.remove();
        ListIteratorWrapper2Test.assertEquals((int)(--sz), (int)this.list1.size());
        ListIteratorWrapper2Test.assertEquals((int)0, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)1, (int)iter.nextIndex());
        ListIteratorWrapper2Test.assertEquals(this.list1.get(0), iter.previous());
        ListIteratorWrapper2Test.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)0, (int)iter.nextIndex());
        iter.remove();
        ListIteratorWrapper2Test.assertEquals((int)(--sz), (int)this.list1.size());
        ListIteratorWrapper2Test.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapper2Test.assertEquals((int)0, (int)iter.nextIndex());
    }

    public void testReset() {
        ResettableListIterator<E> iter = this.makeObject();
        Object first = iter.next();
        Object second = iter.next();
        iter.reset();
        ListIteratorWrapper2Test.assertFalse((String)"No previous elements after reset()", (boolean)iter.hasPrevious());
        ListIteratorWrapper2Test.assertEquals((String)"First element should be the same", (Object)first, (Object)iter.next());
        ListIteratorWrapper2Test.assertEquals((String)"Second elment should be the same", (Object)second, (Object)iter.next());
        for (int i = 2; i < this.testArray.length; ++i) {
            String testValue = this.testArray[i];
            Object iterValue = iter.next();
            ListIteratorWrapper2Test.assertEquals((String)"Iteration value is correct", (Object)testValue, (Object)iterValue);
        }
    }
}

