/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.TestUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.functors.ConstantTransformer;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.ExceptionTransformer;
import org.apache.commons.collections4.functors.FalsePredicate;
import org.apache.commons.collections4.functors.NOPTransformer;
import org.apache.commons.collections4.functors.StringValueTransformer;
import org.apache.commons.collections4.functors.TruePredicate;
import org.junit.Assert;
import org.junit.Test;

public class TransformerUtilsTest {
    private static final Object cObject = new Object();
    private static final Object cString = "Hello";
    private static final Object cInteger = 6;

    @Test
    public void testExceptionTransformer() {
        Assert.assertNotNull((Object)TransformerUtils.exceptionTransformer());
        Assert.assertSame((Object)TransformerUtils.exceptionTransformer(), (Object)TransformerUtils.exceptionTransformer());
        try {
            TransformerUtils.exceptionTransformer().transform(null);
        }
        catch (FunctorException ex) {
            try {
                TransformerUtils.exceptionTransformer().transform(cString);
            }
            catch (FunctorException ex2) {
                return;
            }
        }
        Assert.fail();
    }

    @Test
    public void testNullTransformer() {
        Assert.assertNotNull((Object)TransformerUtils.nullTransformer());
        Assert.assertSame((Object)TransformerUtils.nullTransformer(), (Object)TransformerUtils.nullTransformer());
        Assert.assertEquals(null, (Object)TransformerUtils.nullTransformer().transform(null));
        Assert.assertEquals(null, (Object)TransformerUtils.nullTransformer().transform(cObject));
        Assert.assertEquals(null, (Object)TransformerUtils.nullTransformer().transform(cString));
        Assert.assertEquals(null, (Object)TransformerUtils.nullTransformer().transform(cInteger));
    }

    @Test
    public void testNopTransformer() {
        Assert.assertNotNull((Object)TransformerUtils.nullTransformer());
        Assert.assertSame((Object)TransformerUtils.nullTransformer(), (Object)TransformerUtils.nullTransformer());
        Assert.assertEquals(null, (Object)TransformerUtils.nopTransformer().transform(null));
        Assert.assertEquals((Object)cObject, (Object)TransformerUtils.nopTransformer().transform(cObject));
        Assert.assertEquals((Object)cString, (Object)TransformerUtils.nopTransformer().transform(cString));
        Assert.assertEquals((Object)cInteger, (Object)TransformerUtils.nopTransformer().transform(cInteger));
    }

    @Test
    public void testConstantTransformer() {
        Assert.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(null));
        Assert.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(cObject));
        Assert.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(cString));
        Assert.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(cInteger));
        Assert.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.constantTransformer(null));
    }

    @Test
    public void testCloneTransformer() {
        Assert.assertEquals(null, (Object)TransformerUtils.cloneTransformer().transform(null));
        Assert.assertEquals((Object)cString, (Object)TransformerUtils.cloneTransformer().transform(cString));
        Assert.assertEquals((Object)cInteger, (Object)TransformerUtils.cloneTransformer().transform(cInteger));
        try {
            Assert.assertEquals((Object)cObject, (Object)TransformerUtils.cloneTransformer().transform(cObject));
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testMapTransformer() {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        map.put(null, 0);
        map.put(cObject, 1);
        map.put(cString, 2);
        Assert.assertEquals((Object)0, (Object)TransformerUtils.mapTransformer(map).transform(null));
        Assert.assertEquals((Object)1, (Object)TransformerUtils.mapTransformer(map).transform(cObject));
        Assert.assertEquals((Object)2, (Object)TransformerUtils.mapTransformer(map).transform(cString));
        Assert.assertEquals(null, (Object)TransformerUtils.mapTransformer(map).transform(cInteger));
        Assert.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.mapTransformer(null));
    }

    @Test
    public void testExecutorTransformer() {
        Assert.assertEquals(null, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(null));
        Assert.assertEquals((Object)cObject, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(cObject));
        Assert.assertEquals((Object)cString, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(cString));
        Assert.assertEquals((Object)cInteger, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(cInteger));
        try {
            TransformerUtils.asTransformer((Closure)null);
        }
        catch (NullPointerException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testPredicateTransformer() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(null));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(cObject));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(cString));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(cInteger));
        try {
            TransformerUtils.asTransformer((Predicate)null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testFactoryTransformer() {
        Assert.assertEquals(null, (Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(null));
        Assert.assertEquals(null, (Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(cObject));
        Assert.assertEquals(null, (Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(cString));
        Assert.assertEquals(null, (Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(cInteger));
        try {
            TransformerUtils.asTransformer((Factory)null);
        }
        catch (NullPointerException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testChainedTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        Assert.assertEquals((Object)"A", (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{b, a}).transform(null));
        Assert.assertEquals((Object)"B", (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{a, b}).transform(null));
        Assert.assertEquals((Object)"A", (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{b, a}).transform(null));
        ArrayList<Transformer> coll = new ArrayList<Transformer>();
        coll.add(b);
        coll.add(a);
        Assert.assertEquals((Object)"A", (Object)TransformerUtils.chainedTransformer(coll).transform(null));
        Assert.assertSame((Object)NOPTransformer.INSTANCE, (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[0]));
        Assert.assertSame((Object)NOPTransformer.INSTANCE, (Object)TransformerUtils.chainedTransformer(Collections.emptyList()));
        try {
            TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{null, null});
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.chainedTransformer((Transformer[])null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.chainedTransformer((Collection)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{null, null});
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            coll = new ArrayList();
            coll.add(null);
            coll.add(null);
            TransformerUtils.chainedTransformer(coll);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testIfTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        Transformer c = TransformerUtils.constantTransformer((Object)"C");
        Assert.assertEquals((Object)"A", (Object)TransformerUtils.ifTransformer((Predicate)TruePredicate.truePredicate(), (Transformer)a, (Transformer)b).transform(null));
        Assert.assertEquals((Object)"B", (Object)TransformerUtils.ifTransformer((Predicate)FalsePredicate.falsePredicate(), (Transformer)a, (Transformer)b).transform(null));
        Predicate<Integer> lessThanFivePredicate = new Predicate<Integer>(){

            public boolean evaluate(Integer value) {
                return value < 5;
            }
        };
        Assert.assertEquals((Object)"A", (Object)TransformerUtils.ifTransformer((Predicate)lessThanFivePredicate, (Transformer)a, (Transformer)b).transform((Object)1));
        Assert.assertEquals((Object)"B", (Object)TransformerUtils.ifTransformer((Predicate)lessThanFivePredicate, (Transformer)a, (Transformer)b).transform((Object)5));
        Predicate equalsAPredicate = EqualPredicate.equalPredicate((Object)"A");
        Assert.assertEquals((Object)"C", (Object)TransformerUtils.ifTransformer((Predicate)equalsAPredicate, (Transformer)c).transform((Object)"A"));
        Assert.assertEquals((Object)"B", (Object)TransformerUtils.ifTransformer((Predicate)equalsAPredicate, (Transformer)c).transform((Object)"B"));
        try {
            TransformerUtils.ifTransformer(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.ifTransformer((Predicate)TruePredicate.truePredicate(), null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.ifTransformer(null, (Transformer)ConstantTransformer.constantTransformer((Object)"A"));
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.ifTransformer(null, null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testSwitchTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        Transformer c = TransformerUtils.constantTransformer((Object)"C");
        Assert.assertEquals((Object)"A", (Object)TransformerUtils.switchTransformer((Predicate)TruePredicate.truePredicate(), (Transformer)a, (Transformer)b).transform(null));
        Assert.assertEquals((Object)"B", (Object)TransformerUtils.switchTransformer((Predicate)FalsePredicate.falsePredicate(), (Transformer)a, (Transformer)b).transform(null));
        Assert.assertEquals(null, (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}).transform((Object)"WELL"));
        Assert.assertEquals((Object)"A", (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}).transform((Object)"HELLO"));
        Assert.assertEquals((Object)"B", (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}).transform((Object)"THERE"));
        Assert.assertEquals((Object)"C", (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}, (Transformer)c).transform((Object)"WELL"));
        HashMap<Predicate, Transformer> map = new HashMap<Predicate, Transformer>();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        Assert.assertEquals(null, (Object)TransformerUtils.switchTransformer(map).transform((Object)"WELL"));
        Assert.assertEquals((Object)"A", (Object)TransformerUtils.switchTransformer(map).transform((Object)"HELLO"));
        Assert.assertEquals((Object)"B", (Object)TransformerUtils.switchTransformer(map).transform((Object)"THERE"));
        map.put(null, c);
        Assert.assertEquals((Object)"C", (Object)TransformerUtils.switchTransformer(map).transform((Object)"WELL"));
        Assert.assertEquals((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[0], (Transformer[])new Transformer[0]));
        Assert.assertEquals((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchTransformer(new HashMap()));
        map = new HashMap();
        map.put(null, null);
        Assert.assertEquals((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchTransformer(map));
        try {
            TransformerUtils.switchTransformer(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.switchTransformer((Predicate[])null, (Transformer[])null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.switchTransformer((Map)null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.switchTransformer((Predicate[])new Predicate[2], (Transformer[])new Transformer[2]);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.switchTransformer((Predicate[])new Predicate[]{TruePredicate.truePredicate()}, (Transformer[])new Transformer[]{a, b});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSwitchMapTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        Transformer c = TransformerUtils.constantTransformer((Object)"C");
        HashMap<String, Transformer> map = new HashMap<String, Transformer>();
        map.put("HELLO", a);
        map.put("THERE", b);
        Assert.assertEquals(null, (Object)TransformerUtils.switchMapTransformer(map).transform((Object)"WELL"));
        Assert.assertEquals((Object)"A", (Object)TransformerUtils.switchMapTransformer(map).transform((Object)"HELLO"));
        Assert.assertEquals((Object)"B", (Object)TransformerUtils.switchMapTransformer(map).transform((Object)"THERE"));
        map.put(null, c);
        Assert.assertEquals((Object)"C", (Object)TransformerUtils.switchMapTransformer(map).transform((Object)"WELL"));
        Assert.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchMapTransformer(new HashMap()));
        map = new HashMap();
        map.put(null, null);
        Assert.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchMapTransformer(map));
        try {
            TransformerUtils.switchMapTransformer(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testInvokerTransformer() {
        ArrayList<Object> list = new ArrayList<Object>();
        Assert.assertEquals((Object)0, (Object)TransformerUtils.invokerTransformer((String)"size").transform(list));
        list.add(new Object());
        Assert.assertEquals((Object)1, (Object)TransformerUtils.invokerTransformer((String)"size").transform(list));
        Assert.assertEquals(null, (Object)TransformerUtils.invokerTransformer((String)"size").transform(null));
        try {
            TransformerUtils.invokerTransformer(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.invokerTransformer((String)"noSuchMethod").transform(new Object());
            Assert.fail();
        }
        catch (FunctorException functorException) {
            // empty catch block
        }
    }

    @Test
    public void testInvokerTransformer2() {
        ArrayList<Object> list = new ArrayList<Object>();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)TransformerUtils.invokerTransformer((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(list));
        list.add(cString);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.invokerTransformer((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(list));
        Assert.assertEquals(null, (Object)TransformerUtils.invokerTransformer((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(null));
        try {
            TransformerUtils.invokerTransformer(null, null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TransformerUtils.invokerTransformer((String)"noSuchMethod", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(new Object());
            Assert.fail();
        }
        catch (FunctorException functorException) {
            // empty catch block
        }
        try {
            TransformerUtils.invokerTransformer((String)"badArgs", null, (Object[])new Object[]{cString});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TransformerUtils.invokerTransformer((String)"badArgs", (Class[])new Class[]{Object.class}, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TransformerUtils.invokerTransformer((String)"badArgs", (Class[])new Class[0], (Object[])new Object[]{cString});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testStringValueTransformer() {
        Assert.assertNotNull((String)"StringValueTransformer should NEVER return a null value.", (Object)TransformerUtils.stringValueTransformer().transform(null));
        Assert.assertEquals((String)"StringValueTransformer should return \"null\" when given a null argument.", (Object)"null", (Object)TransformerUtils.stringValueTransformer().transform(null));
        Assert.assertEquals((String)"StringValueTransformer should return toString value", (Object)"6", (Object)TransformerUtils.stringValueTransformer().transform((Object)6));
    }

    @Test
    public void testInstantiateTransformerNull() {
        try {
            TransformerUtils.instantiateTransformer(null, (Object[])new Object[]{"str"});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TransformerUtils.instantiateTransformer((Class[])new Class[0], (Object[])new Object[]{"str"});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer trans = TransformerUtils.instantiateTransformer((Class[])new Class[]{Long.class}, (Object[])new Object[]{null});
        try {
            trans.transform(String.class);
            Assert.fail();
        }
        catch (FunctorException functorException) {
            // empty catch block
        }
        trans = TransformerUtils.instantiateTransformer();
        Assert.assertEquals((Object)"", (Object)trans.transform(String.class));
        trans = TransformerUtils.instantiateTransformer((Class[])new Class[]{Long.TYPE}, (Object[])new Object[]{new Long(1000L)});
        Assert.assertEquals((Object)new Date(1000L), (Object)trans.transform(Date.class));
    }

    @Test
    public void testSingletonPatternInSerialization() {
        Object[] singletones;
        for (Object original : singletones = new Object[]{ExceptionTransformer.INSTANCE, NOPTransformer.INSTANCE, StringValueTransformer.stringValueTransformer()}) {
            TestUtils.assertSameAfterSerialization("Singleton pattern broken for " + original.getClass(), original);
        }
    }
}

