/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.collections4.FluentIterable;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FluentIterableTest {
    private Iterable<Integer> iterableA = null;
    private Iterable<Long> iterableB = null;
    private Iterable<Integer> iterableEven = null;
    private Iterable<Integer> iterableOdd = null;
    private Iterable<Integer> emptyIterable = null;
    private static Predicate<Number> EVEN = new Predicate<Number>(){

        public boolean evaluate(Number input) {
            return input.intValue() % 2 == 0;
        }
    };

    @Before
    public void setUp() {
        ArrayList<Integer> collectionA = new ArrayList<Integer>();
        collectionA.add(1);
        collectionA.add(2);
        collectionA.add(2);
        collectionA.add(3);
        collectionA.add(3);
        collectionA.add(3);
        collectionA.add(4);
        collectionA.add(4);
        collectionA.add(4);
        collectionA.add(4);
        this.iterableA = collectionA;
        LinkedList<Long> collectionB = new LinkedList<Long>();
        collectionB.add(5L);
        collectionB.add(4L);
        collectionB.add(4L);
        collectionB.add(3L);
        collectionB.add(3L);
        collectionB.add(3L);
        collectionB.add(2L);
        collectionB.add(2L);
        collectionB.add(2L);
        collectionB.add(2L);
        this.iterableB = collectionB;
        this.iterableEven = Arrays.asList(2, 4, 6, 8, 10, 12);
        this.iterableOdd = Arrays.asList(1, 3, 5, 7, 9, 11);
        this.emptyIterable = Collections.emptyList();
    }

    @Test
    public void factoryMethodOf() {
        FluentIterable iterable = FluentIterable.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        List result = iterable.toList();
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)result);
        iterable = FluentIterable.of((Object)1);
        Assert.assertEquals((long)1L, (long)iterable.size());
        Assert.assertFalse((boolean)iterable.isEmpty());
        Assert.assertEquals(Arrays.asList(1), (Object)iterable.toList());
        result = FluentIterable.of((Object[])new Integer[0]).toList();
        Assert.assertTrue((boolean)result.isEmpty());
        Iterable it = null;
        try {
            FluentIterable.of(it).toList();
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void appendElements() {
        FluentIterable it = FluentIterable.of(this.iterableA).append((Object[])new Integer[]{10, 20, 30});
        Assert.assertEquals((long)(IterableUtils.size(this.iterableA) + 3), (long)IterableUtils.size((Iterable)it));
        Assert.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)1));
        Assert.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)10));
        Assert.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)20));
        Assert.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)30));
        Assert.assertFalse((boolean)IterableUtils.contains((Iterable)it, (Object)40));
        FluentIterable empty = FluentIterable.of(this.emptyIterable).append((Object[])new Integer[0]);
        Assert.assertTrue((boolean)IterableUtils.isEmpty((Iterable)empty));
    }

    @Test
    public void appendIterable() {
        List<Integer> listB = Arrays.asList(10, 20, 30);
        FluentIterable it = FluentIterable.of(this.iterableA).append(listB);
        Assert.assertEquals((long)(IterableUtils.size(this.iterableA) + listB.size()), (long)IterableUtils.size((Iterable)it));
        Assert.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)1));
        Assert.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)10));
        Assert.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)20));
        Assert.assertTrue((boolean)IterableUtils.contains((Iterable)it, (Object)30));
        Assert.assertFalse((boolean)IterableUtils.contains((Iterable)it, (Object)40));
    }

    @Test
    public void collate() {
        List result = FluentIterable.of(this.iterableOdd).collate(this.iterableEven).toList();
        ArrayList combinedList = new ArrayList();
        CollectionUtils.addAll(combinedList, this.iterableOdd);
        CollectionUtils.addAll(combinedList, this.iterableEven);
        Collections.sort(combinedList);
        Assert.assertEquals(combinedList, (Object)result);
        try {
            FluentIterable.of(this.iterableOdd).collate(null).toList();
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void collateWithComparator() {
        List result = FluentIterable.of(this.iterableOdd).collate(this.iterableEven, ComparatorUtils.naturalComparator()).toList();
        ArrayList combinedList = new ArrayList();
        CollectionUtils.addAll(combinedList, this.iterableOdd);
        CollectionUtils.addAll(combinedList, this.iterableEven);
        Collections.sort(combinedList);
        Assert.assertEquals(combinedList, (Object)result);
        result = FluentIterable.of(this.iterableOdd).collate(this.iterableEven, null).toList();
        Assert.assertEquals(combinedList, (Object)result);
    }

    @Test
    public void filter() {
        Predicate<Integer> smallerThan3 = new Predicate<Integer>(){

            public boolean evaluate(Integer object) {
                return object < 3;
            }
        };
        List result = FluentIterable.of(this.iterableA).filter((Predicate)smallerThan3).toList();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals(Arrays.asList(1, 2, 2), (Object)result);
        result = FluentIterable.of(this.emptyIterable).filter((Predicate)smallerThan3).toList();
        Assert.assertEquals((long)0L, (long)result.size());
        try {
            FluentIterable.of(this.iterableA).filter(null).toList();
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void forEach() {
        final AtomicInteger sum = new AtomicInteger(0);
        Closure<Integer> closure = new Closure<Integer>(){

            public void execute(Integer input) {
                sum.addAndGet(input);
            }
        };
        FluentIterable.of(this.iterableA).forEach((Closure)closure);
        int expectedSum = 0;
        for (Integer i : this.iterableA) {
            expectedSum += i.intValue();
        }
        Assert.assertEquals((long)expectedSum, (long)sum.get());
        try {
            FluentIterable.of(this.iterableA).forEach((Closure)null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void limit() {
        List result = FluentIterable.of(this.iterableA).limit(3L).toList();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals(Arrays.asList(1, 2, 2), (Object)result);
        result = FluentIterable.of(this.iterableA).limit(100L).toList();
        List expected = IterableUtils.toList(this.iterableA);
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertEquals((Object)expected, (Object)result);
        result = FluentIterable.of(this.iterableA).limit(0L).toList();
        Assert.assertEquals((long)0L, (long)result.size());
        result = FluentIterable.of(this.emptyIterable).limit(3L).toList();
        Assert.assertEquals((long)0L, (long)result.size());
        try {
            FluentIterable.of(this.iterableA).limit(-2L).toList();
            Assert.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void reverse() {
        List result = FluentIterable.of(this.iterableA).reverse().toList();
        List expected = IterableUtils.toList(this.iterableA);
        Collections.reverse(expected);
        Assert.assertEquals((Object)expected, (Object)result);
        result = FluentIterable.of(this.emptyIterable).reverse().toList();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void skip() {
        List result = FluentIterable.of(this.iterableA).skip(4L).toList();
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertEquals(Arrays.asList(3, 3, 4, 4, 4, 4), (Object)result);
        result = FluentIterable.of(this.iterableA).skip(100L).toList();
        Assert.assertEquals((long)0L, (long)result.size());
        result = FluentIterable.of(this.iterableA).skip(0L).toList();
        List expected = IterableUtils.toList(this.iterableA);
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertEquals((Object)expected, (Object)result);
        result = FluentIterable.of(this.emptyIterable).skip(3L).toList();
        Assert.assertEquals((long)0L, (long)result.size());
        try {
            FluentIterable.of(this.iterableA).skip(-4L).toList();
            Assert.fail((String)"expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void transform() {
        Transformer<Integer, Integer> squared = new Transformer<Integer, Integer>(){

            public Integer transform(Integer object) {
                return object * object;
            }
        };
        List result = FluentIterable.of(this.iterableA).transform((Transformer)squared).toList();
        Assert.assertEquals((long)10L, (long)result.size());
        Assert.assertEquals(Arrays.asList(1, 4, 4, 9, 9, 9, 16, 16, 16, 16), (Object)result);
        result = FluentIterable.of(this.emptyIterable).transform((Transformer)squared).toList();
        Assert.assertEquals((long)0L, (long)result.size());
        try {
            FluentIterable.of(this.iterableA).transform(null).toList();
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void unique() {
        List result = FluentIterable.of(this.iterableA).unique().toList();
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)result);
        result = FluentIterable.of(this.emptyIterable).unique().toList();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void unmodifiable() {
        FluentIterable iterable1 = FluentIterable.of(this.iterableA).unmodifiable();
        Iterator it = iterable1.iterator();
        Assert.assertEquals((long)1L, (long)((Integer)it.next()).intValue());
        try {
            it.remove();
            Assert.fail((String)"expecting UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        FluentIterable iterable2 = iterable1.unmodifiable();
        Assert.assertSame((Object)iterable1, (Object)iterable2);
    }

    @Test
    public void zip() {
        List result = FluentIterable.of(this.iterableOdd).zip(this.iterableEven).toList();
        List<Object> combinedList = new ArrayList();
        CollectionUtils.addAll(combinedList, this.iterableOdd);
        CollectionUtils.addAll(combinedList, this.iterableEven);
        Collections.sort(combinedList);
        Assert.assertEquals(combinedList, (Object)result);
        try {
            FluentIterable.of(this.iterableOdd).zip((Iterable)null).toList();
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        result = FluentIterable.of(Arrays.asList(1, 4, 7)).zip(new Iterable[]{Arrays.asList(2, 5, 8), Arrays.asList(3, 6, 9)}).toList();
        combinedList = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9);
        Assert.assertEquals(combinedList, (Object)result);
    }

    @Test
    public void asEnumeration() {
        Enumeration enumeration = FluentIterable.of(this.iterableB).asEnumeration();
        List result = EnumerationUtils.toList((Enumeration)enumeration);
        Assert.assertEquals(this.iterableB, (Object)result);
        enumeration = FluentIterable.empty().asEnumeration();
        Assert.assertFalse((boolean)enumeration.hasMoreElements());
    }

    @Test
    public void allMatch() {
        Assert.assertTrue((boolean)FluentIterable.of(this.iterableEven).allMatch(EVEN));
        Assert.assertFalse((boolean)FluentIterable.of(this.iterableOdd).allMatch(EVEN));
        Assert.assertFalse((boolean)FluentIterable.of(this.iterableA).allMatch(EVEN));
        try {
            FluentIterable.of(this.iterableEven).allMatch(null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void anyMatch() {
        Assert.assertTrue((boolean)FluentIterable.of(this.iterableEven).anyMatch(EVEN));
        Assert.assertFalse((boolean)FluentIterable.of(this.iterableOdd).anyMatch(EVEN));
        Assert.assertTrue((boolean)FluentIterable.of(this.iterableA).anyMatch(EVEN));
        try {
            FluentIterable.of(this.iterableEven).anyMatch(null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void isEmpty() {
        Assert.assertTrue((boolean)FluentIterable.of(this.emptyIterable).isEmpty());
        Assert.assertFalse((boolean)FluentIterable.of(this.iterableOdd).isEmpty());
    }

    @Test
    public void size() {
        try {
            FluentIterable.of((Iterable)null).size();
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)FluentIterable.of(this.emptyIterable).size());
        Assert.assertEquals((long)IterableUtils.toList(this.iterableOdd).size(), (long)FluentIterable.of(this.iterableOdd).size());
    }

    @Test
    public void eval() {
        ArrayList<Integer> listNumbers = new ArrayList<Integer>();
        listNumbers.addAll(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10));
        FluentIterable iterable = FluentIterable.of(listNumbers).filter(EVEN);
        FluentIterable materialized = iterable.eval();
        listNumbers.addAll(Arrays.asList(11, 12, 13, 14, 15, 16, 17, 18, 19, 20));
        Assert.assertEquals((long)5L, (long)materialized.size());
        Assert.assertEquals((long)10L, (long)iterable.size());
        Assert.assertEquals(Arrays.asList(2, 4, 6, 8, 10), (Object)materialized.toList());
        Assert.assertEquals(Arrays.asList(2, 4, 6, 8, 10, 12, 14, 16, 18, 20), (Object)iterable.toList());
    }

    @Test
    public void contains() {
        Assert.assertTrue((boolean)FluentIterable.of(this.iterableEven).contains((Object)2));
        Assert.assertFalse((boolean)FluentIterable.of(this.iterableEven).contains((Object)1));
        Assert.assertFalse((boolean)FluentIterable.of(this.iterableEven).contains(null));
        Assert.assertTrue((boolean)FluentIterable.of(this.iterableEven).append((Object[])new Integer[]{null}).contains(null));
    }

    @Test
    public void copyInto() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        FluentIterable.of(this.iterableA).copyInto(result);
        ArrayList<Integer> expected = IterableUtils.toList(this.iterableA);
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertEquals((Object)expected, result);
        result = new ArrayList();
        result.add(10);
        result.add(9);
        result.add(8);
        FluentIterable.of(this.iterableA).copyInto(result);
        expected = new ArrayList<Integer>();
        expected.addAll(Arrays.asList(10, 9, 8));
        expected.addAll(IterableUtils.toList(this.iterableA));
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertEquals(expected, result);
        try {
            FluentIterable.of(this.iterableA).copyInto(null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void iterator() {
        Iterator iterator = FluentIterable.of(this.iterableA).iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator = FluentIterable.empty().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void get() {
        Assert.assertEquals((long)2L, (long)((Integer)FluentIterable.of(this.iterableEven).get(0)).intValue());
        try {
            FluentIterable.of(this.iterableEven).get(-1);
            Assert.fail((String)"expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            FluentIterable.of(this.iterableEven).get(IterableUtils.size(this.iterableEven));
            Assert.fail((String)"expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void toArray() {
        Object[] arr = new Long[]{1L, 2L, 3L, 4L, 5L};
        Object[] result = (Long[])FluentIterable.of((Object[])arr).toArray(Long.class);
        Assert.assertNotNull((Object)result);
        Assert.assertArrayEquals((Object[])arr, (Object[])result);
        try {
            FluentIterable.of((Object[])arr).toArray(String.class);
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        String result = FluentIterable.of(this.iterableA).toString();
        Assert.assertEquals((Object)this.iterableA.toString(), (Object)result);
        result = FluentIterable.empty().toString();
        Assert.assertEquals((Object)"[]", (Object)result);
    }
}

