/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.UnmodifiableSet;

public class UnmodifiableSetTest<E>
extends AbstractSetTest<E> {
    public UnmodifiableSetTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(UnmodifiableSetTest.class);
    }

    @Override
    public Set<E> makeObject() {
        return UnmodifiableSet.unmodifiableSet(new HashSet());
    }

    @Override
    public Set<E> makeFullCollection() {
        HashSet set = new HashSet();
        set.addAll(Arrays.asList(this.getFullElements()));
        return UnmodifiableSet.unmodifiableSet(set);
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    public void testUnmodifiable() {
        UnmodifiableSetTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableSetTest.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        Collection set = this.makeFullCollection();
        UnmodifiableSetTest.assertSame((Object)set, (Object)UnmodifiableSet.unmodifiableSet((Set)set));
        try {
            UnmodifiableSet.unmodifiableSet(null);
            UnmodifiableSetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

