/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.PredicatedSet;

public class PredicatedSetTest<E>
extends AbstractSetTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = new Predicate<E>(){

        public boolean evaluate(E o) {
            return o instanceof String;
        }
    };

    public PredicatedSetTest(String testName) {
        super(testName);
    }

    protected PredicatedSet<E> decorateSet(Set<E> set, Predicate<? super E> predicate) {
        return PredicatedSet.predicatedSet(set, predicate);
    }

    @Override
    public PredicatedSet<E> makeObject() {
        return this.decorateSet(new HashSet(), this.truePredicate);
    }

    @Override
    public E[] getFullElements() {
        return new Object[]{"1", "3", "5", "7", "2", "4", "6"};
    }

    protected PredicatedSet<E> makeTestSet() {
        return this.decorateSet(new HashSet(), this.testPredicate);
    }

    public void testGetSet() {
        PredicatedSet<E> set = this.makeTestSet();
        PredicatedSetTest.assertTrue((String)"returned set should not be null", (set.decorated() != null ? 1 : 0) != 0);
    }

    public void testIllegalAdd() {
        PredicatedSet<Integer> set = this.makeTestSet();
        Integer i = 3;
        try {
            set.add(i);
            PredicatedSetTest.fail((String)"Integer should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedSetTest.assertTrue((String)"Collection shouldn't contain illegal element", (!set.contains(i) ? 1 : 0) != 0);
    }

    public void testIllegalAddAll() {
        PredicatedSet set = this.makeTestSet();
        HashSet<Object> elements = new HashSet<Object>();
        elements.add("one");
        elements.add("two");
        elements.add(3);
        elements.add("four");
        try {
            set.addAll(elements);
            PredicatedSetTest.fail((String)"Integer should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("one") ? 1 : 0) != 0);
        PredicatedSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("two") ? 1 : 0) != 0);
        PredicatedSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains(3) ? 1 : 0) != 0);
        PredicatedSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("four") ? 1 : 0) != 0);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

