/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.CompositeSet;
import org.apache.commons.collections4.set.EmptySetMutator;

public class CompositeSetTest<E>
extends AbstractSetTest<E> {
    public CompositeSetTest(String name) {
        super(name);
    }

    @Override
    public CompositeSet<E> makeObject() {
        HashSet contained = new HashSet();
        CompositeSet set = new CompositeSet(contained);
        set.setMutator(new EmptySetMutator(contained));
        return set;
    }

    public Set<E> buildOne() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        return set;
    }

    public Set<E> buildTwo() {
        HashSet<String> set = new HashSet<String>();
        set.add("3");
        set.add("4");
        return set;
    }

    public void testContains() {
        CompositeSet set = new CompositeSet(new Set[]{this.buildOne(), this.buildTwo()});
        CompositeSetTest.assertTrue((boolean)set.contains((Object)"1"));
    }

    public void testRemoveUnderlying() {
        Set<E> one = this.buildOne();
        Set<E> two = this.buildTwo();
        CompositeSet set = new CompositeSet(new Set[]{one, two});
        one.remove("1");
        CompositeSetTest.assertFalse((boolean)set.contains((Object)"1"));
        two.remove("3");
        CompositeSetTest.assertFalse((boolean)set.contains((Object)"3"));
    }

    public void testRemoveComposited() {
        Set<E> one = this.buildOne();
        Set<E> two = this.buildTwo();
        CompositeSet set = new CompositeSet(new Set[]{one, two});
        set.remove((Object)"1");
        CompositeSetTest.assertFalse((boolean)one.contains("1"));
        set.remove((Object)"3");
        CompositeSetTest.assertFalse((boolean)one.contains("3"));
    }

    public void testFailedCollisionResolution() {
        Set<E> one = this.buildOne();
        Set<E> two = this.buildTwo();
        CompositeSet set = new CompositeSet(new Set[]{one, two});
        set.setMutator(new CompositeSet.SetMutator<E>(){
            private static final long serialVersionUID = 1L;

            public void resolveCollision(CompositeSet<E> comp, Set<E> existing, Set<E> added, Collection<E> intersects) {
            }

            public boolean add(CompositeSet<E> composite, List<Set<E>> collections, E obj) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(CompositeSet<E> composite, List<Set<E>> collections, Collection<? extends E> coll) {
                throw new UnsupportedOperationException();
            }
        });
        HashSet<String> three = new HashSet<String>();
        three.add("1");
        try {
            set.addComposited(three);
            CompositeSetTest.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testAddComposited() {
        Set<E> one = this.buildOne();
        Set<E> two = this.buildTwo();
        CompositeSet set = new CompositeSet();
        set.addComposited(one, two);
        CompositeSet set2 = new CompositeSet(this.buildOne());
        set2.addComposited(this.buildTwo());
        CompositeSetTest.assertTrue((boolean)set.equals((Object)set2));
        HashSet<String> set3 = new HashSet<String>();
        set3.add("1");
        set3.add("2");
        set3.add("3");
        HashSet<String> set4 = new HashSet<String>();
        set4.add("4");
        CompositeSet set5 = new CompositeSet(set3);
        set5.addComposited(set4);
        CompositeSetTest.assertTrue((boolean)set.equals((Object)set5));
        try {
            set.addComposited(set3);
            CompositeSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
    }

    public void testAddCompositedCollision() {
        HashSet<String> set1 = new HashSet<String>();
        set1.add("1");
        set1.add("2");
        set1.add("3");
        HashSet<String> set2 = new HashSet<String>();
        set2.add("4");
        CompositeSet set3 = new CompositeSet(set1);
        try {
            set3.addComposited(set1, this.buildOne());
            CompositeSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        try {
            set3.addComposited(new Set[]{set1, this.buildOne(), this.buildTwo()});
            CompositeSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

