/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.collection.AbstractCollectionTest;

public abstract class AbstractSetTest<E>
extends AbstractCollectionTest<E> {
    public AbstractSetTest(String name) {
        super(name);
    }

    @Override
    public void verify() {
        super.verify();
        AbstractSetTest.assertEquals((String)"Sets should be equal", (Object)this.getConfirmed(), (Object)this.getCollection());
        AbstractSetTest.assertEquals((String)"Sets should have equal hashCodes", (int)this.getConfirmed().hashCode(), (int)this.getCollection().hashCode());
        Collection set = this.makeConfirmedCollection();
        for (Object element : this.getCollection()) {
            AbstractSetTest.assertTrue((String)"Set.iterator should only return unique elements", (boolean)set.add(element));
        }
    }

    @Override
    public boolean isEqualsCheckable() {
        return true;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new HashSet();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        Collection set = this.makeConfirmedCollection();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    @Override
    public abstract Set<E> makeObject();

    @Override
    public Set<E> makeFullCollection() {
        Collection set = this.makeObject();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    @Override
    public Set<E> getCollection() {
        return (Set)super.getCollection();
    }

    @Override
    public Set<E> getConfirmed() {
        return (Set)super.getConfirmed();
    }

    public void testSetEquals() {
        this.resetEmpty();
        AbstractSetTest.assertEquals((String)"Empty sets should be equal", (Object)this.getCollection(), (Object)this.getConfirmed());
        this.verify();
        Collection<String> set2 = this.makeConfirmedCollection();
        set2.add("foo");
        AbstractSetTest.assertTrue((String)"Empty set shouldn't equal nonempty set", (!this.getCollection().equals(set2) ? 1 : 0) != 0);
        this.resetFull();
        AbstractSetTest.assertEquals((String)"Full sets should be equal", (Object)this.getCollection(), (Object)this.getConfirmed());
        this.verify();
        set2.clear();
        set2.addAll(Arrays.asList(this.getOtherElements()));
        AbstractSetTest.assertTrue((String)"Sets with different contents shouldn't be equal", (!this.getCollection().equals(set2) ? 1 : 0) != 0);
    }

    public void testSetHashCode() {
        this.resetEmpty();
        AbstractSetTest.assertEquals((String)"Empty sets have equal hashCodes", (int)this.getCollection().hashCode(), (int)this.getConfirmed().hashCode());
        this.resetFull();
        AbstractSetTest.assertEquals((String)"Equal sets have equal hashCodes", (int)this.getCollection().hashCode(), (int)this.getConfirmed().hashCode());
    }
}

