/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMapTest;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class HashSetValuedHashMapTest<K, V>
extends AbstractMultiValuedMapTest<K, V> {
    public HashSetValuedHashMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(HashSetValuedHashMapTest.class);
    }

    @Override
    public SetValuedMap<K, V> makeObject() {
        return new HashSetValuedHashMap();
    }

    @Override
    public MultiValuedMap<K, V> makeConfirmedMap() {
        return new HashSetValuedHashMap();
    }

    public void testSetValuedMapAdd() {
        SetValuedMap<K, V> setMap = this.makeObject();
        HashSetValuedHashMapTest.assertTrue((boolean)(setMap.get((Object)"whatever") instanceof Set));
        Set set = setMap.get((Object)"A");
        HashSetValuedHashMapTest.assertTrue((boolean)set.add("a1"));
        HashSetValuedHashMapTest.assertTrue((boolean)set.add("a2"));
        HashSetValuedHashMapTest.assertFalse((boolean)set.add("a1"));
        HashSetValuedHashMapTest.assertEquals((int)2, (int)setMap.size());
        HashSetValuedHashMapTest.assertTrue((boolean)setMap.containsKey((Object)"A"));
    }

    public void testSetValuedMapRemove() {
        SetValuedMap<K, V> setMap = this.makeObject();
        HashSetValuedHashMapTest.assertTrue((boolean)(setMap.get((Object)"whatever") instanceof Set));
        Set set = setMap.get((Object)"A");
        HashSetValuedHashMapTest.assertTrue((boolean)set.add("a1"));
        HashSetValuedHashMapTest.assertTrue((boolean)set.add("a2"));
        HashSetValuedHashMapTest.assertFalse((boolean)set.add("a1"));
        HashSetValuedHashMapTest.assertEquals((int)2, (int)setMap.size());
        HashSetValuedHashMapTest.assertTrue((boolean)setMap.containsKey((Object)"A"));
        HashSetValuedHashMapTest.assertTrue((boolean)set.remove("a1"));
        HashSetValuedHashMapTest.assertTrue((boolean)set.remove("a2"));
        HashSetValuedHashMapTest.assertFalse((boolean)set.remove("a1"));
        HashSetValuedHashMapTest.assertEquals((int)0, (int)setMap.size());
        HashSetValuedHashMapTest.assertFalse((boolean)setMap.containsKey((Object)"A"));
    }

    public void testSetValuedMapRemoveViaIterator() {
        SetValuedMap<K, V> setMap = this.makeObject();
        HashSetValuedHashMapTest.assertTrue((boolean)(setMap.get((Object)"whatever") instanceof Set));
        Set set = setMap.get((Object)"A");
        set.add("a1");
        set.add("a2");
        set.add("a1");
        Iterator it = set.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        HashSetValuedHashMapTest.assertEquals((int)0, (int)setMap.size());
        HashSetValuedHashMapTest.assertFalse((boolean)setMap.containsKey((Object)"A"));
    }

    public void testSetValuedMapEqualsHashCodeContract() {
        SetValuedMap<K, V> map1 = this.makeObject();
        SetValuedMap<K, V> map2 = this.makeObject();
        map1.put((Object)"a", (Object)"a1");
        map1.put((Object)"a", (Object)"a2");
        map2.put((Object)"a", (Object)"a2");
        map2.put((Object)"a", (Object)"a1");
        HashSetValuedHashMapTest.assertEquals(map1, map2);
        HashSetValuedHashMapTest.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map2.put((Object)"a", (Object)"a2");
        HashSetValuedHashMapTest.assertEquals(map1, map2);
        HashSetValuedHashMapTest.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map2.put((Object)"a", (Object)"a3");
        HashSetValuedHashMapTest.assertNotSame(map1, map2);
        HashSetValuedHashMapTest.assertNotSame((Object)map1.hashCode(), (Object)map2.hashCode());
    }
}

