/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.map.LazySortedMap;
import org.junit.Test;

public class LazySortedMapTest<K, V>
extends AbstractSortedMapTest<K, V> {
    private static final Factory<Integer> oneFactory = FactoryUtils.constantFactory((Object)1);

    public LazySortedMapTest(String testName) {
        super(testName);
    }

    @Override
    public SortedMap<K, V> makeObject() {
        return LazySortedMap.lazySortedMap(new TreeMap(), (Factory)FactoryUtils.nullFactory());
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public void testMapGet() {
    }

    @Test
    public void mapGet() {
        LazySortedMap map = LazySortedMap.lazySortedMap(new TreeMap(), oneFactory);
        LazySortedMapTest.assertEquals((int)0, (int)map.size());
        Number i1 = (Number)map.get(5);
        LazySortedMapTest.assertEquals((Object)1, (Object)i1);
        LazySortedMapTest.assertEquals((int)1, (int)map.size());
        map = LazySortedMap.lazySortedMap(new TreeMap(), (Factory)FactoryUtils.nullFactory());
        Number o = (Number)map.get(5);
        LazySortedMapTest.assertEquals(null, (Object)o);
        LazySortedMapTest.assertEquals((int)1, (int)map.size());
    }

    public void testSortOrder() {
        LazySortedMap map = LazySortedMap.lazySortedMap(new TreeMap(), oneFactory);
        map.put("A", 5);
        map.get("B");
        map.put("C", 8);
        LazySortedMapTest.assertEquals((String)"First key should be A", (String)"A", (String)((String)map.firstKey()));
        LazySortedMapTest.assertEquals((String)"Last key should be C", (String)"C", (String)((String)map.lastKey()));
        LazySortedMapTest.assertEquals((String)"First key in tail map should be B", (String)"B", (String)map.tailMap("B").firstKey());
        LazySortedMapTest.assertEquals((String)"Last key in head map should be B", (String)"B", (String)map.headMap("C").lastKey());
        LazySortedMapTest.assertEquals((String)"Last key in submap should be B", (String)"B", (String)map.subMap("A", "C").lastKey());
        Comparator c = map.comparator();
        LazySortedMapTest.assertTrue((String)"natural order, so comparator should be null", (c == null ? 1 : 0) != 0);
    }

    public void testTransformerDecorate() {
        Transformer transformer = TransformerUtils.asTransformer(oneFactory);
        LazySortedMap map = LazySortedMap.lazySortedMap(new TreeMap(), (Transformer)transformer);
        LazySortedMapTest.assertTrue((boolean)(map instanceof LazySortedMap));
        try {
            map = LazySortedMap.lazySortedMap(new TreeMap(), (Transformer)null);
            LazySortedMapTest.fail((String)"Expecting NullPointerException for null transformer");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            map = LazySortedMap.lazySortedMap((SortedMap)null, (Transformer)transformer);
            LazySortedMapTest.fail((String)"Expecting NullPointerException for null map");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

