/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.TreeList;

public class TreeListTest<E>
extends AbstractListTest<E> {
    public TreeListTest(String name) {
        super(name);
    }

    public static Test suite() {
        return BulkTest.makeSuite(TreeListTest.class);
    }

    public static void benchmark(List<? super Integer> l) {
        int i;
        long start = System.currentTimeMillis();
        for (i = 0; i < 100000; ++i) {
            l.add((Integer)i);
        }
        System.out.print(System.currentTimeMillis() - start + ";");
        start = System.currentTimeMillis();
        for (i = 0; i < 200; ++i) {
            l.toArray();
        }
        System.out.print(System.currentTimeMillis() - start + ";");
        start = System.currentTimeMillis();
        for (i = 0; i < 100; ++i) {
            Iterator<? super Integer> it = l.iterator();
            while (it.hasNext()) {
                it.next();
            }
        }
        System.out.print(System.currentTimeMillis() - start + ";");
        start = System.currentTimeMillis();
        for (i = 0; i < 10000; ++i) {
            int j = (int)(Math.random() * 100000.0);
            l.add(j, (Integer)(-j));
        }
        System.out.print(System.currentTimeMillis() - start + ";");
        start = System.currentTimeMillis();
        for (i = 0; i < 50000; ++i) {
            int j = (int)(Math.random() * 110000.0);
            l.get(j);
        }
        System.out.print(System.currentTimeMillis() - start + ";");
        start = System.currentTimeMillis();
        for (i = 0; i < 200; ++i) {
            int j = (int)(Math.random() * 100000.0);
            l.indexOf(j);
        }
        System.out.print(System.currentTimeMillis() - start + ";");
        start = System.currentTimeMillis();
        for (i = 0; i < 10000; ++i) {
            int j = (int)(Math.random() * 100000.0);
            l.remove(j);
        }
        System.out.print(System.currentTimeMillis() - start + ";");
    }

    @Override
    public TreeList<E> makeObject() {
        return new TreeList();
    }

    public void testAddMultiple() {
        TreeList<String> l = this.makeObject();
        l.add("hugo");
        l.add("erna");
        l.add("daniel");
        l.add("andres");
        l.add("harald");
        l.add(0, null);
        TreeListTest.assertEquals(null, l.get(0));
        TreeListTest.assertEquals((Object)"hugo", l.get(1));
        TreeListTest.assertEquals((Object)"erna", l.get(2));
        TreeListTest.assertEquals((Object)"daniel", l.get(3));
        TreeListTest.assertEquals((Object)"andres", l.get(4));
        TreeListTest.assertEquals((Object)"harald", l.get(5));
    }

    public void testRemove() {
        TreeList<String> l = this.makeObject();
        l.add("hugo");
        l.add("erna");
        l.add("daniel");
        l.add("andres");
        l.add("harald");
        l.add(0, null);
        int i = 0;
        TreeListTest.assertEquals(null, l.get(i++));
        TreeListTest.assertEquals((Object)"hugo", l.get(i++));
        TreeListTest.assertEquals((Object)"erna", l.get(i++));
        TreeListTest.assertEquals((Object)"daniel", l.get(i++));
        TreeListTest.assertEquals((Object)"andres", l.get(i++));
        TreeListTest.assertEquals((Object)"harald", l.get(i++));
        l.remove(0);
        i = 0;
        TreeListTest.assertEquals((Object)"hugo", l.get(i++));
        TreeListTest.assertEquals((Object)"erna", l.get(i++));
        TreeListTest.assertEquals((Object)"daniel", l.get(i++));
        TreeListTest.assertEquals((Object)"andres", l.get(i++));
        TreeListTest.assertEquals((Object)"harald", l.get(i++));
        i = 0;
        l.remove(1);
        TreeListTest.assertEquals((Object)"hugo", l.get(i++));
        TreeListTest.assertEquals((Object)"daniel", l.get(i++));
        TreeListTest.assertEquals((Object)"andres", l.get(i++));
        TreeListTest.assertEquals((Object)"harald", l.get(i++));
        i = 0;
        l.remove(2);
        TreeListTest.assertEquals((Object)"hugo", l.get(i++));
        TreeListTest.assertEquals((Object)"daniel", l.get(i++));
        TreeListTest.assertEquals((Object)"harald", l.get(i++));
    }

    public void testInsertBefore() {
        TreeList<String> l = this.makeObject();
        l.add("erna");
        l.add(0, "hugo");
        TreeListTest.assertEquals((Object)"hugo", l.get(0));
        TreeListTest.assertEquals((Object)"erna", l.get(1));
    }

    public void testIndexOf() {
        TreeList<String> l = this.makeObject();
        l.add("0");
        l.add("1");
        l.add("2");
        l.add("3");
        l.add("4");
        l.add("5");
        l.add("6");
        TreeListTest.assertEquals((int)0, (int)l.indexOf("0"));
        TreeListTest.assertEquals((int)1, (int)l.indexOf("1"));
        TreeListTest.assertEquals((int)2, (int)l.indexOf("2"));
        TreeListTest.assertEquals((int)3, (int)l.indexOf("3"));
        TreeListTest.assertEquals((int)4, (int)l.indexOf("4"));
        TreeListTest.assertEquals((int)5, (int)l.indexOf("5"));
        TreeListTest.assertEquals((int)6, (int)l.indexOf("6"));
        l.set(1, "0");
        TreeListTest.assertEquals((int)0, (int)l.indexOf("0"));
        l.set(3, "3");
        TreeListTest.assertEquals((int)3, (int)l.indexOf("3"));
        l.set(2, "3");
        TreeListTest.assertEquals((int)2, (int)l.indexOf("3"));
        l.set(1, "3");
        TreeListTest.assertEquals((int)1, (int)l.indexOf("3"));
        l.set(0, "3");
        TreeListTest.assertEquals((int)0, (int)l.indexOf("3"));
    }

    public void testBug35258() {
        Integer objectToRemove = 3;
        TreeList treelist = new TreeList();
        treelist.add(0);
        treelist.add(1);
        treelist.add(2);
        treelist.add(3);
        treelist.add(4);
        treelist.remove(objectToRemove);
        ListIterator li = treelist.listIterator();
        TreeListTest.assertEquals((Object)0, li.next());
        TreeListTest.assertEquals((Object)0, li.previous());
        TreeListTest.assertEquals((Object)0, li.next());
        TreeListTest.assertEquals((Object)1, li.next());
        TreeListTest.assertEquals((Object)1, li.previous());
        TreeListTest.assertEquals((Object)1, li.next());
        TreeListTest.assertEquals((Object)2, li.next());
        TreeListTest.assertEquals((Object)2, li.previous());
        TreeListTest.assertEquals((Object)2, li.next());
        TreeListTest.assertEquals((Object)4, li.next());
        TreeListTest.assertEquals((Object)4, li.previous());
        TreeListTest.assertEquals((Object)4, li.next());
        TreeListTest.assertEquals((boolean)false, (boolean)li.hasNext());
    }

    public void testBugCollections447() {
        TreeList treeList = new TreeList();
        treeList.add("A");
        treeList.add("B");
        treeList.add("C");
        treeList.add("D");
        ListIterator li = treeList.listIterator();
        TreeListTest.assertEquals((String)"A", (String)((String)li.next()));
        TreeListTest.assertEquals((String)"B", (String)((String)li.next()));
        TreeListTest.assertEquals((String)"B", (String)((String)li.previous()));
        li.remove();
        TreeListTest.assertEquals((String)"A", (String)((String)li.previous()));
    }

    public void testIterationOrder() {
        for (int size = 1; size < 1000; ++size) {
            Integer val;
            ArrayList<Integer> other = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                other.add(i);
            }
            TreeList l = new TreeList(other);
            ListIterator it = l.listIterator();
            int i = 0;
            while (it.hasNext()) {
                val = (Integer)it.next();
                TreeListTest.assertEquals((int)i++, (int)val);
            }
            while (it.hasPrevious()) {
                val = (Integer)it.previous();
                TreeListTest.assertEquals((int)(--i), (int)val);
            }
        }
    }

    public void testIterationOrderAfterAddAll() {
        int size = 1000;
        for (int i = 0; i < 100; ++i) {
            Integer val;
            ArrayList<Integer> other = new ArrayList<Integer>(size);
            for (int j = i; j < size; ++j) {
                other.add(j);
            }
            TreeList l = new TreeList();
            for (int j = 0; j < i; ++j) {
                l.add((Object)j);
            }
            l.addAll(other);
            ListIterator it = l.listIterator();
            int cnt = 0;
            while (it.hasNext()) {
                val = (Integer)it.next();
                TreeListTest.assertEquals((int)cnt++, (int)val);
            }
            while (it.hasPrevious()) {
                val = (Integer)it.previous();
                TreeListTest.assertEquals((int)(--cnt), (int)val);
            }
        }
    }
}

