/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.Map;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.keyvalue.AbstractMapEntryTest;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.collections4.keyvalue.UnmodifiableMapEntry;

public class UnmodifiableMapEntryTest<K, V>
extends AbstractMapEntryTest<K, V> {
    @Override
    public Map.Entry<K, V> makeMapEntry() {
        return new UnmodifiableMapEntry(null, null);
    }

    @Override
    public Map.Entry<K, V> makeMapEntry(K key, V value) {
        return new UnmodifiableMapEntry(key, value);
    }

    @Override
    public void testConstructors() {
        UnmodifiableMapEntry entry = new UnmodifiableMapEntry((Object)"name", (Object)"duke");
        UnmodifiableMapEntryTest.assertSame((Object)"name", entry.getKey());
        UnmodifiableMapEntryTest.assertSame((Object)"duke", entry.getValue());
        DefaultKeyValue pair = new DefaultKeyValue((Object)"name", (Object)"duke");
        entry = new UnmodifiableMapEntry((KeyValue)pair);
        UnmodifiableMapEntryTest.assertSame((Object)"name", entry.getKey());
        UnmodifiableMapEntryTest.assertSame((Object)"duke", entry.getValue());
        UnmodifiableMapEntry entry2 = new UnmodifiableMapEntry((Map.Entry)entry);
        UnmodifiableMapEntryTest.assertSame((Object)"name", entry2.getKey());
        UnmodifiableMapEntryTest.assertSame((Object)"duke", entry2.getValue());
        UnmodifiableMapEntryTest.assertTrue((boolean)(entry instanceof Unmodifiable));
    }

    @Override
    public void testAccessorsAndMutators() {
        Map.Entry<String, String> entry = this.makeMapEntry("name", "duke");
        UnmodifiableMapEntryTest.assertSame((Object)"name", (Object)entry.getKey());
        UnmodifiableMapEntryTest.assertSame((Object)"duke", (Object)entry.getValue());
        entry = this.makeMapEntry(null, null);
        UnmodifiableMapEntryTest.assertSame(null, (Object)entry.getKey());
        UnmodifiableMapEntryTest.assertSame(null, (Object)entry.getValue());
    }

    @Override
    public void testSelfReferenceHandling() {
    }

    public void testUnmodifiable() {
        Map.Entry<K, Object> entry = this.makeMapEntry();
        try {
            entry.setValue(null);
            UnmodifiableMapEntryTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

