/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.keyvalue.AbstractMapEntryTest;
import org.apache.commons.collections4.keyvalue.TiedMapEntry;

public class TiedMapEntryTest<K, V>
extends AbstractMapEntryTest<K, V> {
    @Override
    public Map.Entry<K, V> makeMapEntry(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return new TiedMapEntry(map, key);
    }

    @Override
    public void testConstructors() {
    }

    public void testSetValue() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "a");
        map.put("B", "b");
        map.put("C", "c");
        TiedMapEntry entry = new TiedMapEntry(map, (Object)"A");
        TiedMapEntryTest.assertSame((Object)"A", entry.getKey());
        TiedMapEntryTest.assertSame((Object)"a", entry.getValue());
        TiedMapEntryTest.assertSame((Object)"a", (Object)entry.setValue("x"));
        TiedMapEntryTest.assertSame((Object)"A", entry.getKey());
        TiedMapEntryTest.assertSame((Object)"x", entry.getValue());
        entry = new TiedMapEntry(map, (Object)"B");
        TiedMapEntryTest.assertSame((Object)"B", entry.getKey());
        TiedMapEntryTest.assertSame((Object)"b", entry.getValue());
        TiedMapEntryTest.assertSame((Object)"b", (Object)entry.setValue("y"));
        TiedMapEntryTest.assertSame((Object)"B", entry.getKey());
        TiedMapEntryTest.assertSame((Object)"y", entry.getValue());
        entry = new TiedMapEntry(map, (Object)"C");
        TiedMapEntryTest.assertSame((Object)"C", entry.getKey());
        TiedMapEntryTest.assertSame((Object)"c", entry.getValue());
        TiedMapEntryTest.assertSame((Object)"c", (Object)entry.setValue("z"));
        TiedMapEntryTest.assertSame((Object)"C", entry.getKey());
        TiedMapEntryTest.assertSame((Object)"z", entry.getValue());
    }
}

