/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.ObjectArrayIteratorTest;
import org.apache.commons.collections4.iterators.ObjectArrayListIterator;

public class ObjectArrayListIteratorTest<E>
extends ObjectArrayIteratorTest<E> {
    public ObjectArrayListIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public ObjectArrayListIterator<E> makeEmptyIterator() {
        return new ObjectArrayListIterator(new Object[0]);
    }

    @Override
    public ObjectArrayListIterator<E> makeObject() {
        return new ObjectArrayListIterator((Object[])this.testArray);
    }

    public ObjectArrayListIterator<E> makeArrayListIterator(E[] array) {
        return new ObjectArrayListIterator((Object[])array);
    }

    public void testListIterator() {
        ObjectArrayListIterator<E> iter = this.makeObject();
        while (iter.hasNext()) {
            iter.next();
        }
        for (int x = this.testArray.length - 1; x >= 0; --x) {
            String testValue = this.testArray[x];
            Object iterValue = iter.previous();
            ObjectArrayListIteratorTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
        ObjectArrayListIteratorTest.assertTrue((String)"Iterator should now be empty", (!iter.hasPrevious() ? 1 : 0) != 0);
        try {
            iter.previous();
        }
        catch (Exception e) {
            ObjectArrayListIteratorTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }

    public void testListIteratorSet() {
        Object[] testData = new String[]{"a", "b", "c"};
        Object[] result = new String[]{"0", "1", "2"};
        ObjectArrayListIterator<Object> iter = this.makeArrayListIterator((Object[])testData);
        int x = 0;
        while (iter.hasNext()) {
            iter.next();
            iter.set(Integer.toString(x));
            ++x;
        }
        ObjectArrayListIteratorTest.assertTrue((String)"The two arrays should have the same value, i.e. {0,1,2}", (boolean)Arrays.equals(testData, result));
        iter = this.makeArrayListIterator((Object[])this.testArray);
        try {
            iter.set("should fail");
            ObjectArrayListIteratorTest.fail((String)"ListIterator#set should fail if next() or previous() have not yet been called.");
        }
        catch (IllegalStateException e) {
        }
        catch (Throwable t) {
            ObjectArrayListIteratorTest.fail((String)t.toString());
        }
    }
}

