/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.ArrayIteratorTest;
import org.apache.commons.collections4.iterators.ArrayListIterator;

public class ArrayListIteratorTest<E>
extends ArrayIteratorTest<E> {
    public ArrayListIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public ArrayListIterator<E> makeEmptyIterator() {
        return new ArrayListIterator((Object)new Object[0]);
    }

    @Override
    public ArrayListIterator<E> makeObject() {
        return new ArrayListIterator((Object)this.testArray);
    }

    public ArrayListIterator<E> makeArrayListIterator(Object array) {
        return new ArrayListIterator(array);
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    public void testListIterator() {
        ArrayListIterator<E> iter = this.makeObject();
        while (iter.hasNext()) {
            iter.next();
        }
        for (int x = this.testArray.length - 1; x >= 0; --x) {
            String testValue = this.testArray[x];
            Object iterValue = iter.previous();
            ArrayListIteratorTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
        ArrayListIteratorTest.assertTrue((String)"Iterator should now be empty", (!iter.hasPrevious() ? 1 : 0) != 0);
        try {
            iter.previous();
        }
        catch (Exception e) {
            ArrayListIteratorTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }

    public void testListIteratorSet() {
        Object[] testData = new String[]{"a", "b", "c"};
        Object[] result = new String[]{"0", "1", "2"};
        ArrayListIterator<String> iter = this.makeArrayListIterator(testData);
        int x = 0;
        while (iter.hasNext()) {
            iter.next();
            iter.set(Integer.toString(x));
            ++x;
        }
        ArrayListIteratorTest.assertTrue((String)"The two arrays should have the same value, i.e. {0,1,2}", (boolean)Arrays.equals(testData, result));
        iter = this.makeArrayListIterator(this.testArray);
        try {
            iter.set("should fail");
            ArrayListIteratorTest.fail((String)"ListIterator#set should fail if next() or previous() have not yet been called.");
        }
        catch (IllegalStateException e) {
        }
        catch (Throwable t) {
            ArrayListIteratorTest.fail((String)t.toString());
        }
    }
}

