/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.trie;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatriciaTrieTest<V>
extends AbstractSortedMapTest<String, V> {
    public PatriciaTrieTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(PatriciaTrieTest.class);
    }

    @Override
    public SortedMap<String, V> makeObject() {
        return new PatriciaTrie();
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    public void testPrefixMap() {
        Object o;
        String[] keys;
        PatriciaTrie trie = new PatriciaTrie();
        for (String key : keys = new String[]{"", "Albert", "Xavier", "XyZ", "Anna", "Alien", "Alberto", "Alberts", "Allie", "Alliese", "Alabama", "Banane", "Blabla", "Amber", "Ammun", "Akka", "Akko", "Albertoo", "Amma"}) {
            trie.put((Object)key, (Object)key);
        }
        SortedMap map = trie.prefixMap((Object)"Al");
        Assert.assertEquals((long)8L, (long)map.size());
        Assert.assertEquals((Object)"Alabama", map.firstKey());
        Assert.assertEquals((Object)"Alliese", map.lastKey());
        Assert.assertEquals((Object)"Albertoo", map.get("Albertoo"));
        Assert.assertNotNull((Object)trie.get((Object)"Xavier"));
        Assert.assertNull(map.get("Xavier"));
        Assert.assertNull((Object)trie.get((Object)"Alice"));
        Assert.assertNull(map.get("Alice"));
        Iterator<Object> iterator = map.values().iterator();
        Assert.assertEquals((Object)"Alabama", iterator.next());
        Assert.assertEquals((Object)"Albert", iterator.next());
        Assert.assertEquals((Object)"Alberto", iterator.next());
        Assert.assertEquals((Object)"Albertoo", iterator.next());
        Assert.assertEquals((Object)"Alberts", iterator.next());
        Assert.assertEquals((Object)"Alien", iterator.next());
        Assert.assertEquals((Object)"Allie", iterator.next());
        Assert.assertEquals((Object)"Alliese", iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Albert");
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Albert", (Object)iterator.next());
        Assert.assertEquals((Object)"Alberto", (Object)iterator.next());
        Assert.assertEquals((Object)"Albertoo", (Object)iterator.next());
        Assert.assertEquals((Object)"Alberts", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)4L, (long)map.size());
        Assert.assertEquals((Object)"Albert", map.firstKey());
        Assert.assertEquals((Object)"Alberts", map.lastKey());
        Assert.assertNull((Object)trie.get((Object)"Albertz"));
        map.put("Albertz", "Albertz");
        Assert.assertEquals((Object)"Albertz", (Object)trie.get((Object)"Albertz"));
        Assert.assertEquals((long)5L, (long)map.size());
        Assert.assertEquals((Object)"Albertz", map.lastKey());
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Albert", (Object)iterator.next());
        Assert.assertEquals((Object)"Alberto", (Object)iterator.next());
        Assert.assertEquals((Object)"Albertoo", (Object)iterator.next());
        Assert.assertEquals((Object)"Alberts", (Object)iterator.next());
        Assert.assertEquals((Object)"Albertz", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"Albertz", map.remove("Albertz"));
        map = trie.prefixMap((Object)"Alberto");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"Alberto", map.firstKey());
        Assert.assertEquals((Object)"Albertoo", map.lastKey());
        Iterator entryIterator = map.entrySet().iterator();
        Map.Entry entry = entryIterator.next();
        Assert.assertEquals((Object)"Alberto", entry.getKey());
        Assert.assertEquals((Object)"Alberto", entry.getValue());
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Albertoo", entry.getKey());
        Assert.assertEquals((Object)"Albertoo", entry.getValue());
        Assert.assertFalse((boolean)entryIterator.hasNext());
        trie.put((Object)"Albertoad", (Object)"Albertoad");
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)"Alberto", map.firstKey());
        Assert.assertEquals((Object)"Albertoo", map.lastKey());
        entryIterator = map.entrySet().iterator();
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Alberto", entry.getKey());
        Assert.assertEquals((Object)"Alberto", entry.getValue());
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Albertoad", entry.getKey());
        Assert.assertEquals((Object)"Albertoad", entry.getValue());
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Albertoo", entry.getKey());
        Assert.assertEquals((Object)"Albertoo", entry.getValue());
        Assert.assertFalse((boolean)entryIterator.hasNext());
        Assert.assertEquals((Object)"Albertoo", (Object)trie.remove((Object)"Albertoo"));
        Assert.assertEquals((Object)"Alberto", map.firstKey());
        Assert.assertEquals((Object)"Albertoad", map.lastKey());
        Assert.assertEquals((long)2L, (long)map.size());
        entryIterator = map.entrySet().iterator();
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Alberto", entry.getKey());
        Assert.assertEquals((Object)"Alberto", entry.getValue());
        entry = entryIterator.next();
        Assert.assertEquals((Object)"Albertoad", entry.getKey());
        Assert.assertEquals((Object)"Albertoad", entry.getValue());
        Assert.assertFalse((boolean)entryIterator.hasNext());
        Assert.assertEquals((Object)"Albertoad", (Object)trie.remove((Object)"Albertoad"));
        trie.put((Object)"Albertoo", (Object)"Albertoo");
        map = trie.prefixMap((Object)"X");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertFalse((boolean)map.containsKey("Albert"));
        Assert.assertTrue((boolean)map.containsKey("Xavier"));
        Assert.assertFalse((boolean)map.containsKey("Xalan"));
        iterator = map.values().iterator();
        Assert.assertEquals((Object)"Xavier", (Object)iterator.next());
        Assert.assertEquals((Object)"XyZ", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"An");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Anna", map.firstKey());
        Assert.assertEquals((Object)"Anna", map.lastKey());
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Anna", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Ban");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Banane", map.firstKey());
        Assert.assertEquals((Object)"Banane", map.lastKey());
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Banane", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Am");
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)"Amber", (Object)trie.remove((Object)"Amber"));
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Amma", (Object)iterator.next());
        Assert.assertEquals((Object)"Ammun", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = map.keySet().iterator();
        map.put("Amber", "Amber");
        Assert.assertEquals((long)3L, (long)map.size());
        try {
            iterator.next();
            Assert.fail((String)"CME expected");
        }
        catch (ConcurrentModificationException expected) {
            // empty catch block
        }
        Assert.assertEquals((Object)"Amber", map.firstKey());
        Assert.assertEquals((Object)"Ammun", map.lastKey());
        map = trie.prefixMap((Object)"Ak\u0000");
        Assert.assertTrue((boolean)map.isEmpty());
        map = trie.prefixMap((Object)"Ak");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"Akka", map.firstKey());
        Assert.assertEquals((Object)"Akko", map.lastKey());
        map.put("Ak", "Ak");
        Assert.assertEquals((Object)"Ak", map.firstKey());
        Assert.assertEquals((Object)"Akko", map.lastKey());
        Assert.assertEquals((long)3L, (long)map.size());
        trie.put((Object)"Al", (Object)"Al");
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)"Ak", map.remove("Ak"));
        Assert.assertEquals((Object)"Akka", map.firstKey());
        Assert.assertEquals((Object)"Akko", map.lastKey());
        Assert.assertEquals((long)2L, (long)map.size());
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Akka", (Object)iterator.next());
        Assert.assertEquals((Object)"Akko", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"Al", (Object)trie.remove((Object)"Al"));
        map = trie.prefixMap((Object)"Akka");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Akka", map.firstKey());
        Assert.assertEquals((Object)"Akka", map.lastKey());
        iterator = map.keySet().iterator();
        Assert.assertEquals((Object)"Akka", (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Ab");
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)0L, (long)map.size());
        try {
            o = map.firstKey();
            Assert.fail((String)("got a first key: " + o));
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        try {
            o = map.lastKey();
            Assert.fail((String)("got a last key: " + o));
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        iterator = map.values().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Albertooo");
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)0L, (long)map.size());
        try {
            o = map.firstKey();
            Assert.fail((String)("got a first key: " + o));
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        try {
            o = map.lastKey();
            Assert.fail((String)("got a last key: " + o));
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        iterator = map.values().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"");
        Assert.assertSame((Object)trie, (Object)map);
        map = trie.prefixMap((Object)"\u0000");
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)0L, (long)map.size());
        try {
            o = map.firstKey();
            Assert.fail((String)("got a first key: " + o));
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        try {
            o = map.lastKey();
            Assert.fail((String)("got a last key: " + o));
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        iterator = map.values().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testPrefixMapRemoval() {
        String[] keys;
        PatriciaTrie trie = new PatriciaTrie();
        for (String key : keys = new String[]{"Albert", "Xavier", "XyZ", "Anna", "Alien", "Alberto", "Alberts", "Allie", "Alliese", "Alabama", "Banane", "Blabla", "Amber", "Ammun", "Akka", "Akko", "Albertoo", "Amma"}) {
            trie.put((Object)key, (Object)key);
        }
        SortedMap map = trie.prefixMap((Object)"Al");
        Assert.assertEquals((long)8L, (long)map.size());
        Iterator iter = map.keySet().iterator();
        Assert.assertEquals((Object)"Alabama", iter.next());
        Assert.assertEquals((Object)"Albert", iter.next());
        Assert.assertEquals((Object)"Alberto", iter.next());
        Assert.assertEquals((Object)"Albertoo", iter.next());
        Assert.assertEquals((Object)"Alberts", iter.next());
        Assert.assertEquals((Object)"Alien", iter.next());
        iter.remove();
        Assert.assertEquals((long)7L, (long)map.size());
        Assert.assertEquals((Object)"Allie", iter.next());
        Assert.assertEquals((Object)"Alliese", iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        map = trie.prefixMap((Object)"Ak");
        Assert.assertEquals((long)2L, (long)map.size());
        iter = map.keySet().iterator();
        Assert.assertEquals((Object)"Akka", iter.next());
        iter.remove();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Akko", iter.next());
        if (iter.hasNext()) {
            Assert.fail((String)("shouldn't have next (but was: " + (String)iter.next() + ")"));
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

