/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.set.AbstractSortedSetTest;
import org.apache.commons.collections4.set.UnmodifiableSortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableSortedSetTest<E>
extends AbstractSortedSetTest<E> {
    protected UnmodifiableSortedSet<E> set = null;
    protected ArrayList<E> array = null;

    public UnmodifiableSortedSetTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(UnmodifiableSortedSetTest.class);
    }

    @Override
    public SortedSet<E> makeObject() {
        return UnmodifiableSortedSet.unmodifiableSortedSet(new TreeSet());
    }

    @Override
    public UnmodifiableSortedSet<E> makeFullCollection() {
        TreeSet set = new TreeSet();
        set.addAll(Arrays.asList(this.getFullElements()));
        return (UnmodifiableSortedSet)UnmodifiableSortedSet.unmodifiableSortedSet(set);
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    protected void setupSet() {
        this.set = this.makeFullCollection();
        this.array = new ArrayList();
        this.array.add(1);
    }

    public void testUnmodifiable() {
        this.setupSet();
        this.verifyUnmodifiable((Set<E>)this.set);
        this.verifyUnmodifiable(this.set.headSet((Object)1));
        this.verifyUnmodifiable(this.set.tailSet((Object)1));
        this.verifyUnmodifiable(this.set.subSet((Object)1, (Object)3));
    }

    public void testDecorateFactory() {
        UnmodifiableSortedSet<E> set = this.makeFullCollection();
        UnmodifiableSortedSetTest.assertSame(set, (Object)UnmodifiableSortedSet.unmodifiableSortedSet(set));
        try {
            UnmodifiableSortedSet.unmodifiableSortedSet(null);
            UnmodifiableSortedSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void verifyUnmodifiable(Set<E> set) {
        try {
            set.add("value");
            UnmodifiableSortedSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            set.addAll(new TreeSet());
            UnmodifiableSortedSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            set.clear();
            UnmodifiableSortedSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            set.remove("x");
            UnmodifiableSortedSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            set.removeAll(this.array);
            UnmodifiableSortedSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            set.retainAll(this.array);
            UnmodifiableSortedSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testComparator() {
        this.setupSet();
        Comparator c = this.set.comparator();
        UnmodifiableSortedSetTest.assertTrue((String)"natural order, so comparator should be null", (c == null ? 1 : 0) != 0);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

