/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.OrderedIterator;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.ListOrderedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOrderedSetTest<E>
extends AbstractSetTest<E> {
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final Integer THREE = 3;

    public ListOrderedSetTest(String testName) {
        super(testName);
    }

    @Override
    public ListOrderedSet<E> makeObject() {
        return ListOrderedSet.listOrderedSet(new HashSet());
    }

    protected ListOrderedSet<E> setupSet() {
        ListOrderedSet<E> set = this.makeObject();
        for (int i = 0; i < 10; ++i) {
            set.add((Object)Integer.toString(i));
        }
        return set;
    }

    public void testOrdering() {
        int i;
        ListOrderedSet<E> set = this.setupSet();
        OrderedIterator it = set.iterator();
        for (i = 0; i < 10; ++i) {
            ListOrderedSetTest.assertEquals((String)"Sequence is wrong", (Object)Integer.toString(i), it.next());
        }
        for (i = 0; i < 10; i += 2) {
            ListOrderedSetTest.assertTrue((String)"Must be able to remove int", (boolean)set.remove((Object)Integer.toString(i)));
        }
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            ListOrderedSetTest.assertEquals((String)"Sequence is wrong after remove ", (Object)Integer.toString(i), it.next());
        }
        for (i = 0; i < 10; ++i) {
            set.add((Object)Integer.toString(i));
        }
        ListOrderedSetTest.assertEquals((String)"Size of set is wrong!", (int)10, (int)set.size());
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            ListOrderedSetTest.assertEquals((String)"Sequence is wrong", (Object)Integer.toString(i), it.next());
        }
        for (i = 0; i < 10; i += 2) {
            ListOrderedSetTest.assertEquals((String)"Sequence is wrong", (Object)Integer.toString(i), it.next());
        }
    }

    public void testListAddRemove() {
        ListOrderedSet<E> set = this.makeObject();
        List view = set.asList();
        set.add((Object)ZERO);
        set.add((Object)ONE);
        set.add((Object)TWO);
        ListOrderedSetTest.assertEquals((int)3, (int)set.size());
        ListOrderedSetTest.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSetTest.assertSame((Object)ONE, (Object)set.get(1));
        ListOrderedSetTest.assertSame((Object)TWO, (Object)set.get(2));
        ListOrderedSetTest.assertEquals((int)3, (int)view.size());
        ListOrderedSetTest.assertSame((Object)ZERO, view.get(0));
        ListOrderedSetTest.assertSame((Object)ONE, view.get(1));
        ListOrderedSetTest.assertSame((Object)TWO, view.get(2));
        ListOrderedSetTest.assertEquals((int)0, (int)set.indexOf((Object)ZERO));
        ListOrderedSetTest.assertEquals((int)1, (int)set.indexOf((Object)ONE));
        ListOrderedSetTest.assertEquals((int)2, (int)set.indexOf((Object)TWO));
        set.remove(1);
        ListOrderedSetTest.assertEquals((int)2, (int)set.size());
        ListOrderedSetTest.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSetTest.assertSame((Object)TWO, (Object)set.get(1));
        ListOrderedSetTest.assertEquals((int)2, (int)view.size());
        ListOrderedSetTest.assertSame((Object)ZERO, view.get(0));
        ListOrderedSetTest.assertSame((Object)TWO, view.get(1));
    }

    public void testListAddIndexed() {
        ListOrderedSet<E> set = this.makeObject();
        set.add((Object)ZERO);
        set.add((Object)TWO);
        set.add(1, (Object)ONE);
        ListOrderedSetTest.assertEquals((int)3, (int)set.size());
        ListOrderedSetTest.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSetTest.assertSame((Object)ONE, (Object)set.get(1));
        ListOrderedSetTest.assertSame((Object)TWO, (Object)set.get(2));
        set.add(0, (Object)ONE);
        ListOrderedSetTest.assertEquals((int)3, (int)set.size());
        ListOrderedSetTest.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSetTest.assertSame((Object)ONE, (Object)set.get(1));
        ListOrderedSetTest.assertSame((Object)TWO, (Object)set.get(2));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(ZERO);
        list.add(TWO);
        set.addAll(0, list);
        ListOrderedSetTest.assertEquals((int)3, (int)set.size());
        ListOrderedSetTest.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSetTest.assertSame((Object)ONE, (Object)set.get(1));
        ListOrderedSetTest.assertSame((Object)TWO, (Object)set.get(2));
        list.add(0, THREE);
        set.remove((Object)TWO);
        set.addAll(1, list);
        ListOrderedSetTest.assertEquals((int)4, (int)set.size());
        ListOrderedSetTest.assertSame((Object)ZERO, (Object)set.get(0));
        ListOrderedSetTest.assertSame((Object)THREE, (Object)set.get(1));
        ListOrderedSetTest.assertSame((Object)TWO, (Object)set.get(2));
        ListOrderedSetTest.assertSame((Object)ONE, (Object)set.get(3));
    }

    public void testListAddReplacing() {
        ListOrderedSet<E> set = this.makeObject();
        A a = new A();
        B b = new B();
        set.add((Object)a);
        ListOrderedSetTest.assertEquals((int)1, (int)set.size());
        set.add((Object)b);
        ListOrderedSetTest.assertEquals((int)1, (int)set.size());
        ListOrderedSetTest.assertSame((Object)a, set.decorated().iterator().next());
        ListOrderedSetTest.assertSame((Object)a, (Object)set.iterator().next());
        ListOrderedSetTest.assertSame((Object)a, (Object)set.get(0));
        ListOrderedSetTest.assertSame((Object)a, set.asList().get(0));
    }

    public void testRetainAll() {
        ArrayList list = new ArrayList(10);
        HashSet set = new HashSet(10);
        ListOrderedSet orderedSet = ListOrderedSet.listOrderedSet(set, list);
        for (int i = 0; i < 10; ++i) {
            orderedSet.add((Object)(10 - i - 1));
        }
        ArrayList<Integer> retained = new ArrayList<Integer>(5);
        for (int i = 0; i < 5; ++i) {
            retained.add(i * 2);
        }
        ListOrderedSetTest.assertTrue((boolean)orderedSet.retainAll(retained));
        ListOrderedSetTest.assertEquals((int)5, (int)orderedSet.size());
        ListOrderedSetTest.assertEquals((Object)8, (Object)orderedSet.get(0));
        ListOrderedSetTest.assertEquals((Object)6, (Object)orderedSet.get(1));
        ListOrderedSetTest.assertEquals((Object)4, (Object)orderedSet.get(2));
        ListOrderedSetTest.assertEquals((Object)2, (Object)orderedSet.get(3));
        ListOrderedSetTest.assertEquals((Object)0, (Object)orderedSet.get(4));
    }

    public void testRetainAllCollections426() {
        int size = 100000;
        ListOrderedSet set = new ListOrderedSet();
        for (int i = 0; i < 100000; ++i) {
            set.add((Object)i);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 100000; i < 200000; ++i) {
            list.add(i);
        }
        long start = System.currentTimeMillis();
        set.retainAll(list);
        long stop = System.currentTimeMillis();
        ListOrderedSetTest.assertTrue((stop - start < 5000L ? 1 : 0) != 0);
    }

    public void testDecorator() {
        try {
            ListOrderedSet.listOrderedSet((List)null);
            ListOrderedSetTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ListOrderedSet.listOrderedSet((Set)null);
            ListOrderedSetTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ListOrderedSet.listOrderedSet(null, null);
            ListOrderedSetTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ListOrderedSet.listOrderedSet(new HashSet(), null);
            ListOrderedSetTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ListOrderedSet.listOrderedSet(null, new ArrayList());
            ListOrderedSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    static class B {
        B() {
        }

        public boolean equals(Object obj) {
            return obj instanceof A || obj instanceof B;
        }

        public int hashCode() {
            return 1;
        }
    }

    static class A {
        A() {
        }

        public boolean equals(Object obj) {
            return obj instanceof A || obj instanceof B;
        }

        public int hashCode() {
            return 1;
        }
    }
}

