/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.commons.collections4.queue.AbstractQueueTest;
import org.apache.commons.collections4.queue.CircularFifoQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularFifoQueueTest<E>
extends AbstractQueueTest<E> {
    public CircularFifoQueueTest(String testName) {
        super(testName);
    }

    @Override
    public void verify() {
        super.verify();
        Iterator iterator1 = this.getCollection().iterator();
        for (Object e : this.getConfirmed()) {
            CircularFifoQueueTest.assertTrue((boolean)iterator1.hasNext());
            Object o1 = iterator1.next();
            Object o2 = e;
            CircularFifoQueueTest.assertEquals(o1, o2);
        }
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public boolean isFailFastSupported() {
        return false;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        Collection c = this.makeConfirmedCollection();
        c.addAll(Arrays.asList(this.getFullElements()));
        return c;
    }

    @Override
    public Queue<E> makeObject() {
        return new CircularFifoQueue(100);
    }

    public void testCircularFifoQueueCircular() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("C");
        CircularFifoQueue queue = new CircularFifoQueue(list);
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)queue.contains("A"));
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)queue.contains("B"));
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)queue.contains("C"));
        queue.add("D");
        CircularFifoQueueTest.assertEquals((boolean)false, (boolean)queue.contains("A"));
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)queue.contains("B"));
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)queue.contains("C"));
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)queue.contains("D"));
        CircularFifoQueueTest.assertEquals((Object)"B", queue.peek());
        CircularFifoQueueTest.assertEquals((Object)"B", queue.remove());
        CircularFifoQueueTest.assertEquals((Object)"C", queue.remove());
        CircularFifoQueueTest.assertEquals((Object)"D", queue.remove());
    }

    public void testCircularFifoQueueRemove() {
        this.resetFull();
        int size = this.getConfirmed().size();
        for (int i = 0; i < size; ++i) {
            Object o1 = this.getCollection().remove();
            Object o2 = ((List)this.getConfirmed()).remove(0);
            CircularFifoQueueTest.assertEquals((String)"Removed objects should be equal", (Object)o1, o2);
            this.verify();
        }
        try {
            this.getCollection().remove();
            CircularFifoQueueTest.fail((String)"Empty queue should raise Underflow.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testConstructorException1() {
        try {
            new CircularFifoQueue(0);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        CircularFifoQueueTest.fail();
    }

    public void testConstructorException2() {
        try {
            new CircularFifoQueue(-20);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        CircularFifoQueueTest.fail();
    }

    public void testConstructorException3() {
        try {
            new CircularFifoQueue(null);
        }
        catch (NullPointerException ex) {
            return;
        }
        CircularFifoQueueTest.fail();
    }

    public void testRemoveError1() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        CircularFifoQueueTest.assertEquals((String)"[1, 2, 3, 4, 5]", (String)fifo.toString());
        fifo.remove((Object)"3");
        CircularFifoQueueTest.assertEquals((String)"[1, 2, 4, 5]", (String)fifo.toString());
        fifo.remove((Object)"4");
        CircularFifoQueueTest.assertEquals((String)"[1, 2, 5]", (String)fifo.toString());
    }

    public void testRemoveError2() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        CircularFifoQueueTest.assertEquals((int)5, (int)fifo.size());
        CircularFifoQueueTest.assertEquals((String)"[2, 3, 4, 5, 6]", (String)fifo.toString());
        fifo.remove((Object)"3");
        CircularFifoQueueTest.assertEquals((String)"[2, 4, 5, 6]", (String)fifo.toString());
        fifo.remove((Object)"4");
        CircularFifoQueueTest.assertEquals((String)"[2, 5, 6]", (String)fifo.toString());
    }

    public void testRemoveError3() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        CircularFifoQueueTest.assertEquals((String)"[1, 2, 3, 4, 5]", (String)fifo.toString());
        fifo.remove((Object)"3");
        CircularFifoQueueTest.assertEquals((String)"[1, 2, 4, 5]", (String)fifo.toString());
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        CircularFifoQueueTest.assertEquals((String)"[2, 4, 5, 6, 7]", (String)fifo.toString());
        fifo.remove((Object)"4");
        CircularFifoQueueTest.assertEquals((String)"[2, 5, 6, 7]", (String)fifo.toString());
    }

    public void testRemoveError4() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        CircularFifoQueueTest.assertEquals((String)"[3, 4, 5, 6, 7]", (String)fifo.toString());
        fifo.remove((Object)"4");
        CircularFifoQueueTest.assertEquals((String)"[3, 5, 6, 7]", (String)fifo.toString());
    }

    public void testRemoveError5() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        CircularFifoQueueTest.assertEquals((String)"[3, 4, 5, 6, 7]", (String)fifo.toString());
        fifo.remove((Object)"5");
        CircularFifoQueueTest.assertEquals((String)"[3, 4, 6, 7]", (String)fifo.toString());
    }

    public void testRemoveError6() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        CircularFifoQueueTest.assertEquals((String)"[3, 4, 5, 6, 7]", (String)fifo.toString());
        fifo.remove((Object)"6");
        CircularFifoQueueTest.assertEquals((String)"[3, 4, 5, 7]", (String)fifo.toString());
    }

    public void testRemoveError7() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        CircularFifoQueueTest.assertEquals((String)"[3, 4, 5, 6, 7]", (String)fifo.toString());
        fifo.remove((Object)"7");
        CircularFifoQueueTest.assertEquals((String)"[3, 4, 5, 6]", (String)fifo.toString());
    }

    public void testRemoveError8() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        fifo.add((Object)"8");
        CircularFifoQueueTest.assertEquals((String)"[4, 5, 6, 7, 8]", (String)fifo.toString());
        fifo.remove((Object)"7");
        CircularFifoQueueTest.assertEquals((String)"[4, 5, 6, 8]", (String)fifo.toString());
    }

    public void testRemoveError9() throws Exception {
        CircularFifoQueue fifo = new CircularFifoQueue(5);
        fifo.add((Object)"1");
        fifo.add((Object)"2");
        fifo.add((Object)"3");
        fifo.add((Object)"4");
        fifo.add((Object)"5");
        fifo.add((Object)"6");
        fifo.add((Object)"7");
        fifo.add((Object)"8");
        CircularFifoQueueTest.assertEquals((String)"[4, 5, 6, 7, 8]", (String)fifo.toString());
        fifo.remove((Object)"8");
        CircularFifoQueueTest.assertEquals((String)"[4, 5, 6, 7]", (String)fifo.toString());
    }

    public void testRepeatedSerialization() throws Exception {
        CircularFifoQueue b = new CircularFifoQueue(2);
        b.add((Object)"a");
        CircularFifoQueueTest.assertEquals((int)1, (int)b.size());
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)b.contains((Object)"a"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        new ObjectOutputStream(bos).writeObject(b);
        CircularFifoQueue b2 = (CircularFifoQueue)new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray())).readObject();
        CircularFifoQueueTest.assertEquals((int)1, (int)b2.size());
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)b2.contains((Object)"a"));
        b2.add((Object)"b");
        CircularFifoQueueTest.assertEquals((int)2, (int)b2.size());
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)b2.contains((Object)"a"));
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)b2.contains((Object)"b"));
        bos = new ByteArrayOutputStream();
        new ObjectOutputStream(bos).writeObject(b2);
        CircularFifoQueue b3 = (CircularFifoQueue)new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray())).readObject();
        CircularFifoQueueTest.assertEquals((int)2, (int)b3.size());
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)b3.contains((Object)"a"));
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)b3.contains((Object)"b"));
        b3.add((Object)"c");
        CircularFifoQueueTest.assertEquals((int)2, (int)b3.size());
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)b3.contains((Object)"b"));
        CircularFifoQueueTest.assertEquals((boolean)true, (boolean)b3.contains((Object)"c"));
    }

    public void testGetIndex() {
        int i;
        this.resetFull();
        CircularFifoQueue<E> queue = this.getCollection();
        List confirmed = (List)this.getConfirmed();
        for (i = 0; i < confirmed.size(); ++i) {
            CircularFifoQueueTest.assertEquals(confirmed.get(i), (Object)queue.get(i));
        }
        queue.remove();
        queue.remove();
        for (i = 0; i < queue.size(); ++i) {
            CircularFifoQueueTest.assertEquals(confirmed.get(i + 2), (Object)queue.get(i));
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public CircularFifoQueue<E> getCollection() {
        return (CircularFifoQueue)super.getCollection();
    }
}

