/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.StaticBucketMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticBucketMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public StaticBucketMapTest(String name) {
        super(name);
    }

    public static Test suite() {
        return BulkTest.makeSuite(StaticBucketMapTest.class);
    }

    @Override
    public StaticBucketMap<K, V> makeObject() {
        return new StaticBucketMap(30);
    }

    @Override
    public boolean isFailFastExpected() {
        return false;
    }

    @Override
    public String[] ignoredTests() {
        String pre = "StaticBucketMapTest.bulkTestMap";
        String post = ".testCollectionIteratorFailFast";
        return new String[]{"StaticBucketMapTest.bulkTestMapEntrySet.testCollectionIteratorFailFast", "StaticBucketMapTest.bulkTestMapKeySet.testCollectionIteratorFailFast", "StaticBucketMapTest.bulkTestMapValues.testCollectionIteratorFailFast"};
    }

    public void test_get_nullMatchesIncorrectly() {
        StaticBucketMap map = new StaticBucketMap(17);
        map.put(null, (Object)"A");
        StaticBucketMapTest.assertEquals((Object)"A", (Object)map.get(null));
        for (int i = 65; i <= 90; ++i) {
            String str = String.valueOf((char)i);
            StaticBucketMapTest.assertEquals((String)("String: " + str), null, (Object)map.get((Object)str));
        }
    }

    public void test_containsKey_nullMatchesIncorrectly() {
        StaticBucketMap map = new StaticBucketMap(17);
        map.put(null, (Object)"A");
        StaticBucketMapTest.assertEquals((boolean)true, (boolean)map.containsKey(null));
        for (int i = 65; i <= 90; ++i) {
            String str = String.valueOf((char)i);
            StaticBucketMapTest.assertEquals((String)("String: " + str), (boolean)false, (boolean)map.containsKey((Object)str));
        }
    }

    public void test_containsValue_nullMatchesIncorrectly() {
        StaticBucketMap map = new StaticBucketMap(17);
        map.put((Object)"A", null);
        StaticBucketMapTest.assertEquals((boolean)true, (boolean)map.containsValue(null));
        for (int i = 65; i <= 90; ++i) {
            String str = String.valueOf((char)i);
            StaticBucketMapTest.assertEquals((String)("String: " + str), (boolean)false, (boolean)map.containsValue((Object)str));
        }
    }
}

