/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import junit.framework.Test;
import org.apache.commons.collections4.BoundedMap;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.map.AbstractOrderedMapTest;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.collections4.map.SingletonMap;
import org.apache.commons.collections4.map.UnmodifiableOrderedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonMapTest<K, V>
extends AbstractOrderedMapTest<K, V> {
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final String TEN = "10";

    public SingletonMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(SingletonMapTest.class);
    }

    @Override
    public OrderedMap<K, V> makeObject() {
        return UnmodifiableOrderedMap.unmodifiableOrderedMap((OrderedMap)ListOrderedMap.listOrderedMap(new HashMap()));
    }

    @Override
    public String[] ignoredTests() {
        return new String[]{"SingletonMapTest.bulkTestMapIterator.testEmptyMapIterator", "SingletonMapTest.bulkTestOrderedMapIterator.testEmptyMapIterator"};
    }

    @Override
    public SingletonMap<K, V> makeFullMap() {
        return new SingletonMap((Object)ONE, (Object)TWO);
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public K[] getSampleKeys() {
        return new Object[]{ONE};
    }

    @Override
    public V[] getSampleValues() {
        return new Object[]{TWO};
    }

    @Override
    public V[] getNewSampleValues() {
        return new Object[]{TEN};
    }

    public void testClone() {
        SingletonMap<K, V> map = this.makeFullMap();
        SingletonMapTest.assertEquals((int)1, (int)map.size());
        SingletonMap cloned = map.clone();
        SingletonMapTest.assertEquals((int)1, (int)cloned.size());
        SingletonMapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)ONE));
        SingletonMapTest.assertEquals((boolean)true, (boolean)cloned.containsValue((Object)TWO));
    }

    public void testKeyValue() {
        SingletonMap<K, V> map = this.makeFullMap();
        SingletonMapTest.assertEquals((int)1, (int)map.size());
        SingletonMapTest.assertEquals((Object)ONE, (Object)map.getKey());
        SingletonMapTest.assertEquals((Object)TWO, (Object)map.getValue());
        SingletonMapTest.assertTrue((boolean)(map instanceof KeyValue));
    }

    public void testBoundedMap() {
        SingletonMap<K, V> map = this.makeFullMap();
        SingletonMapTest.assertEquals((int)1, (int)map.size());
        SingletonMapTest.assertEquals((boolean)true, (boolean)map.isFull());
        SingletonMapTest.assertEquals((int)1, (int)map.maxSize());
        SingletonMapTest.assertTrue((boolean)(map instanceof BoundedMap));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

