/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.AbstractObjectTest;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.apache.commons.collections4.set.AbstractSetTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapTest<K, V>
extends AbstractObjectTest {
    private static final boolean JDK12;
    protected Map<K, V> map;
    protected Set<Map.Entry<K, V>> entrySet;
    protected Set<K> keySet;
    protected Collection<V> values;
    protected Map<K, V> confirmed;

    public AbstractMapTest(String testName) {
        super(testName);
    }

    public boolean isPutAddSupported() {
        return true;
    }

    public boolean isPutChangeSupported() {
        return true;
    }

    public boolean isSetValueSupported() {
        return this.isPutChangeSupported();
    }

    public boolean isRemoveSupported() {
        return true;
    }

    public boolean isGetStructuralModify() {
        return false;
    }

    public boolean isSubMapViewsSerializable() {
        return true;
    }

    public boolean isAllowNullKey() {
        return true;
    }

    public boolean isAllowNullValue() {
        return true;
    }

    public boolean isAllowDuplicateValues() {
        return true;
    }

    public boolean isFailFastExpected() {
        return true;
    }

    public K[] getSampleKeys() {
        Object[] result = new Object[]{"blah", "foo", "bar", "baz", "tmp", "gosh", "golly", "gee", "hello", "goodbye", "we'll", "see", "you", "all", "again", "key", "key2", this.isAllowNullKey() && !JDK12 ? null : "nonnullkey"};
        return result;
    }

    public K[] getOtherKeys() {
        return this.getOtherNonNullStringElements();
    }

    public V[] getOtherValues() {
        return this.getOtherNonNullStringElements();
    }

    protected <E> List<E> getAsList(Object[] o) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object element : o) {
            result.add(element);
        }
        return result;
    }

    public Object[] getOtherNonNullStringElements() {
        return new Object[]{"For", "then", "despite", "space", "I", "would", "be", "brought", "From", "limits", "far", "remote", "where", "thou", "dost", "stay"};
    }

    public V[] getSampleValues() {
        Object[] result = new Object[]{"blahv", "foov", "barv", "bazv", "tmpv", "goshv", "gollyv", "geev", "hellov", "goodbyev", "we'llv", "seev", "youv", "allv", "againv", this.isAllowNullValue() && !JDK12 ? null : "nonnullvalue", "value", this.isAllowDuplicateValues() ? "value" : "value2"};
        return result;
    }

    public V[] getNewSampleValues() {
        Object[] result = new Object[]{this.isAllowNullValue() && !JDK12 && this.isAllowDuplicateValues() ? null : "newnonnullvalue", "newvalue", this.isAllowDuplicateValues() ? "newvalue" : "newvalue2", "newblahv", "newfoov", "newbarv", "newbazv", "newtmpv", "newgoshv", "newgollyv", "newgeev", "newhellov", "newgoodbyev", "newwe'llv", "newseev", "newyouv", "newallv", "newagainv"};
        return result;
    }

    public void addSampleMappings(Map<? super K, ? super V> m) {
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (int i = 0; i < keys.length; ++i) {
            try {
                m.put(keys[i], values[i]);
                continue;
            }
            catch (NullPointerException exception) {
                AbstractMapTest.assertTrue((String)"NullPointerException only allowed to be thrown if either the key or value is null.", (keys[i] == null || values[i] == null ? 1 : 0) != 0);
                AbstractMapTest.assertTrue((String)"NullPointerException on null key, but isAllowNullKey is not overridden to return false.", (keys[i] == null || !this.isAllowNullKey() ? 1 : 0) != 0);
                AbstractMapTest.assertTrue((String)"NullPointerException on null value, but isAllowNullValue is not overridden to return false.", (values[i] == null || !this.isAllowNullValue() ? 1 : 0) != 0);
                AbstractMapTest.assertTrue((String)"Unknown reason for NullPointer.", (boolean)false);
            }
        }
        AbstractMapTest.assertEquals((String)"size must reflect number of mappings added.", (int)keys.length, (int)m.size());
    }

    @Override
    public abstract Map<K, V> makeObject();

    public Map<K, V> makeFullMap() {
        Object m = this.makeObject();
        this.addSampleMappings((Map<? super K, ? super V>)m);
        return m;
    }

    public Map<K, V> makeConfirmedMap() {
        return new HashMap();
    }

    public static <K, V> Map.Entry<K, V> cloneMapEntry(Map.Entry<K, V> entry) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(entry.getKey(), entry.getValue());
        return map.entrySet().iterator().next();
    }

    @Override
    public String getCompatibilityVersion() {
        return super.getCompatibilityVersion();
    }

    public void testSampleMappings() {
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        V[] newValues = this.getNewSampleValues();
        AbstractMapTest.assertNotNull((String)"failure in test: Must have keys returned from getSampleKeys.", keys);
        AbstractMapTest.assertNotNull((String)"failure in test: Must have values returned from getSampleValues.", values);
        AbstractMapTest.assertEquals((String)"failure in test: not the same number of sample keys and values.", (int)keys.length, (int)values.length);
        AbstractMapTest.assertEquals((String)"failure in test: not the same number of values and new values.", (int)values.length, (int)newValues.length);
        for (int i = 0; i < keys.length - 1; ++i) {
            for (int j = i + 1; j < keys.length; ++j) {
                AbstractMapTest.assertTrue((String)"failure in test: duplicate null keys.", (keys[i] != null || keys[j] != null ? 1 : 0) != 0);
                AbstractMapTest.assertTrue((String)"failure in test: duplicate non-null key.", (keys[i] == null || keys[j] == null || !keys[i].equals(keys[j]) && !keys[j].equals(keys[i]) ? 1 : 0) != 0);
            }
            AbstractMapTest.assertTrue((String)"failure in test: found null key, but isNullKeySupported is false.", (keys[i] != null || this.isAllowNullKey() ? 1 : 0) != 0);
            AbstractMapTest.assertTrue((String)"failure in test: found null value, but isNullValueSupported is false.", (values[i] != null || this.isAllowNullValue() ? 1 : 0) != 0);
            AbstractMapTest.assertTrue((String)"failure in test: found null new value, but isNullValueSupported is false.", (newValues[i] != null || this.isAllowNullValue() ? 1 : 0) != 0);
            AbstractMapTest.assertTrue((String)"failure in test: values should not be the same as new value", (values[i] != newValues[i] && (values[i] == null || !values[i].equals(newValues[i])) ? 1 : 0) != 0);
        }
    }

    public void testMakeMap() {
        Object em = this.makeObject();
        AbstractMapTest.assertTrue((String)"failure in test: makeEmptyMap must return a non-null map.", (em != null ? 1 : 0) != 0);
        Object em2 = this.makeObject();
        AbstractMapTest.assertTrue((String)"failure in test: makeEmptyMap must return a non-null map.", (em != null ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((String)"failure in test: makeEmptyMap must return a new map with each invocation.", (em != em2 ? 1 : 0) != 0);
        Map<K, V> fm = this.makeFullMap();
        AbstractMapTest.assertTrue((String)"failure in test: makeFullMap must return a non-null map.", (fm != null ? 1 : 0) != 0);
        Map<K, V> fm2 = this.makeFullMap();
        AbstractMapTest.assertTrue((String)"failure in test: makeFullMap must return a non-null map.", (fm != null ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((String)"failure in test: makeFullMap must return a new map with each invocation.", (fm != fm2 ? 1 : 0) != 0);
    }

    public void testMapIsEmpty() {
        this.resetEmpty();
        AbstractMapTest.assertEquals((String)"Map.isEmpty() should return true with an empty map", (boolean)true, (boolean)this.getMap().isEmpty());
        this.verify();
        this.resetFull();
        AbstractMapTest.assertEquals((String)"Map.isEmpty() should return false with a non-empty map", (boolean)false, (boolean)this.getMap().isEmpty());
        this.verify();
    }

    public void testMapSize() {
        this.resetEmpty();
        AbstractMapTest.assertEquals((String)"Map.size() should be 0 with an empty map", (int)0, (int)this.getMap().size());
        this.verify();
        this.resetFull();
        AbstractMapTest.assertEquals((String)"Map.size() should equal the number of entries in the map", (int)this.getSampleKeys().length, (int)this.getMap().size());
        this.verify();
    }

    public void testMapClear() {
        if (!this.isRemoveSupported()) {
            try {
                this.resetFull();
                this.getMap().clear();
                AbstractMapTest.fail((String)"Expected UnsupportedOperationException on clear");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
        this.resetEmpty();
        this.getMap().clear();
        this.getConfirmed().clear();
        this.verify();
        this.resetFull();
        this.getMap().clear();
        this.getConfirmed().clear();
        this.verify();
    }

    public void testMapContainsKey() {
        K[] keys = this.getSampleKeys();
        this.resetEmpty();
        for (K key : keys) {
            AbstractMapTest.assertTrue((String)"Map must not contain key when map is empty", (!this.getMap().containsKey(key) ? 1 : 0) != 0);
        }
        this.verify();
        this.resetFull();
        for (K key : keys) {
            AbstractMapTest.assertTrue((String)("Map must contain key for a mapping in the map. Missing: " + key), (boolean)this.getMap().containsKey(key));
        }
        this.verify();
    }

    public void testMapContainsValue() {
        V[] values = this.getSampleValues();
        this.resetEmpty();
        for (int i = 0; i < values.length; ++i) {
            AbstractMapTest.assertTrue((String)"Empty map must not contain value", (!this.getMap().containsValue(values[i]) ? 1 : 0) != 0);
        }
        this.verify();
        this.resetFull();
        for (V value : values) {
            AbstractMapTest.assertTrue((String)"Map must contain value for a mapping in the map.", (boolean)this.getMap().containsValue(value));
        }
        this.verify();
    }

    public void testMapEquals() {
        this.resetEmpty();
        AbstractMapTest.assertTrue((String)"Empty maps unequal.", (boolean)this.getMap().equals(this.confirmed));
        this.verify();
        this.resetFull();
        AbstractMapTest.assertTrue((String)"Full maps unequal.", (boolean)this.getMap().equals(this.confirmed));
        this.verify();
        this.resetFull();
        Iterator<K> iter = this.confirmed.keySet().iterator();
        iter.next();
        iter.remove();
        AbstractMapTest.assertTrue((String)"Different maps equal.", (!this.getMap().equals(this.confirmed) ? 1 : 0) != 0);
        this.resetFull();
        AbstractMapTest.assertTrue((String)"equals(null) returned true.", (!this.getMap().equals(null) ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((String)"equals(new Object()) returned true.", (!this.getMap().equals(new Object()) ? 1 : 0) != 0);
        this.verify();
    }

    public void testMapGet() {
        this.resetEmpty();
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (K key : keys) {
            AbstractMapTest.assertTrue((String)"Empty map.get() should return null.", (this.getMap().get(key) == null ? 1 : 0) != 0);
        }
        this.verify();
        this.resetFull();
        for (int i = 0; i < keys.length; ++i) {
            AbstractMapTest.assertEquals((String)"Full map.get() should return value from mapping.", values[i], this.getMap().get(keys[i]));
        }
    }

    public void testMapHashCode() {
        this.resetEmpty();
        AbstractMapTest.assertTrue((String)"Empty maps have different hashCodes.", (this.getMap().hashCode() == this.confirmed.hashCode() ? 1 : 0) != 0);
        this.resetFull();
        AbstractMapTest.assertTrue((String)"Equal maps have different hashCodes.", (this.getMap().hashCode() == this.confirmed.hashCode() ? 1 : 0) != 0);
    }

    public void testMapToString() {
        this.resetEmpty();
        AbstractMapTest.assertTrue((String)"Empty map toString() should not return null", (this.getMap().toString() != null ? 1 : 0) != 0);
        this.verify();
        this.resetFull();
        AbstractMapTest.assertTrue((String)"Empty map toString() should not return null", (this.getMap().toString() != null ? 1 : 0) != 0);
        this.verify();
    }

    public void testEmptyMapCompatibility() throws Exception {
        Object map = this.makeObject();
        if (map instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Map map2 = (Map)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(map));
            AbstractMapTest.assertEquals((String)"Map is empty", (int)0, (int)map2.size());
        }
    }

    public void testFullMapCompatibility() throws Exception {
        Map<K, V> map = this.makeFullMap();
        if (map instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Map map2 = (Map)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(map));
            AbstractMapTest.assertEquals((String)"Map is the right size", (int)this.getSampleKeys().length, (int)map2.size());
        }
    }

    public void testMapPut() {
        this.resetEmpty();
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        V[] newValues = this.getNewSampleValues();
        if (this.isPutAddSupported()) {
            V o;
            int i;
            for (i = 0; i < keys.length; ++i) {
                o = this.getMap().put(keys[i], values[i]);
                this.getConfirmed().put(keys[i], values[i]);
                this.verify();
                AbstractMapTest.assertTrue((String)"First map.put should return null", (o == null ? 1 : 0) != 0);
                AbstractMapTest.assertTrue((String)"Map should contain key after put", (boolean)this.getMap().containsKey(keys[i]));
                AbstractMapTest.assertTrue((String)"Map should contain value after put", (boolean)this.getMap().containsValue(values[i]));
            }
            if (this.isPutChangeSupported()) {
                for (i = 0; i < keys.length; ++i) {
                    o = this.getMap().put(keys[i], newValues[i]);
                    this.getConfirmed().put(keys[i], newValues[i]);
                    this.verify();
                    AbstractMapTest.assertEquals((String)"Map.put should return previous value when changed", values[i], o);
                    AbstractMapTest.assertTrue((String)"Map should still contain key after put when changed", (boolean)this.getMap().containsKey(keys[i]));
                    AbstractMapTest.assertTrue((String)"Map should contain new value after put when changed", (boolean)this.getMap().containsValue(newValues[i]));
                    if (this.isAllowDuplicateValues()) continue;
                    AbstractMapTest.assertTrue((String)"Map should not contain old value after put when changed", (!this.getMap().containsValue(values[i]) ? 1 : 0) != 0);
                }
            } else {
                try {
                    this.getMap().put(keys[0], newValues[0]);
                    AbstractMapTest.fail((String)"Expected IllegalArgumentException or UnsupportedOperationException on put (change)");
                }
                catch (IllegalArgumentException ex) {
                }
                catch (UnsupportedOperationException ex) {}
            }
        } else if (this.isPutChangeSupported()) {
            this.resetEmpty();
            try {
                this.getMap().put(keys[0], values[0]);
                AbstractMapTest.fail((String)"Expected UnsupportedOperationException or IllegalArgumentException on put (add) when fixed size");
            }
            catch (IllegalArgumentException ex) {
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            this.resetFull();
            Iterator<K> it = this.getMap().keySet().iterator();
            for (int i = 0; it.hasNext() && i < newValues.length; ++i) {
                K key = it.next();
                V o = this.getMap().put(key, newValues[i]);
                V value = this.getConfirmed().put(key, newValues[i]);
                this.verify();
                AbstractMapTest.assertEquals((String)"Map.put should return previous value when changed", value, o);
                AbstractMapTest.assertTrue((String)"Map should still contain key after put when changed", (boolean)this.getMap().containsKey(key));
                AbstractMapTest.assertTrue((String)"Map should contain new value after put when changed", (boolean)this.getMap().containsValue(newValues[i]));
                if (this.isAllowDuplicateValues()) continue;
                AbstractMapTest.assertTrue((String)"Map should not contain old value after put when changed", (!this.getMap().containsValue(values[i]) ? 1 : 0) != 0);
            }
        } else {
            try {
                this.getMap().put(keys[0], values[0]);
                AbstractMapTest.fail((String)"Expected UnsupportedOperationException on put (add)");
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
        }
    }

    public void testMapPutNullKey() {
        this.resetFull();
        V[] values = this.getSampleValues();
        if (this.isPutAddSupported()) {
            if (this.isAllowNullKey()) {
                this.getMap().put(null, values[0]);
            } else {
                try {
                    this.getMap().put(null, values[0]);
                    AbstractMapTest.fail((String)"put(null, value) should throw NPE/IAE");
                }
                catch (NullPointerException ex) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public void testMapPutNullValue() {
        this.resetFull();
        K[] keys = this.getSampleKeys();
        if (this.isPutAddSupported()) {
            if (this.isAllowNullValue()) {
                this.getMap().put(keys[0], null);
            } else {
                try {
                    this.getMap().put(keys[0], null);
                    AbstractMapTest.fail((String)"put(key, null) should throw NPE/IAE");
                }
                catch (NullPointerException ex) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public void testMapPutAll() {
        int i;
        if (!this.isPutAddSupported()) {
            if (!this.isPutChangeSupported()) {
                Map<K, V> temp = this.makeFullMap();
                this.resetEmpty();
                try {
                    this.getMap().putAll(temp);
                    AbstractMapTest.fail((String)"Expected UnsupportedOperationException on putAll");
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
            }
            return;
        }
        this.resetEmpty();
        AbstractMapTest.assertEquals((int)0, (int)this.getMap().size());
        this.getMap().putAll(new HashMap());
        AbstractMapTest.assertEquals((int)0, (int)this.getMap().size());
        this.resetFull();
        int size = this.getMap().size();
        this.getMap().putAll(new HashMap());
        AbstractMapTest.assertEquals((int)size, (int)this.getMap().size());
        this.resetEmpty();
        Map<K, V> m2 = this.makeFullMap();
        this.getMap().putAll(m2);
        this.getConfirmed().putAll(m2);
        this.verify();
        this.resetEmpty();
        m2 = this.makeConfirmedMap();
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (i = 0; i < keys.length; ++i) {
            m2.put(keys[i], values[i]);
        }
        this.getMap().putAll(m2);
        this.getConfirmed().putAll(m2);
        this.verify();
        this.resetEmpty();
        m2 = this.makeConfirmedMap();
        this.getMap().put(keys[0], values[0]);
        this.getConfirmed().put(keys[0], values[0]);
        this.verify();
        for (i = 1; i < keys.length; ++i) {
            m2.put(keys[i], values[i]);
        }
        this.getMap().putAll(m2);
        this.getConfirmed().putAll(m2);
        this.verify();
    }

    public void testMapRemove() {
        if (!this.isRemoveSupported()) {
            try {
                this.resetFull();
                this.getMap().remove(this.getMap().keySet().iterator().next());
                AbstractMapTest.fail((String)"Expected UnsupportedOperationException on remove");
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        this.resetEmpty();
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (K key : keys) {
            V o = this.getMap().remove(key);
            AbstractMapTest.assertTrue((String)"First map.remove should return null", (o == null ? 1 : 0) != 0);
        }
        this.verify();
        this.resetFull();
        for (int i = 0; i < keys.length; ++i) {
            V o = this.getMap().remove(keys[i]);
            this.getConfirmed().remove(keys[i]);
            this.verify();
            AbstractMapTest.assertEquals((String)"map.remove with valid key should return value", values[i], o);
        }
        K[] other = this.getOtherKeys();
        this.resetFull();
        int size = this.getMap().size();
        for (K element : other) {
            V o = this.getMap().remove(element);
            AbstractMapTest.assertNull((String)"map.remove for nonexistent key should return null", o);
            AbstractMapTest.assertEquals((String)"map.remove for nonexistent key should not shrink map", (int)size, (int)this.getMap().size());
        }
        this.verify();
    }

    public void testValuesClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Collection<V> values = this.getMap().values();
        AbstractMapTest.assertTrue((this.getMap().size() > 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((values.size() > 0 ? 1 : 0) != 0);
        values.clear();
        AbstractMapTest.assertTrue((this.getMap().size() == 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((values.size() == 0 ? 1 : 0) != 0);
        this.resetFull();
        values = this.getMap().values();
        AbstractMapTest.assertTrue((this.getMap().size() > 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((values.size() > 0 ? 1 : 0) != 0);
        this.getMap().clear();
        AbstractMapTest.assertTrue((this.getMap().size() == 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((values.size() == 0 ? 1 : 0) != 0);
    }

    public void testKeySetClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Set<K> keySet = this.getMap().keySet();
        AbstractMapTest.assertTrue((this.getMap().size() > 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((keySet.size() > 0 ? 1 : 0) != 0);
        keySet.clear();
        AbstractMapTest.assertTrue((this.getMap().size() == 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((keySet.size() == 0 ? 1 : 0) != 0);
        this.resetFull();
        keySet = this.getMap().keySet();
        AbstractMapTest.assertTrue((this.getMap().size() > 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((keySet.size() > 0 ? 1 : 0) != 0);
        this.getMap().clear();
        AbstractMapTest.assertTrue((this.getMap().size() == 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((keySet.size() == 0 ? 1 : 0) != 0);
    }

    public void testEntrySetClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Set<Map.Entry<K, V>> entrySet = this.getMap().entrySet();
        AbstractMapTest.assertTrue((this.getMap().size() > 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((entrySet.size() > 0 ? 1 : 0) != 0);
        entrySet.clear();
        AbstractMapTest.assertTrue((this.getMap().size() == 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((entrySet.size() == 0 ? 1 : 0) != 0);
        this.resetFull();
        entrySet = this.getMap().entrySet();
        AbstractMapTest.assertTrue((this.getMap().size() > 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((entrySet.size() > 0 ? 1 : 0) != 0);
        this.getMap().clear();
        AbstractMapTest.assertTrue((this.getMap().size() == 0 ? 1 : 0) != 0);
        AbstractMapTest.assertTrue((entrySet.size() == 0 ? 1 : 0) != 0);
    }

    public void testEntrySetContains1() {
        this.resetFull();
        Set<Map.Entry<K, V>> entrySet = this.getMap().entrySet();
        Map.Entry<K, V> entry = entrySet.iterator().next();
        AbstractMapTest.assertEquals((boolean)true, (boolean)entrySet.contains(entry));
    }

    public void testEntrySetContains2() {
        this.resetFull();
        Set<Map.Entry<K, V>> entrySet = this.getMap().entrySet();
        Map.Entry<K, V> entry = entrySet.iterator().next();
        Map.Entry<K, V> test = AbstractMapTest.cloneMapEntry(entry);
        AbstractMapTest.assertEquals((boolean)true, (boolean)entrySet.contains(test));
    }

    public void testEntrySetContains3() {
        this.resetFull();
        Set<Map.Entry<K, V>> entrySet = this.getMap().entrySet();
        Map.Entry<K, V> entry = entrySet.iterator().next();
        HashMap<K, String> temp = new HashMap<K, String>();
        temp.put(entry.getKey(), "A VERY DIFFERENT VALUE");
        Map.Entry test = temp.entrySet().iterator().next();
        AbstractMapTest.assertEquals((boolean)false, (boolean)entrySet.contains(test));
    }

    public void testEntrySetRemove1() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.getMap().size();
        Set<Map.Entry<K, V>> entrySet = this.getMap().entrySet();
        Map.Entry<K, V> entry = entrySet.iterator().next();
        K key = entry.getKey();
        AbstractMapTest.assertEquals((boolean)true, (boolean)entrySet.remove(entry));
        AbstractMapTest.assertEquals((boolean)false, (boolean)this.getMap().containsKey(key));
        AbstractMapTest.assertEquals((int)(size - 1), (int)this.getMap().size());
    }

    public void testEntrySetRemove2() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.getMap().size();
        Set<Map.Entry<K, V>> entrySet = this.getMap().entrySet();
        Map.Entry<K, V> entry = entrySet.iterator().next();
        K key = entry.getKey();
        Map.Entry<K, V> test = AbstractMapTest.cloneMapEntry(entry);
        AbstractMapTest.assertEquals((boolean)true, (boolean)entrySet.remove(test));
        AbstractMapTest.assertEquals((boolean)false, (boolean)this.getMap().containsKey(key));
        AbstractMapTest.assertEquals((int)(size - 1), (int)this.getMap().size());
    }

    public void testEntrySetRemove3() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.getMap().size();
        Set<Map.Entry<K, V>> entrySet = this.getMap().entrySet();
        Map.Entry<K, V> entry = entrySet.iterator().next();
        K key = entry.getKey();
        HashMap<K, String> temp = new HashMap<K, String>();
        temp.put(entry.getKey(), "A VERY DIFFERENT VALUE");
        Map.Entry test = temp.entrySet().iterator().next();
        AbstractMapTest.assertEquals((boolean)false, (boolean)entrySet.remove(test));
        AbstractMapTest.assertEquals((boolean)true, (boolean)this.getMap().containsKey(key));
        AbstractMapTest.assertEquals((int)size, (int)this.getMap().size());
    }

    public void testValuesRemoveChangesMap() {
        this.resetFull();
        V[] sampleValues = this.getSampleValues();
        Collection<V> values = this.getMap().values();
        for (int i = 0; i < sampleValues.length; ++i) {
            int j;
            if (!this.map.containsValue(sampleValues[i])) continue;
            for (j = 0; values.contains(sampleValues[i]) && j < 10000; ++j) {
                try {
                    values.remove(sampleValues[i]);
                    continue;
                }
                catch (UnsupportedOperationException e) {
                    return;
                }
            }
            AbstractMapTest.assertTrue((String)"values().remove(obj) is broken", (j < 10000 ? 1 : 0) != 0);
            AbstractMapTest.assertTrue((String)"Value should have been removed from the underlying map.", (!this.getMap().containsValue(sampleValues[i]) ? 1 : 0) != 0);
        }
    }

    public void testValuesRemoveAll() {
        this.resetFull();
        Collection<V> values = this.getMap().values();
        List<V> sampleValuesAsList = Arrays.asList(this.getSampleValues());
        if (!values.equals(sampleValuesAsList)) {
            return;
        }
        try {
            AbstractMapTest.assertFalse((boolean)values.removeAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertEquals((int)sampleValuesAsList.size(), (int)this.getMap().size());
        try {
            AbstractMapTest.assertTrue((boolean)values.removeAll(sampleValuesAsList));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertTrue((boolean)this.getMap().isEmpty());
    }

    public void testValuesRetainAll() {
        this.resetFull();
        Collection<V> values = this.getMap().values();
        List<V> sampleValuesAsList = Arrays.asList(this.getSampleValues());
        if (!values.equals(sampleValuesAsList)) {
            return;
        }
        try {
            AbstractMapTest.assertFalse((boolean)values.retainAll(sampleValuesAsList));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertEquals((int)sampleValuesAsList.size(), (int)this.getMap().size());
        try {
            AbstractMapTest.assertTrue((boolean)values.retainAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertTrue((boolean)this.getMap().isEmpty());
    }

    public void testValuesIteratorRemoveChangesMap() {
        this.resetFull();
        List<V> sampleValuesAsList = Arrays.asList(this.getSampleValues());
        Map cardinality = CollectionUtils.getCardinalityMap(sampleValuesAsList);
        Collection<V> values = this.getMap().values();
        Iterator<V> iter = values.iterator();
        while (iter.hasNext()) {
            V value = iter.next();
            Integer count = (Integer)cardinality.get(value);
            if (count == null) {
                return;
            }
            try {
                iter.remove();
                count = count - 1;
                cardinality.put(value, count);
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            boolean expected = count > 0;
            StringBuilder msg = new StringBuilder("Value should ");
            msg.append(expected ? "yet " : "no longer ");
            msg.append("be present in the underlying map");
            AbstractMapTest.assertEquals((String)msg.toString(), (boolean)expected, (boolean)this.getMap().containsValue(value));
        }
        AbstractMapTest.assertTrue((boolean)this.getMap().isEmpty());
    }

    public void testKeySetRemoveChangesMap() {
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        Set<K> keys = this.getMap().keySet();
        for (int i = 0; i < sampleKeys.length; ++i) {
            try {
                keys.remove(sampleKeys[i]);
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            AbstractMapTest.assertTrue((String)"Key should have been removed from the underlying map.", (!this.getMap().containsKey(sampleKeys[i]) ? 1 : 0) != 0);
        }
    }

    public void testKeySetRemoveAll() {
        this.resetFull();
        Set<K> keys = this.getMap().keySet();
        List<K> sampleKeysAsList = Arrays.asList(this.getSampleKeys());
        if (!keys.equals(sampleKeysAsList)) {
            return;
        }
        try {
            AbstractMapTest.assertFalse((boolean)keys.removeAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertEquals(sampleKeysAsList, keys);
        try {
            AbstractMapTest.assertTrue((boolean)keys.removeAll(sampleKeysAsList));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertTrue((boolean)this.getMap().isEmpty());
    }

    public void testKeySetRetainAll() {
        this.resetFull();
        Set<K> keys = this.getMap().keySet();
        List<K> sampleKeysAsList = Arrays.asList(this.getSampleKeys());
        if (!keys.equals(sampleKeysAsList)) {
            return;
        }
        try {
            AbstractMapTest.assertFalse((boolean)keys.retainAll(sampleKeysAsList));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertEquals(sampleKeysAsList, keys);
        try {
            AbstractMapTest.assertTrue((boolean)keys.retainAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertTrue((boolean)this.getMap().isEmpty());
    }

    public void testKeySetIteratorRemoveChangesMap() {
        this.resetFull();
        Iterator<K> iter = this.getMap().keySet().iterator();
        while (iter.hasNext()) {
            K key = iter.next();
            try {
                iter.remove();
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            AbstractMapTest.assertFalse((boolean)this.getMap().containsKey(key));
        }
    }

    public void testEntrySetRemoveChangesMap() {
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        V[] sampleValues = this.getSampleValues();
        Set<Map.Entry<K, V>> entrySet = this.getMap().entrySet();
        for (int i = 0; i < sampleKeys.length; ++i) {
            try {
                entrySet.remove(new DefaultMapEntry(sampleKeys[i], sampleValues[i]));
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            AbstractMapTest.assertTrue((String)"Entry should have been removed from the underlying map.", (!this.getMap().containsKey(sampleKeys[i]) ? 1 : 0) != 0);
        }
    }

    public void testEntrySetRemoveAll() {
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        V[] sampleValues = this.getSampleValues();
        for (int i = 0; i < sampleKeys.length; ++i) {
            if (!this.getMap().containsKey(sampleKeys[i])) {
                return;
            }
            V value = sampleValues[i];
            V test = this.getMap().get(sampleKeys[i]);
            if (value == test || value != null && value.equals(test)) continue;
            return;
        }
        Set<Map.Entry<K, V>> entrySet = this.getMap().entrySet();
        HashSet<Map.Entry<K, V>> comparisonSet = new HashSet<Map.Entry<K, V>>(entrySet);
        try {
            AbstractMapTest.assertFalse((boolean)entrySet.removeAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertEquals((int)sampleKeys.length, (int)this.getMap().size());
        try {
            AbstractMapTest.assertTrue((boolean)entrySet.removeAll(comparisonSet));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertTrue((boolean)this.getMap().isEmpty());
    }

    public void testEntrySetRetainAll() {
        this.resetFull();
        K[] sampleKeys = this.getSampleKeys();
        V[] sampleValues = this.getSampleValues();
        for (int i = 0; i < sampleKeys.length; ++i) {
            if (!this.getMap().containsKey(sampleKeys[i])) {
                return;
            }
            V value = sampleValues[i];
            V test = this.getMap().get(sampleKeys[i]);
            if (value == test || value != null && value.equals(test)) continue;
            return;
        }
        Set<Map.Entry<K, V>> entrySet = this.getMap().entrySet();
        HashSet<Map.Entry<K, V>> comparisonSet = new HashSet<Map.Entry<K, V>>(entrySet);
        try {
            AbstractMapTest.assertFalse((boolean)entrySet.retainAll(comparisonSet));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertEquals((int)sampleKeys.length, (int)this.getMap().size());
        try {
            AbstractMapTest.assertTrue((boolean)entrySet.retainAll(Collections.emptySet()));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        AbstractMapTest.assertTrue((boolean)this.getMap().isEmpty());
    }

    public void testEntrySetIteratorRemoveChangesMap() {
        this.resetFull();
        Iterator<Map.Entry<K, V>> iter = this.getMap().entrySet().iterator();
        while (iter.hasNext()) {
            K key = iter.next().getKey();
            try {
                iter.remove();
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            AbstractMapTest.assertFalse((boolean)this.getMap().containsKey(key));
        }
    }

    private Map.Entry<K, V>[] makeEntryArray(K[] keys, V[] values) {
        Map.Entry[] result = new Map.Entry[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            Map<K, V> map = this.makeConfirmedMap();
            map.put(keys[i], values[i]);
            result[i] = map.entrySet().iterator().next();
        }
        return result;
    }

    public BulkTest bulkTestMapEntrySet() {
        return new TestMapEntrySet();
    }

    public BulkTest bulkTestMapKeySet() {
        return new TestMapKeySet();
    }

    public BulkTest bulkTestMapValues() {
        return new TestMapValues();
    }

    public void resetEmpty() {
        this.map = this.makeObject();
        this.views();
        this.confirmed = this.makeConfirmedMap();
    }

    public void resetFull() {
        this.map = this.makeFullMap();
        this.views();
        this.confirmed = this.makeConfirmedMap();
        K[] k = this.getSampleKeys();
        V[] v = this.getSampleValues();
        for (int i = 0; i < k.length; ++i) {
            this.confirmed.put(k[i], v[i]);
        }
    }

    private void views() {
        this.keySet = this.getMap().keySet();
        this.entrySet = this.getMap().entrySet();
    }

    public void verify() {
        this.verifyMap();
        this.verifyEntrySet();
        this.verifyKeySet();
        this.verifyValues();
    }

    public void verifyMap() {
        int size = this.getConfirmed().size();
        boolean empty = this.getConfirmed().isEmpty();
        AbstractMapTest.assertEquals((String)"Map should be same size as HashMap", (int)size, (int)this.getMap().size());
        AbstractMapTest.assertEquals((String)"Map should be empty if HashMap is", (boolean)empty, (boolean)this.getMap().isEmpty());
        AbstractMapTest.assertEquals((String)"hashCodes should be the same", (int)this.getConfirmed().hashCode(), (int)this.getMap().hashCode());
        AbstractMapTest.assertTrue((String)"Map should still equal HashMap", (boolean)this.getMap().equals(this.getConfirmed()));
    }

    public void verifyEntrySet() {
        int size = this.getConfirmed().size();
        boolean empty = this.getConfirmed().isEmpty();
        AbstractMapTest.assertEquals((String)("entrySet should be same size as HashMap's\nTest: " + this.entrySet + "\nReal: " + this.getConfirmed().entrySet()), (int)size, (int)this.entrySet.size());
        AbstractMapTest.assertEquals((String)("entrySet should be empty if HashMap is\nTest: " + this.entrySet + "\nReal: " + this.getConfirmed().entrySet()), (boolean)empty, (boolean)this.entrySet.isEmpty());
        AbstractMapTest.assertTrue((String)("entrySet should contain all HashMap's elements\nTest: " + this.entrySet + "\nReal: " + this.getConfirmed().entrySet()), (boolean)this.entrySet.containsAll(this.getConfirmed().entrySet()));
        AbstractMapTest.assertEquals((String)("entrySet hashCodes should be the same\nTest: " + this.entrySet + "\nReal: " + this.getConfirmed().entrySet()), (int)this.getConfirmed().entrySet().hashCode(), (int)this.entrySet.hashCode());
        AbstractMapTest.assertEquals((String)"Map's entry set should still equal HashMap's", this.getConfirmed().entrySet(), this.entrySet);
    }

    public void verifyKeySet() {
        int size = this.getConfirmed().size();
        boolean empty = this.getConfirmed().isEmpty();
        AbstractMapTest.assertEquals((String)("keySet should be same size as HashMap's\nTest: " + this.keySet + "\nReal: " + this.getConfirmed().keySet()), (int)size, (int)this.keySet.size());
        AbstractMapTest.assertEquals((String)("keySet should be empty if HashMap is\nTest: " + this.keySet + "\nReal: " + this.getConfirmed().keySet()), (boolean)empty, (boolean)this.keySet.isEmpty());
        AbstractMapTest.assertTrue((String)("keySet should contain all HashMap's elements\nTest: " + this.keySet + "\nReal: " + this.getConfirmed().keySet()), (boolean)this.keySet.containsAll(this.getConfirmed().keySet()));
        AbstractMapTest.assertEquals((String)("keySet hashCodes should be the same\nTest: " + this.keySet + "\nReal: " + this.getConfirmed().keySet()), (int)this.getConfirmed().keySet().hashCode(), (int)this.keySet.hashCode());
        AbstractMapTest.assertEquals((String)"Map's key set should still equal HashMap's", this.getConfirmed().keySet(), this.keySet);
    }

    public void verifyValues() {
        ArrayList<V> known = new ArrayList<V>(this.getConfirmed().values());
        this.values = this.getMap().values();
        ArrayList<V> test = new ArrayList<V>(this.values);
        int size = this.getConfirmed().size();
        boolean empty = this.getConfirmed().isEmpty();
        AbstractMapTest.assertEquals((String)("values should be same size as HashMap's\nTest: " + test + "\nReal: " + known), (int)size, (int)this.values.size());
        AbstractMapTest.assertEquals((String)("values should be empty if HashMap is\nTest: " + test + "\nReal: " + known), (boolean)empty, (boolean)this.values.isEmpty());
        AbstractMapTest.assertTrue((String)("values should contain all HashMap's elements\nTest: " + test + "\nReal: " + known), (boolean)test.containsAll(known));
        AbstractMapTest.assertTrue((String)("values should contain all HashMap's elements\nTest: " + test + "\nReal: " + known), (boolean)known.containsAll(test));
        for (Object v : known) {
            boolean removed = test.remove(v);
            AbstractMapTest.assertTrue((String)"Map's values should still equal HashMap's", (boolean)removed);
        }
        AbstractMapTest.assertTrue((String)"Map's values should still equal HashMap's", (boolean)test.isEmpty());
    }

    public void tearDown() throws Exception {
        this.map = null;
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.confirmed = null;
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    public Map<K, V> getConfirmed() {
        return this.confirmed;
    }

    static {
        String str = System.getProperty("java.version");
        JDK12 = str.startsWith("1.2");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestMapValues
    extends AbstractCollectionTest<V> {
        public TestMapValues() {
            super("");
        }

        @Override
        public V[] getFullElements() {
            return AbstractMapTest.this.getSampleValues();
        }

        @Override
        public V[] getOtherElements() {
            return AbstractMapTest.this.getOtherValues();
        }

        @Override
        public Collection<V> makeObject() {
            return AbstractMapTest.this.makeObject().values();
        }

        @Override
        public Collection<V> makeFullCollection() {
            return AbstractMapTest.this.makeFullMap().values();
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public boolean areEqualElementsDistinguishable() {
            return true;
        }

        @Override
        public Collection<V> makeConfirmedCollection() {
            return null;
        }

        @Override
        public Collection<V> makeConfirmedFullCollection() {
            return null;
        }

        @Override
        public void resetFull() {
            AbstractMapTest.this.resetFull();
            this.setCollection(AbstractMapTest.this.map.values());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().values());
        }

        @Override
        public void resetEmpty() {
            AbstractMapTest.this.resetEmpty();
            this.setCollection(AbstractMapTest.this.map.values());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().values());
        }

        @Override
        public void verify() {
            super.verify();
            AbstractMapTest.this.verify();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestMapKeySet
    extends AbstractSetTest<K> {
        public TestMapKeySet() {
            super("");
        }

        @Override
        public K[] getFullElements() {
            return AbstractMapTest.this.getSampleKeys();
        }

        @Override
        public K[] getOtherElements() {
            return AbstractMapTest.this.getOtherKeys();
        }

        @Override
        public Set<K> makeObject() {
            return AbstractMapTest.this.makeObject().keySet();
        }

        @Override
        public Set<K> makeFullCollection() {
            return AbstractMapTest.this.makeFullMap().keySet();
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public void resetEmpty() {
            AbstractMapTest.this.resetEmpty();
            this.setCollection(AbstractMapTest.this.getMap().keySet());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().keySet());
        }

        @Override
        public void resetFull() {
            AbstractMapTest.this.resetFull();
            this.setCollection(AbstractMapTest.this.getMap().keySet());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().keySet());
        }

        @Override
        public void verify() {
            super.verify();
            AbstractMapTest.this.verify();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestMapEntrySet
    extends AbstractSetTest<Map.Entry<K, V>> {
        public TestMapEntrySet() {
            super("MapEntrySet");
        }

        public Map.Entry<K, V>[] getFullElements() {
            return this.getFullNonNullElements();
        }

        public Map.Entry<K, V>[] getFullNonNullElements() {
            Object[] k = AbstractMapTest.this.getSampleKeys();
            Object[] v = AbstractMapTest.this.getSampleValues();
            return AbstractMapTest.this.makeEntryArray(k, v);
        }

        public Map.Entry<K, V>[] getOtherElements() {
            Object[] k = AbstractMapTest.this.getOtherKeys();
            Object[] v = AbstractMapTest.this.getOtherValues();
            return AbstractMapTest.this.makeEntryArray(k, v);
        }

        @Override
        public Set<Map.Entry<K, V>> makeObject() {
            return AbstractMapTest.this.makeObject().entrySet();
        }

        @Override
        public Set<Map.Entry<K, V>> makeFullCollection() {
            return AbstractMapTest.this.makeFullMap().entrySet();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMapTest.this.isRemoveSupported();
        }

        public boolean isGetStructuralModify() {
            return AbstractMapTest.this.isGetStructuralModify();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public void resetFull() {
            AbstractMapTest.this.resetFull();
            this.setCollection(AbstractMapTest.this.getMap().entrySet());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().entrySet());
        }

        @Override
        public void resetEmpty() {
            AbstractMapTest.this.resetEmpty();
            this.setCollection(AbstractMapTest.this.getMap().entrySet());
            this.setConfirmed(AbstractMapTest.this.getConfirmed().entrySet());
        }

        public void testMapEntrySetIteratorEntry() {
            this.resetFull();
            Iterator it = this.getCollection().iterator();
            int count = 0;
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                TestMapEntrySet.assertEquals((boolean)true, (boolean)AbstractMapTest.this.getMap().containsKey(entry.getKey()));
                TestMapEntrySet.assertEquals((boolean)true, (boolean)AbstractMapTest.this.getMap().containsValue(entry.getValue()));
                if (!this.isGetStructuralModify()) {
                    TestMapEntrySet.assertEquals(AbstractMapTest.this.getMap().get(entry.getKey()), entry.getValue());
                }
                ++count;
            }
            TestMapEntrySet.assertEquals((int)this.getCollection().size(), (int)count);
        }

        public void testMapEntrySetIteratorEntrySetValue() {
            Object key1 = AbstractMapTest.this.getSampleKeys()[0];
            Object key2 = AbstractMapTest.this.getSampleKeys().length == 1 ? AbstractMapTest.this.getSampleKeys()[0] : AbstractMapTest.this.getSampleKeys()[1];
            Object newValue1 = AbstractMapTest.this.getNewSampleValues()[0];
            Object newValue2 = AbstractMapTest.this.getNewSampleValues().length == 1 ? AbstractMapTest.this.getNewSampleValues()[0] : AbstractMapTest.this.getNewSampleValues()[1];
            this.resetFull();
            Iterator it = this.getCollection().iterator();
            Map.Entry entry1 = this.getEntry(it, key1);
            it = this.getCollection().iterator();
            Map.Entry entry2 = this.getEntry(it, key2);
            Iterator itConfirmed = this.getConfirmed().iterator();
            Map.Entry entryConfirmed1 = this.getEntry(itConfirmed, key1);
            itConfirmed = this.getConfirmed().iterator();
            Map.Entry entryConfirmed2 = this.getEntry(itConfirmed, key2);
            this.verify();
            if (!AbstractMapTest.this.isSetValueSupported()) {
                try {
                    entry1.setValue(newValue1);
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
                return;
            }
            entry1.setValue(newValue1);
            entryConfirmed1.setValue(newValue1);
            TestMapEntrySet.assertEquals(newValue1, entry1.getValue());
            TestMapEntrySet.assertEquals((boolean)true, (boolean)AbstractMapTest.this.getMap().containsKey(entry1.getKey()));
            TestMapEntrySet.assertEquals((boolean)true, (boolean)AbstractMapTest.this.getMap().containsValue(newValue1));
            TestMapEntrySet.assertEquals(newValue1, AbstractMapTest.this.getMap().get(entry1.getKey()));
            this.verify();
            entry1.setValue(newValue1);
            entryConfirmed1.setValue(newValue1);
            TestMapEntrySet.assertEquals(newValue1, entry1.getValue());
            TestMapEntrySet.assertEquals((boolean)true, (boolean)AbstractMapTest.this.getMap().containsKey(entry1.getKey()));
            TestMapEntrySet.assertEquals((boolean)true, (boolean)AbstractMapTest.this.getMap().containsValue(newValue1));
            TestMapEntrySet.assertEquals(newValue1, AbstractMapTest.this.getMap().get(entry1.getKey()));
            this.verify();
            entry2.setValue(newValue2);
            entryConfirmed2.setValue(newValue2);
            TestMapEntrySet.assertEquals(newValue2, entry2.getValue());
            TestMapEntrySet.assertEquals((boolean)true, (boolean)AbstractMapTest.this.getMap().containsKey(entry2.getKey()));
            TestMapEntrySet.assertEquals((boolean)true, (boolean)AbstractMapTest.this.getMap().containsValue(newValue2));
            TestMapEntrySet.assertEquals(newValue2, AbstractMapTest.this.getMap().get(entry2.getKey()));
            this.verify();
        }

        public Map.Entry<K, V> getEntry(Iterator<Map.Entry<K, V>> itConfirmed, K key) {
            Map.Entry entry = null;
            while (itConfirmed.hasNext()) {
                Map.Entry temp = itConfirmed.next();
                if (temp.getKey() == null) {
                    if (key != null) continue;
                    entry = temp;
                    break;
                }
                if (!temp.getKey().equals(key)) continue;
                entry = temp;
                break;
            }
            TestMapEntrySet.assertNotNull((String)("No matching entry in map for key '" + key + "'"), entry);
            return entry;
        }

        public void testMapEntrySetRemoveNonMapEntry() {
            if (!this.isRemoveSupported()) {
                return;
            }
            this.resetFull();
            TestMapEntrySet.assertEquals((boolean)false, (boolean)this.getCollection().remove(null));
            TestMapEntrySet.assertEquals((boolean)false, (boolean)this.getCollection().remove(new Object()));
        }

        @Override
        public void verify() {
            super.verify();
            AbstractMapTest.this.verify();
        }
    }
}

