/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.Arrays;
import org.apache.commons.collections4.list.AbstractLinkedList;
import org.apache.commons.collections4.list.AbstractListTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkedListTest<E>
extends AbstractListTest<E> {
    public AbstractLinkedListTest(String testName) {
        super(testName);
    }

    public void testRemoveFirst() {
        this.resetEmpty();
        AbstractLinkedList<E> list = this.getCollection();
        if (!this.isRemoveSupported()) {
            try {
                list.removeFirst();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        AbstractLinkedListTest.assertEquals((Object)"value1", (Object)list.removeFirst());
        this.checkNodes();
        list.addLast((Object)"value3");
        this.checkNodes();
        AbstractLinkedListTest.assertEquals((Object)"value2", (Object)list.removeFirst());
        AbstractLinkedListTest.assertEquals((Object)"value3", (Object)list.removeFirst());
        this.checkNodes();
        list.addLast((Object)"value4");
        this.checkNodes();
        AbstractLinkedListTest.assertEquals((Object)"value4", (Object)list.removeFirst());
        this.checkNodes();
    }

    public void testRemoveLast() {
        this.resetEmpty();
        AbstractLinkedList<E> list = this.getCollection();
        if (!this.isRemoveSupported()) {
            try {
                list.removeLast();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        AbstractLinkedListTest.assertEquals((Object)"value2", (Object)list.removeLast());
        list.addFirst((Object)"value3");
        this.checkNodes();
        AbstractLinkedListTest.assertEquals((Object)"value1", (Object)list.removeLast());
        AbstractLinkedListTest.assertEquals((Object)"value3", (Object)list.removeLast());
        list.addFirst((Object)"value4");
        this.checkNodes();
        AbstractLinkedListTest.assertEquals((Object)"value4", (Object)list.removeFirst());
    }

    public void testAddNodeAfter() {
        this.resetEmpty();
        AbstractLinkedList<E> list = this.getCollection();
        if (!this.isAddSupported()) {
            try {
                list.addFirst(null);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        list.addFirst((Object)"value1");
        list.addNodeAfter(list.getNode(0, false), (Object)"value2");
        AbstractLinkedListTest.assertEquals((Object)"value1", (Object)list.getFirst());
        AbstractLinkedListTest.assertEquals((Object)"value2", (Object)list.getLast());
        list.removeFirst();
        this.checkNodes();
        list.addNodeAfter(list.getNode(0, false), (Object)"value3");
        this.checkNodes();
        AbstractLinkedListTest.assertEquals((Object)"value2", (Object)list.getFirst());
        AbstractLinkedListTest.assertEquals((Object)"value3", (Object)list.getLast());
        list.addNodeAfter(list.getNode(0, false), (Object)"value4");
        this.checkNodes();
        AbstractLinkedListTest.assertEquals((Object)"value2", (Object)list.getFirst());
        AbstractLinkedListTest.assertEquals((Object)"value3", (Object)list.getLast());
        AbstractLinkedListTest.assertEquals((Object)"value4", (Object)list.get(1));
        list.addNodeAfter(list.getNode(2, false), (Object)"value5");
        this.checkNodes();
        AbstractLinkedListTest.assertEquals((Object)"value2", (Object)list.getFirst());
        AbstractLinkedListTest.assertEquals((Object)"value4", (Object)list.get(1));
        AbstractLinkedListTest.assertEquals((Object)"value3", (Object)list.get(2));
        AbstractLinkedListTest.assertEquals((Object)"value5", (Object)list.getLast());
    }

    public void testRemoveNode() {
        this.resetEmpty();
        if (!this.isAddSupported() || !this.isRemoveSupported()) {
            return;
        }
        AbstractLinkedList<E> list = this.getCollection();
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        list.removeNode(list.getNode(0, false));
        this.checkNodes();
        AbstractLinkedListTest.assertEquals((Object)"value2", (Object)list.getFirst());
        AbstractLinkedListTest.assertEquals((Object)"value2", (Object)list.getLast());
        list.addFirst((Object)"value1");
        list.addFirst((Object)"value0");
        this.checkNodes();
        list.removeNode(list.getNode(1, false));
        AbstractLinkedListTest.assertEquals((Object)"value0", (Object)list.getFirst());
        AbstractLinkedListTest.assertEquals((Object)"value2", (Object)list.getLast());
        this.checkNodes();
        list.removeNode(list.getNode(1, false));
        AbstractLinkedListTest.assertEquals((Object)"value0", (Object)list.getFirst());
        AbstractLinkedListTest.assertEquals((Object)"value0", (Object)list.getLast());
        this.checkNodes();
    }

    public void testGetNode() {
        this.resetEmpty();
        AbstractLinkedList<E> list = this.getCollection();
        AbstractLinkedListTest.assertEquals((Object)list.getNode((int)0, (boolean)true).previous, (Object)list.getNode((int)0, (boolean)true).next);
        try {
            list.getNode(0, false);
            AbstractLinkedListTest.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        this.checkNodes();
        list.addFirst((Object)"value0");
        this.checkNodes();
        list.removeNode(list.getNode(1, false));
        this.checkNodes();
        try {
            list.getNode(2, false);
            AbstractLinkedListTest.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            list.getNode(-1, false);
            AbstractLinkedListTest.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            list.getNode(3, true);
            AbstractLinkedListTest.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void checkNodes() {
        AbstractLinkedList<E> list = this.getCollection();
        for (int i = 0; i < list.size; ++i) {
            AbstractLinkedListTest.assertEquals((Object)list.getNode((int)i, (boolean)false).next, (Object)list.getNode(i + 1, true));
            if (i >= list.size - 1) continue;
            AbstractLinkedListTest.assertEquals((Object)list.getNode((int)(i + 1), (boolean)false).previous, (Object)list.getNode(i, false));
        }
    }

    @Override
    public AbstractLinkedList<E> getCollection() {
        return (AbstractLinkedList)super.getCollection();
    }
}

