/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrderedMapIteratorTest<K, V>
extends AbstractMapIteratorTest<K, V> {
    public AbstractOrderedMapIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public abstract OrderedMapIterator<K, V> makeEmptyIterator();

    @Override
    public abstract OrderedMapIterator<K, V> makeObject();

    @Override
    public void testEmptyMapIterator() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        super.testEmptyMapIterator();
        OrderedMapIterator<K, V> it = this.makeEmptyIterator();
        AbstractOrderedMapIteratorTest.assertEquals((boolean)false, (boolean)it.hasPrevious());
        try {
            it.previous();
            AbstractOrderedMapIteratorTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public void testFullMapIterator() {
        Object value;
        Object key;
        if (!this.supportsFullIterator()) {
            return;
        }
        super.testFullMapIterator();
        OrderedMapIterator<K, V> it = this.makeObject();
        Map map = this.getMap();
        AbstractOrderedMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        AbstractOrderedMapIteratorTest.assertEquals((boolean)false, (boolean)it.hasPrevious());
        HashSet<Object> set = new HashSet<Object>();
        while (it.hasNext()) {
            key = it.next();
            AbstractOrderedMapIteratorTest.assertSame((String)"it.next() should equals getKey()", (Object)key, (Object)it.getKey());
            AbstractOrderedMapIteratorTest.assertTrue((String)"Key must be in map", (boolean)map.containsKey(key));
            AbstractOrderedMapIteratorTest.assertTrue((String)"Key must be unique", (boolean)set.add(key));
            value = it.getValue();
            if (!this.isGetStructuralModify()) {
                AbstractOrderedMapIteratorTest.assertSame((String)"Value must be mapped to key", map.get(key), (Object)value);
            }
            AbstractOrderedMapIteratorTest.assertTrue((String)"Value must be in map", (boolean)map.containsValue(value));
            AbstractOrderedMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
            this.verify();
        }
        while (it.hasPrevious()) {
            key = it.previous();
            AbstractOrderedMapIteratorTest.assertSame((String)"it.previous() should equals getKey()", (Object)key, (Object)it.getKey());
            AbstractOrderedMapIteratorTest.assertTrue((String)"Key must be in map", (boolean)map.containsKey(key));
            AbstractOrderedMapIteratorTest.assertTrue((String)"Key must be unique", (boolean)set.remove(key));
            value = it.getValue();
            if (!this.isGetStructuralModify()) {
                AbstractOrderedMapIteratorTest.assertSame((String)"Value must be mapped to key", map.get(key), (Object)value);
            }
            AbstractOrderedMapIteratorTest.assertTrue((String)"Value must be in map", (boolean)map.containsValue(value));
            AbstractOrderedMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
            this.verify();
        }
    }

    public void testMapIteratorOrder() {
        Object key;
        if (!this.supportsFullIterator()) {
            return;
        }
        OrderedMapIterator<K, V> it = this.makeObject();
        Map map = this.getMap();
        AbstractOrderedMapIteratorTest.assertEquals((String)"keySet() not consistent", new ArrayList(map.keySet()), new ArrayList(map.keySet()));
        Iterator it2 = map.keySet().iterator();
        AbstractOrderedMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        AbstractOrderedMapIteratorTest.assertEquals((boolean)true, (boolean)it2.hasNext());
        ArrayList<Object> list = new ArrayList<Object>();
        while (it.hasNext()) {
            key = it.next();
            AbstractOrderedMapIteratorTest.assertEquals(it2.next(), (Object)key);
            list.add(key);
        }
        AbstractOrderedMapIteratorTest.assertEquals((int)map.size(), (int)list.size());
        while (it.hasPrevious()) {
            key = it.previous();
            AbstractOrderedMapIteratorTest.assertEquals(list.get(list.size() - 1), (Object)key);
            list.remove(list.size() - 1);
        }
        AbstractOrderedMapIteratorTest.assertEquals((int)0, (int)list.size());
    }
}

