/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.SortedBidiMap;
import org.apache.commons.collections4.bidimap.AbstractOrderedBidiMapTest;
import org.apache.commons.collections4.map.AbstractSortedMapTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSortedBidiMapTest<K extends Comparable<K>, V extends Comparable<V>>
extends AbstractOrderedBidiMapTest<K, V> {
    protected List<K> sortedKeys;
    protected List<V> sortedValues = new ArrayList<V>();
    protected SortedSet<V> sortedNewValues = new TreeSet<V>();

    public AbstractSortedBidiMapTest(String testName) {
        super(testName);
        this.sortedKeys = this.getAsList(this.getSampleKeys());
        Collections.sort(this.sortedKeys);
        this.sortedKeys = Collections.unmodifiableList(this.sortedKeys);
        TreeMap map = new TreeMap();
        this.addSampleMappings(map);
        this.sortedValues.addAll(map.values());
        this.sortedValues = Collections.unmodifiableList(this.sortedValues);
        this.sortedNewValues.addAll(this.getAsList(this.getNewSampleValues()));
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public boolean isAllowNullValue() {
        return false;
    }

    @Override
    public abstract SortedBidiMap<K, V> makeObject();

    @Override
    public SortedBidiMap<K, V> makeFullMap() {
        return (SortedBidiMap)super.makeFullMap();
    }

    @Override
    public SortedMap<K, V> makeConfirmedMap() {
        return new TreeMap();
    }

    public void testBidiHeadMapContains() {
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        SortedMap head = sm.headMap((Object)toKey);
        AbstractSortedBidiMapTest.assertEquals((int)1, (int)head.size());
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)head.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)head.containsValue(firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)head.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)head.containsValue(secondValue));
    }

    public void testBidiClearByHeadMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        Comparable toKeyValue = (Comparable)sm.get((Object)toKey);
        SortedMap sub = sm.headMap((Object)toKey);
        int size = sm.size();
        AbstractSortedBidiMapTest.assertEquals((int)2, (int)sub.size());
        sub.clear();
        AbstractSortedBidiMapTest.assertEquals((int)0, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)toKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)toKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsKey((Object)toKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsValue((Object)toKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(toKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(toKeyValue));
    }

    public void testBidiRemoveByHeadMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.headMap((Object)toKey);
        AbstractSortedBidiMapTest.assertEquals((int)2, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Comparable firstValue = (Comparable)sub.remove(first);
        AbstractSortedBidiMapTest.assertEquals((int)1, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Comparable secondValue = (Comparable)sub.remove(second);
        AbstractSortedBidiMapTest.assertEquals((int)0, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
    }

    public void testBidiRemoveByHeadMapEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.headMap((Object)toKey);
        Set set = sub.entrySet();
        AbstractSortedBidiMapTest.assertEquals((int)2, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)2, (int)set.size());
        Iterator it2 = set.iterator();
        Map.Entry firstEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        Map.Entry secondEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)set.contains(firstEntry));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)set.contains(secondEntry));
        set.remove(firstEntry);
        AbstractSortedBidiMapTest.assertEquals((int)1, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey(firstEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue(firstEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(firstEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(firstEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)set.contains(firstEntry));
        set.remove(secondEntry);
        AbstractSortedBidiMapTest.assertEquals((int)0, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey(secondEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue(secondEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(secondEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(secondEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(secondEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)set.contains(secondEntry));
    }

    public void testBidiTailMapContains() {
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable fromKeyValue = (Comparable)sm.get((Object)fromKey);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        SortedMap sub = sm.tailMap((Object)fromKey);
        AbstractSortedBidiMapTest.assertEquals((int)(sm.size() - 1), (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)fromKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(fromKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)fromKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsValue(fromKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsValue(secondValue));
    }

    public void testBidiClearByTailMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Comparable first = (Comparable)it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable fromKeyValue = (Comparable)sm.get((Object)fromKey);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        SortedMap sub = sm.tailMap((Object)fromKey);
        int size = sm.size();
        AbstractSortedBidiMapTest.assertEquals((int)(size - 3), (int)sub.size());
        sub.clear();
        AbstractSortedBidiMapTest.assertEquals((int)0, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)3, (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)3, (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsKey((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsValue((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)fromKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)fromKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)fromKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)fromKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(fromKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(fromKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
    }

    public void testBidiRemoveByTailMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.tailMap((Object)fromKey);
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Object firstValue = sub.remove(first);
        AbstractSortedBidiMapTest.assertEquals((int)(size - 3), (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue(firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Object secondValue = sub.remove(second);
        AbstractSortedBidiMapTest.assertEquals((int)(size - 4), (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue(secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
    }

    public void testBidiRemoveByTailMapEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.tailMap((Object)fromKey);
        Set set = sub.entrySet();
        Iterator it2 = set.iterator();
        it2.next();
        Map.Entry firstEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        Map.Entry secondEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)set.contains(firstEntry));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)set.contains(secondEntry));
        set.remove(firstEntry);
        AbstractSortedBidiMapTest.assertEquals((int)(size - 3), (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey(firstEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue(firstEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(firstEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(firstEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)set.contains(firstEntry));
        set.remove(secondEntry);
        AbstractSortedBidiMapTest.assertEquals((int)(size - 4), (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey(secondEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue(secondEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(secondEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(secondEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(secondEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)set.contains(secondEntry));
    }

    public void testBidiSubMapContains() {
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        Comparable third = (Comparable)it.next();
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable fromKeyValue = (Comparable)sm.get((Object)fromKey);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        Comparable thirdValue = (Comparable)sm.get((Object)third);
        SortedMap sub = sm.subMap((Object)fromKey, (Object)toKey);
        AbstractSortedBidiMapTest.assertEquals((int)2, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)fromKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(fromKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)fromKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsValue(fromKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsValue(secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)third));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(third));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)thirdValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(thirdValue));
    }

    public void testBidiClearBySubMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        Comparable fromKeyValue = (Comparable)sm.get((Object)fromKey);
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        Comparable toKeyValue = (Comparable)sm.get((Object)toKey);
        SortedMap sub = sm.subMap((Object)fromKey, (Object)toKey);
        int size = sm.size();
        AbstractSortedBidiMapTest.assertEquals((int)3, (int)sub.size());
        sub.clear();
        AbstractSortedBidiMapTest.assertEquals((int)0, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 3), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 3), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)fromKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)fromKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)fromKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)fromKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(fromKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(fromKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)toKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsValue((Object)toKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsKey((Object)toKeyValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsValue((Object)toKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(toKey));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(toKeyValue));
    }

    public void testBidiRemoveBySubMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.subMap((Object)fromKey, (Object)toKey);
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Comparable firstValue = (Comparable)sub.remove(first);
        AbstractSortedBidiMapTest.assertEquals((int)2, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)firstValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Comparable secondValue = (Comparable)sub.remove(second);
        AbstractSortedBidiMapTest.assertEquals((int)1, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey((Object)secondValue));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
    }

    public void testBidiRemoveBySubMapEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.subMap((Object)fromKey, (Object)toKey);
        Set set = sub.entrySet();
        AbstractSortedBidiMapTest.assertEquals((int)3, (int)set.size());
        Iterator it2 = set.iterator();
        it2.next();
        Map.Entry firstEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        Map.Entry secondEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)set.contains(firstEntry));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sm.containsKey((Object)second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        AbstractSortedBidiMapTest.assertEquals((boolean)true, (boolean)set.contains(secondEntry));
        set.remove(firstEntry);
        AbstractSortedBidiMapTest.assertEquals((int)2, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey(firstEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue(firstEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(firstEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(firstEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(firstEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)set.contains(firstEntry));
        set.remove(secondEntry);
        AbstractSortedBidiMapTest.assertEquals((int)1, (int)sub.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.size());
        AbstractSortedBidiMapTest.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsKey(secondEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.containsValue(secondEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(secondEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsKey(secondEntry.getKey()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)sub.containsValue(secondEntry.getValue()));
        AbstractSortedBidiMapTest.assertEquals((boolean)false, (boolean)set.contains(secondEntry));
    }

    public BulkTest bulkTestHeadMap() {
        return new AbstractSortedMapTest.TestHeadMap(this);
    }

    public BulkTest bulkTestTailMap() {
        return new AbstractSortedMapTest.TestTailMap(this);
    }

    public BulkTest bulkTestSubMap() {
        return new AbstractSortedMapTest.TestSubMap(this);
    }
}

