/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import junit.framework.Test;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.AbstractSortedBagTest;
import org.apache.commons.collections4.bag.TransformedBag;
import org.apache.commons.collections4.bag.TransformedSortedBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.collection.TransformedCollectionTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedSortedBagTest<T>
extends AbstractSortedBagTest<T> {
    public TransformedSortedBagTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(TransformedSortedBagTest.class);
    }

    @Override
    public SortedBag<T> makeObject() {
        return TransformedSortedBag.transformingSortedBag((SortedBag)new TreeBag(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    public void testTransformedBag() {
        TransformedSortedBag bag = TransformedSortedBag.transformingSortedBag((SortedBag)new TreeBag(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedSortedBagTest.assertEquals((int)0, (int)bag.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < els.length; ++i) {
            bag.add(els[i]);
            TransformedSortedBagTest.assertEquals((int)(i + 1), (int)bag.size());
            TransformedSortedBagTest.assertEquals((boolean)true, (boolean)bag.contains((Object)Integer.valueOf((String)els[i])));
        }
        TransformedSortedBagTest.assertEquals((boolean)true, (boolean)bag.remove((Object)Integer.valueOf((String)els[0])));
    }

    public void testTransformedBag_decorateTransform() {
        Object[] els;
        TreeBag originalBag = new TreeBag();
        for (Object el : els = new Object[]{"1", "3", "5", "7", "2", "4", "6"}) {
            originalBag.add(el);
        }
        Bag bag = TransformedBag.transformedBag((Bag)originalBag, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedSortedBagTest.assertEquals((int)els.length, (int)bag.size());
        for (Object el : els) {
            TransformedSortedBagTest.assertEquals((boolean)true, (boolean)bag.contains((Object)Integer.valueOf((String)el)));
        }
        TransformedSortedBagTest.assertEquals((boolean)true, (boolean)bag.remove((Object)Integer.valueOf((String)els[0])));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

