/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.CollectionSortedBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.collection.AbstractCollectionTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionSortedBagTest<T>
extends AbstractCollectionTest<T> {
    public CollectionSortedBagTest(String testName) {
        super(testName);
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public Bag<T> makeObject() {
        return CollectionSortedBag.collectionSortedBag((SortedBag)new TreeBag());
    }

    @Override
    public Collection<T> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<T> makeConfirmedFullCollection() {
        Collection<T> set = this.makeConfirmedCollection();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    @Override
    public T[] getFullNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 1;
        }
        return elements;
    }

    @Override
    public T[] getOtherNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 2;
        }
        return elements;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    public void testEmptyBagCompatibility() throws IOException, ClassNotFoundException {
        Bag<T> bag = this.makeObject();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(bag));
            CollectionSortedBagTest.assertTrue((String)"Bag is empty", (bag2.size() == 0 ? 1 : 0) != 0);
            CollectionSortedBagTest.assertEquals(bag, (Object)bag2);
        }
    }

    public void testFullBagCompatibility() throws IOException, ClassNotFoundException {
        SortedBag bag = (SortedBag)this.makeFullCollection();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            SortedBag bag2 = (SortedBag)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(bag));
            CollectionSortedBagTest.assertEquals((String)"Bag is the right size", (int)bag.size(), (int)bag2.size());
            CollectionSortedBagTest.assertEquals((Object)bag, (Object)bag2);
        }
    }
}

