/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.TestUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.functors.AbstractPredicateTest;
import org.apache.commons.collections4.functors.AllPredicate;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.ExceptionPredicate;
import org.apache.commons.collections4.functors.FalsePredicate;
import org.apache.commons.collections4.functors.NotNullPredicate;
import org.apache.commons.collections4.functors.NullPredicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateUtilsTest
extends AbstractPredicateTest {
    public void setUp() {
    }

    public void tearDown() {
    }

    @Test
    public void testExceptionPredicate() {
        Assert.assertNotNull((Object)PredicateUtils.exceptionPredicate());
        Assert.assertSame((Object)PredicateUtils.exceptionPredicate(), (Object)PredicateUtils.exceptionPredicate());
        try {
            PredicateUtils.exceptionPredicate().evaluate(null);
        }
        catch (FunctorException ex) {
            try {
                PredicateUtils.exceptionPredicate().evaluate((Object)this.cString);
            }
            catch (FunctorException ex2) {
                return;
            }
        }
        Assert.fail();
    }

    @Test
    public void testIsNotNullPredicate() {
        Assert.assertNotNull((Object)PredicateUtils.notNullPredicate());
        Assert.assertSame((Object)PredicateUtils.notNullPredicate(), (Object)PredicateUtils.notNullPredicate());
        Assert.assertEquals((Object)false, (Object)PredicateUtils.notNullPredicate().evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.notNullPredicate().evaluate(this.cObject));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.notNullPredicate().evaluate((Object)this.cString));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.notNullPredicate().evaluate((Object)this.cInteger));
    }

    @Test
    public void testIdentityPredicate() {
        Assert.assertSame((Object)NullPredicate.nullPredicate(), (Object)PredicateUtils.identityPredicate(null));
        Assert.assertNotNull((Object)PredicateUtils.identityPredicate((Object)6));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.identityPredicate((Object)6).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.identityPredicate((Object)6).evaluate(this.cObject));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.identityPredicate((Object)6).evaluate((Object)this.cString));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.identityPredicate((Object)new Integer(6)).evaluate((Object)this.cInteger));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.identityPredicate((Object)this.cInteger).evaluate((Object)this.cInteger));
    }

    @Test
    public void testTruePredicate() {
        Assert.assertNotNull((Object)TruePredicate.truePredicate());
        Assert.assertSame((Object)TruePredicate.truePredicate(), (Object)TruePredicate.truePredicate());
        Assert.assertEquals((Object)true, (Object)TruePredicate.truePredicate().evaluate(null));
        Assert.assertEquals((Object)true, (Object)TruePredicate.truePredicate().evaluate(this.cObject));
        Assert.assertEquals((Object)true, (Object)TruePredicate.truePredicate().evaluate((Object)this.cString));
        Assert.assertEquals((Object)true, (Object)TruePredicate.truePredicate().evaluate((Object)this.cInteger));
    }

    @Test
    public void testFalsePredicate() {
        Assert.assertNotNull((Object)FalsePredicate.falsePredicate());
        Assert.assertSame((Object)FalsePredicate.falsePredicate(), (Object)FalsePredicate.falsePredicate());
        Assert.assertEquals((Object)false, (Object)FalsePredicate.falsePredicate().evaluate(null));
        Assert.assertEquals((Object)false, (Object)FalsePredicate.falsePredicate().evaluate(this.cObject));
        Assert.assertEquals((Object)false, (Object)FalsePredicate.falsePredicate().evaluate((Object)this.cString));
        Assert.assertEquals((Object)false, (Object)FalsePredicate.falsePredicate().evaluate((Object)this.cInteger));
    }

    @Test
    public void testNotPredicate() {
        Assert.assertNotNull((Object)PredicateUtils.notPredicate((Predicate)TruePredicate.truePredicate()));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.notPredicate((Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.notPredicate((Predicate)TruePredicate.truePredicate()).evaluate(this.cObject));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.notPredicate((Predicate)TruePredicate.truePredicate()).evaluate((Object)this.cString));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.notPredicate((Predicate)TruePredicate.truePredicate()).evaluate((Object)this.cInteger));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotPredicateEx() {
        PredicateUtils.notPredicate(null);
    }

    @Test
    public void testAndPredicate() {
        Assert.assertEquals((Object)true, (Object)PredicateUtils.andPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.andPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.andPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.andPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAndPredicateEx() {
        PredicateUtils.andPredicate(null, null);
    }

    @Test
    public void testAllPredicate() {
        this.assertTrue(AllPredicate.allPredicate((Predicate[])new Predicate[0]), null);
        Assert.assertEquals((Object)true, (Object)AllPredicate.allPredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), TruePredicate.truePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)false, (Object)AllPredicate.allPredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)false, (Object)AllPredicate.allPredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)false, (Object)AllPredicate.allPredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        ArrayList<Predicate> coll = new ArrayList<Predicate>();
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)true, (Object)AllPredicate.allPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)false, (Object)AllPredicate.allPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)false, (Object)AllPredicate.allPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        Assert.assertEquals((Object)false, (Object)AllPredicate.allPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        this.assertFalse(AllPredicate.allPredicate(coll), null);
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        this.assertTrue(AllPredicate.allPredicate(coll), null);
        coll.clear();
        this.assertTrue(AllPredicate.allPredicate(coll), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAllPredicateEx1() {
        AllPredicate.allPredicate((Predicate[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAllPredicateEx2() {
        AllPredicate.allPredicate((Predicate[])new Predicate[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAllPredicateEx3() {
        AllPredicate.allPredicate((Predicate[])new Predicate[]{null, null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAllPredicateEx4() {
        AllPredicate.allPredicate((Collection)null);
    }

    @Test
    public void testAllPredicateEx5() {
        AllPredicate.allPredicate(Collections.emptyList());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAllPredicateEx6() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        AllPredicate.allPredicate(coll);
    }

    @Test
    public void testOrPredicate() {
        Assert.assertEquals((Object)true, (Object)PredicateUtils.orPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.orPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.orPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.orPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOrPredicateEx() {
        PredicateUtils.orPredicate(null, null);
    }

    @Test
    public void testAnyPredicate() {
        this.assertFalse(PredicateUtils.anyPredicate((Predicate[])new Predicate[0]), null);
        Assert.assertEquals((Object)true, (Object)PredicateUtils.anyPredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), TruePredicate.truePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.anyPredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.anyPredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.anyPredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        ArrayList<Predicate> coll = new ArrayList<Predicate>();
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)true, (Object)PredicateUtils.anyPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)true, (Object)PredicateUtils.anyPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)true, (Object)PredicateUtils.anyPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        Assert.assertEquals((Object)false, (Object)PredicateUtils.anyPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        this.assertFalse(PredicateUtils.anyPredicate(coll), null);
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        this.assertTrue(PredicateUtils.anyPredicate(coll), null);
        coll.clear();
        this.assertFalse(PredicateUtils.anyPredicate(coll), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAnyPredicateEx1() {
        PredicateUtils.anyPredicate((Predicate[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAnyPredicateEx2() {
        PredicateUtils.anyPredicate((Predicate[])new Predicate[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAnyPredicateEx3() {
        PredicateUtils.anyPredicate((Predicate[])new Predicate[]{null, null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAnyPredicateEx4() {
        PredicateUtils.anyPredicate((Collection)null);
    }

    @Test
    public void testAnyPredicateEx5() {
        PredicateUtils.anyPredicate(Collections.emptyList());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAnyPredicateEx6() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        PredicateUtils.anyPredicate(coll);
    }

    @Test
    public void testEitherPredicate() {
        Assert.assertEquals((Object)false, (Object)PredicateUtils.eitherPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.eitherPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.eitherPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.eitherPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEitherPredicateEx() {
        PredicateUtils.eitherPredicate(null, null);
    }

    @Test
    public void testOnePredicate() {
        this.assertFalse(PredicateUtils.onePredicate((Predicate[])new Predicate[0]), null);
        Assert.assertEquals((Object)false, (Object)PredicateUtils.onePredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), TruePredicate.truePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.onePredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.onePredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.onePredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), TruePredicate.truePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.onePredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.onePredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        ArrayList<Predicate> coll = new ArrayList<Predicate>();
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)false, (Object)PredicateUtils.onePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)false, (Object)PredicateUtils.onePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)true, (Object)PredicateUtils.onePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        Assert.assertEquals((Object)false, (Object)PredicateUtils.onePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        this.assertFalse(PredicateUtils.onePredicate(coll), null);
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        this.assertTrue(PredicateUtils.onePredicate(coll), null);
        coll.clear();
        this.assertFalse(PredicateUtils.onePredicate(coll), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOnePredicateEx1() {
        PredicateUtils.onePredicate((Predicate[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOnePredicateEx2() {
        PredicateUtils.onePredicate((Predicate[])new Predicate[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOnePredicateEx3() {
        PredicateUtils.onePredicate((Predicate[])new Predicate[]{null, null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOnePredicateEx4() {
        PredicateUtils.onePredicate((Collection)null);
    }

    @Test
    public void testOnePredicateEx5() {
        PredicateUtils.onePredicate((Collection)Collections.EMPTY_LIST);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOnePredicateEx6() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        PredicateUtils.onePredicate(coll);
    }

    @Test
    public void testNeitherPredicate() {
        Assert.assertEquals((Object)false, (Object)PredicateUtils.neitherPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.neitherPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.neitherPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.neitherPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNeitherPredicateEx() {
        PredicateUtils.neitherPredicate(null, null);
    }

    @Test
    public void testNonePredicate() {
        this.assertTrue(PredicateUtils.nonePredicate((Predicate[])new Predicate[0]), null);
        Assert.assertEquals((Object)false, (Object)PredicateUtils.nonePredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), TruePredicate.truePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.nonePredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.nonePredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.nonePredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        ArrayList<Predicate> coll = new ArrayList<Predicate>();
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)false, (Object)PredicateUtils.nonePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)false, (Object)PredicateUtils.nonePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assert.assertEquals((Object)false, (Object)PredicateUtils.nonePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        Assert.assertEquals((Object)true, (Object)PredicateUtils.nonePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        this.assertTrue(PredicateUtils.nonePredicate(coll), null);
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        this.assertFalse(PredicateUtils.nonePredicate(coll), null);
        coll.clear();
        this.assertTrue(PredicateUtils.nonePredicate(coll), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonePredicateEx1() {
        PredicateUtils.nonePredicate((Predicate[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonePredicateEx2() {
        PredicateUtils.nonePredicate((Predicate[])new Predicate[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonePredicateEx3() {
        PredicateUtils.nonePredicate((Predicate[])new Predicate[]{null, null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonePredicateEx4() {
        PredicateUtils.nonePredicate((Collection)null);
    }

    @Test
    public void testNonePredicateEx5() {
        PredicateUtils.nonePredicate(Collections.emptyList());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonePredicateEx6() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        PredicateUtils.nonePredicate(coll);
    }

    @Test
    public void testInstanceOfPredicate() {
        Assert.assertNotNull((Object)PredicateUtils.instanceofPredicate(String.class));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.instanceofPredicate(String.class).evaluate(null));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.instanceofPredicate(String.class).evaluate(this.cObject));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.instanceofPredicate(String.class).evaluate((Object)this.cString));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.instanceofPredicate(String.class).evaluate((Object)this.cInteger));
    }

    @Test
    public void testUniquePredicate() {
        Predicate p = PredicateUtils.uniquePredicate();
        Assert.assertEquals((Object)true, (Object)p.evaluate(new Object()));
        Assert.assertEquals((Object)true, (Object)p.evaluate(new Object()));
        Assert.assertEquals((Object)true, (Object)p.evaluate(new Object()));
        Assert.assertEquals((Object)true, (Object)p.evaluate((Object)this.cString));
        Assert.assertEquals((Object)false, (Object)p.evaluate((Object)this.cString));
        Assert.assertEquals((Object)false, (Object)p.evaluate((Object)this.cString));
    }

    @Test
    public void testAsPredicateTransformer() {
        Assert.assertEquals((Object)false, (Object)PredicateUtils.asPredicate((Transformer)TransformerUtils.nopTransformer()).evaluate((Object)false));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.asPredicate((Transformer)TransformerUtils.nopTransformer()).evaluate((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAsPredicateTransformerEx1() {
        PredicateUtils.asPredicate(null);
    }

    @Test(expected=FunctorException.class)
    public void testAsPredicateTransformerEx2() {
        PredicateUtils.asPredicate((Transformer)TransformerUtils.nopTransformer()).evaluate(null);
    }

    @Test
    public void testInvokerPredicate() {
        ArrayList<Object> list = new ArrayList<Object>();
        Assert.assertEquals((Object)true, (Object)PredicateUtils.invokerPredicate((String)"isEmpty").evaluate(list));
        list.add(new Object());
        Assert.assertEquals((Object)false, (Object)PredicateUtils.invokerPredicate((String)"isEmpty").evaluate(list));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvokerPredicateEx1() {
        PredicateUtils.invokerPredicate(null);
    }

    @Test(expected=FunctorException.class)
    public void testInvokerPredicateEx2() {
        PredicateUtils.invokerPredicate((String)"isEmpty").evaluate(null);
    }

    @Test(expected=FunctorException.class)
    public void testInvokerPredicateEx3() {
        PredicateUtils.invokerPredicate((String)"noSuchMethod").evaluate(new Object());
    }

    @Test
    public void testInvokerPredicate2() {
        ArrayList<String> list = new ArrayList<String>();
        Assert.assertEquals((Object)false, (Object)PredicateUtils.invokerPredicate((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{this.cString}).evaluate(list));
        list.add(this.cString);
        Assert.assertEquals((Object)true, (Object)PredicateUtils.invokerPredicate((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{this.cString}).evaluate(list));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvokerPredicate2Ex1() {
        PredicateUtils.invokerPredicate(null, null, null);
    }

    @Test(expected=FunctorException.class)
    public void testInvokerPredicate2Ex2() {
        PredicateUtils.invokerPredicate((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{this.cString}).evaluate(null);
    }

    @Test(expected=FunctorException.class)
    public void testInvokerPredicate2Ex3() {
        PredicateUtils.invokerPredicate((String)"noSuchMethod", (Class[])new Class[]{Object.class}, (Object[])new Object[]{this.cString}).evaluate(new Object());
    }

    @Test(expected=FunctorException.class)
    public void testNullIsExceptionPredicate() {
        Assert.assertEquals((Object)true, (Object)PredicateUtils.nullIsExceptionPredicate((Predicate)TruePredicate.truePredicate()).evaluate(new Object()));
        PredicateUtils.nullIsExceptionPredicate((Predicate)TruePredicate.truePredicate()).evaluate(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullIsExceptionPredicateEx1() {
        PredicateUtils.nullIsExceptionPredicate(null);
    }

    @Test
    public void testNullIsTruePredicate() {
        Assert.assertEquals((Object)true, (Object)PredicateUtils.nullIsTruePredicate((Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.nullIsTruePredicate((Predicate)TruePredicate.truePredicate()).evaluate(new Object()));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.nullIsTruePredicate((Predicate)FalsePredicate.falsePredicate()).evaluate(new Object()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullIsTruePredicateEx1() {
        PredicateUtils.nullIsTruePredicate(null);
    }

    @Test
    public void testNullIsFalsePredicate() {
        Assert.assertEquals((Object)false, (Object)PredicateUtils.nullIsFalsePredicate((Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.nullIsFalsePredicate((Predicate)TruePredicate.truePredicate()).evaluate(new Object()));
        Assert.assertEquals((Object)false, (Object)PredicateUtils.nullIsFalsePredicate((Predicate)FalsePredicate.falsePredicate()).evaluate(new Object()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullIsFalsePredicateEx1() {
        PredicateUtils.nullIsFalsePredicate(null);
    }

    @Test
    public void testTransformedPredicate() {
        Assert.assertEquals((Object)true, (Object)PredicateUtils.transformedPredicate((Transformer)TransformerUtils.nopTransformer(), (Predicate)TruePredicate.truePredicate()).evaluate(new Object()));
        HashMap<Boolean, String> map = new HashMap<Boolean, String>();
        map.put(Boolean.TRUE, "Hello");
        Transformer t = TransformerUtils.mapTransformer(map);
        Predicate p = EqualPredicate.equalPredicate((Object)"Hello");
        Assert.assertEquals((Object)false, (Object)PredicateUtils.transformedPredicate((Transformer)t, (Predicate)p).evaluate(null));
        Assert.assertEquals((Object)true, (Object)PredicateUtils.transformedPredicate((Transformer)t, (Predicate)p).evaluate((Object)Boolean.TRUE));
        try {
            PredicateUtils.transformedPredicate(null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSingletonPatternInSerialization() {
        Object[] singletones;
        for (Object original : singletones = new Object[]{ExceptionPredicate.INSTANCE, FalsePredicate.INSTANCE, NotNullPredicate.INSTANCE, NullPredicate.INSTANCE, TruePredicate.INSTANCE}) {
            TestUtils.assertSameAfterSerialization("Singletone patern broken for " + original.getClass(), original);
        }
    }

    @Override
    protected Predicate<?> generatePredicate() {
        return TruePredicate.truePredicate();
    }
}

