/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.EnumerationUtils;

public class EnumerationUtilsTest
extends BulkTest {
    public static final String TO_LIST_FIXTURE = "this is a test";

    public EnumerationUtilsTest(String name) {
        super(name);
    }

    public void testToListWithStringTokenizer() {
        ArrayList<String> expectedList1 = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(TO_LIST_FIXTURE);
        while (st.hasMoreTokens()) {
            expectedList1.add(st.nextToken());
        }
        ArrayList<String> expectedList2 = new ArrayList<String>();
        expectedList2.add("this");
        expectedList2.add("is");
        expectedList2.add("a");
        expectedList2.add("test");
        List actualList = EnumerationUtils.toList((StringTokenizer)new StringTokenizer(TO_LIST_FIXTURE));
        EnumerationUtilsTest.assertEquals(expectedList1, expectedList2);
        EnumerationUtilsTest.assertEquals(expectedList1, (Object)actualList);
        EnumerationUtilsTest.assertEquals(expectedList2, (Object)actualList);
    }

    public void testToListWithHashtable() {
        Hashtable<String, Integer> expected = new Hashtable<String, Integer>();
        expected.put("one", 1);
        expected.put("two", 2);
        expected.put("three", 3);
        List actualEltList = EnumerationUtils.toList(expected.elements());
        EnumerationUtilsTest.assertEquals((int)expected.size(), (int)actualEltList.size());
        EnumerationUtilsTest.assertTrue((boolean)actualEltList.contains(1));
        EnumerationUtilsTest.assertTrue((boolean)actualEltList.contains(2));
        EnumerationUtilsTest.assertTrue((boolean)actualEltList.contains(3));
        ArrayList<Integer> expectedEltList = new ArrayList<Integer>();
        expectedEltList.add(1);
        expectedEltList.add(2);
        expectedEltList.add(3);
        EnumerationUtilsTest.assertTrue((boolean)actualEltList.containsAll(expectedEltList));
        List actualKeyList = EnumerationUtils.toList(expected.keys());
        EnumerationUtilsTest.assertEquals((int)expected.size(), (int)actualEltList.size());
        EnumerationUtilsTest.assertTrue((boolean)actualKeyList.contains("one"));
        EnumerationUtilsTest.assertTrue((boolean)actualKeyList.contains("two"));
        EnumerationUtilsTest.assertTrue((boolean)actualKeyList.contains("three"));
        ArrayList<String> expectedKeyList = new ArrayList<String>();
        expectedKeyList.add("one");
        expectedKeyList.add("two");
        expectedKeyList.add("three");
        EnumerationUtilsTest.assertTrue((boolean)actualKeyList.containsAll(expectedKeyList));
    }

    public static Test suite() {
        return BulkTest.makeSuite(EnumerationUtilsTest.class);
    }
}

