/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.TestUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.ExceptionClosure;
import org.apache.commons.collections4.functors.FalsePredicate;
import org.apache.commons.collections4.functors.NOPClosure;
import org.apache.commons.collections4.functors.TruePredicate;

public class ClosureUtilsTest
extends TestCase {
    private static final Object cString = "Hello";

    public void testExceptionClosure() {
        ClosureUtilsTest.assertNotNull((Object)ClosureUtils.exceptionClosure());
        ClosureUtilsTest.assertSame((Object)ClosureUtils.exceptionClosure(), (Object)ClosureUtils.exceptionClosure());
        try {
            ClosureUtils.exceptionClosure().execute(null);
        }
        catch (FunctorException ex) {
            try {
                ClosureUtils.exceptionClosure().execute(cString);
            }
            catch (FunctorException ex2) {
                return;
            }
        }
        ClosureUtilsTest.fail();
    }

    public void testNopClosure() {
        StringBuilder buf = new StringBuilder("Hello");
        ClosureUtils.nopClosure().execute(null);
        ClosureUtilsTest.assertEquals((String)"Hello", (String)buf.toString());
        ClosureUtils.nopClosure().execute((Object)"Hello");
        ClosureUtilsTest.assertEquals((String)"Hello", (String)buf.toString());
    }

    public void testInvokeClosure() {
        StringBuffer buf = new StringBuffer("Hello");
        ClosureUtils.invokerClosure((String)"reverse").execute((Object)buf);
        ClosureUtilsTest.assertEquals((String)"olleH", (String)buf.toString());
        buf = new StringBuffer("Hello");
        ClosureUtils.invokerClosure((String)"setLength", (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{2}).execute((Object)buf);
        ClosureUtilsTest.assertEquals((String)"He", (String)buf.toString());
    }

    public void testForClosure() {
        MockClosure cmd = new MockClosure();
        ClosureUtils.forClosure((int)5, cmd).execute(null);
        ClosureUtilsTest.assertEquals((int)5, (int)cmd.count);
        ClosureUtilsTest.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)0, new MockClosure()));
        ClosureUtilsTest.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)-1, new MockClosure()));
        ClosureUtilsTest.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)1, null));
        ClosureUtilsTest.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)3, null));
        ClosureUtilsTest.assertSame(cmd, (Object)ClosureUtils.forClosure((int)1, cmd));
    }

    public void testWhileClosure() {
        MockClosure cmd = new MockClosure();
        ClosureUtils.whileClosure((Predicate)FalsePredicate.falsePredicate(), cmd).execute(null);
        ClosureUtilsTest.assertEquals((int)0, (int)cmd.count);
        cmd = new MockClosure();
        ClosureUtils.whileClosure((Predicate)PredicateUtils.uniquePredicate(), cmd).execute(null);
        ClosureUtilsTest.assertEquals((int)1, (int)cmd.count);
        try {
            ClosureUtils.whileClosure(null, (Closure)ClosureUtils.nopClosure());
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.whileClosure((Predicate)FalsePredicate.falsePredicate(), null);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.whileClosure(null, null);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDoWhileClosure() {
        MockClosure cmd = new MockClosure();
        ClosureUtils.doWhileClosure(cmd, (Predicate)FalsePredicate.falsePredicate()).execute(null);
        ClosureUtilsTest.assertEquals((int)1, (int)cmd.count);
        cmd = new MockClosure();
        ClosureUtils.doWhileClosure(cmd, (Predicate)PredicateUtils.uniquePredicate()).execute(null);
        ClosureUtilsTest.assertEquals((int)2, (int)cmd.count);
        try {
            ClosureUtils.doWhileClosure(null, null);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testChainedClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = new MockClosure();
        ClosureUtils.chainedClosure((Closure[])new Closure[]{a, b}).execute(null);
        ClosureUtilsTest.assertEquals((int)1, (int)a.count);
        ClosureUtilsTest.assertEquals((int)1, (int)b.count);
        a = new MockClosure();
        b = new MockClosure();
        ClosureUtils.chainedClosure((Closure[])new Closure[]{a, b, a}).execute(null);
        ClosureUtilsTest.assertEquals((int)2, (int)a.count);
        ClosureUtilsTest.assertEquals((int)1, (int)b.count);
        a = new MockClosure();
        b = new MockClosure();
        ArrayList coll = new ArrayList();
        coll.add(b);
        coll.add(a);
        coll.add(b);
        ClosureUtils.chainedClosure(coll).execute(null);
        ClosureUtilsTest.assertEquals((int)1, (int)a.count);
        ClosureUtilsTest.assertEquals((int)2, (int)b.count);
        ClosureUtilsTest.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.chainedClosure((Closure[])new Closure[0]));
        ClosureUtilsTest.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.chainedClosure(Collections.emptyList()));
        try {
            ClosureUtils.chainedClosure((Closure[])new Closure[]{null, null});
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.chainedClosure((Closure[])null);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.chainedClosure((Collection)null);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.chainedClosure((Closure[])new Closure[]{null, null});
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            coll = new ArrayList();
            coll.add(null);
            coll.add(null);
            ClosureUtils.chainedClosure(coll);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testIfClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = null;
        ClosureUtils.ifClosure((Predicate)TruePredicate.truePredicate(), a).execute(null);
        ClosureUtilsTest.assertEquals((int)1, (int)a.count);
        a = new MockClosure();
        ClosureUtils.ifClosure((Predicate)FalsePredicate.falsePredicate(), a).execute(null);
        ClosureUtilsTest.assertEquals((int)0, (int)a.count);
        a = new MockClosure();
        b = new MockClosure();
        ClosureUtils.ifClosure((Predicate)TruePredicate.truePredicate(), a, b).execute(null);
        ClosureUtilsTest.assertEquals((int)1, (int)a.count);
        ClosureUtilsTest.assertEquals((int)0, (int)b.count);
        a = new MockClosure();
        b = new MockClosure();
        ClosureUtils.ifClosure((Predicate)FalsePredicate.falsePredicate(), a, b).execute(null);
        ClosureUtilsTest.assertEquals((int)0, (int)a.count);
        ClosureUtilsTest.assertEquals((int)1, (int)b.count);
    }

    public void testSwitchClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = new MockClosure();
        ClosureUtils.switchClosure((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Closure[])new Closure[]{a, b}).execute((Object)"WELL");
        ClosureUtilsTest.assertEquals((int)0, (int)a.count);
        ClosureUtilsTest.assertEquals((int)0, (int)b.count);
        a.reset();
        b.reset();
        ClosureUtils.switchClosure((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Closure[])new Closure[]{a, b}).execute((Object)"HELLO");
        ClosureUtilsTest.assertEquals((int)1, (int)a.count);
        ClosureUtilsTest.assertEquals((int)0, (int)b.count);
        a.reset();
        b.reset();
        MockClosure c = new MockClosure();
        ClosureUtils.switchClosure((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Closure[])new Closure[]{a, b}, c).execute((Object)"WELL");
        ClosureUtilsTest.assertEquals((int)0, (int)a.count);
        ClosureUtilsTest.assertEquals((int)0, (int)b.count);
        ClosureUtilsTest.assertEquals((int)1, (int)c.count);
        a.reset();
        b.reset();
        HashMap map = new HashMap();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        ClosureUtils.switchClosure(map).execute(null);
        ClosureUtilsTest.assertEquals((int)0, (int)a.count);
        ClosureUtilsTest.assertEquals((int)0, (int)b.count);
        a.reset();
        b.reset();
        map.clear();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        ClosureUtils.switchClosure(map).execute((Object)"THERE");
        ClosureUtilsTest.assertEquals((int)0, (int)a.count);
        ClosureUtilsTest.assertEquals((int)1, (int)b.count);
        a.reset();
        b.reset();
        c.reset();
        map.clear();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        map.put(null, c);
        ClosureUtils.switchClosure(map).execute((Object)"WELL");
        ClosureUtilsTest.assertEquals((int)0, (int)a.count);
        ClosureUtilsTest.assertEquals((int)0, (int)b.count);
        ClosureUtilsTest.assertEquals((int)1, (int)c.count);
        ClosureUtilsTest.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchClosure((Predicate[])new Predicate[0], (Closure[])new Closure[0]));
        ClosureUtilsTest.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchClosure(new HashMap()));
        map.clear();
        map.put(null, null);
        ClosureUtilsTest.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchClosure(map));
        try {
            ClosureUtils.switchClosure(null, null);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.switchClosure((Predicate[])null, (Closure[])null);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.switchClosure((Map)null);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.switchClosure((Predicate[])new Predicate[2], (Closure[])new Closure[2]);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.switchClosure((Predicate[])new Predicate[]{TruePredicate.truePredicate()}, (Closure[])new Closure[]{a, b});
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testSwitchMapClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = new MockClosure();
        HashMap map = new HashMap();
        map.put("HELLO", a);
        map.put("THERE", b);
        ClosureUtils.switchMapClosure(map).execute(null);
        ClosureUtilsTest.assertEquals((int)0, (int)a.count);
        ClosureUtilsTest.assertEquals((int)0, (int)b.count);
        a.reset();
        b.reset();
        map.clear();
        map.put("HELLO", a);
        map.put("THERE", b);
        ClosureUtils.switchMapClosure(map).execute((Object)"THERE");
        ClosureUtilsTest.assertEquals((int)0, (int)a.count);
        ClosureUtilsTest.assertEquals((int)1, (int)b.count);
        a.reset();
        b.reset();
        map.clear();
        MockClosure c = new MockClosure();
        map.put("HELLO", a);
        map.put("THERE", b);
        map.put(null, c);
        ClosureUtils.switchMapClosure(map).execute((Object)"WELL");
        ClosureUtilsTest.assertEquals((int)0, (int)a.count);
        ClosureUtilsTest.assertEquals((int)0, (int)b.count);
        ClosureUtilsTest.assertEquals((int)1, (int)c.count);
        ClosureUtilsTest.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchMapClosure(new HashMap()));
        try {
            ClosureUtils.switchMapClosure(null);
            ClosureUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testTransformerClosure() {
        MockTransformer mock = new MockTransformer();
        Closure closure = ClosureUtils.asClosure(mock);
        closure.execute(null);
        ClosureUtilsTest.assertEquals((int)1, (int)mock.count);
        closure.execute(null);
        ClosureUtilsTest.assertEquals((int)2, (int)mock.count);
        ClosureUtilsTest.assertEquals((Object)ClosureUtils.nopClosure(), (Object)ClosureUtils.asClosure(null));
    }

    public void testSingletonPatternInSerialization() {
        Object[] singletones;
        for (Object original : singletones = new Object[]{ExceptionClosure.INSTANCE, NOPClosure.INSTANCE}) {
            TestUtils.assertSameAfterSerialization("Singletone patern broken for " + original.getClass(), original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MockTransformer<T>
    implements Transformer<T, T> {
        int count = 0;

        MockTransformer() {
        }

        public T transform(T object) {
            ++this.count;
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MockClosure<T>
    implements Closure<T> {
        int count = 0;

        MockClosure() {
        }

        public void execute(T object) {
            ++this.count;
        }

        public void reset() {
            this.count = 0;
        }
    }
}

