/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.set.AbstractSortedSetTest;
import org.apache.commons.collections4.set.TransformedSortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedSortedSetTest<E>
extends AbstractSortedSetTest<E> {
    public TransformedSortedSetTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(TransformedSortedSetTest.class);
    }

    @Override
    public SortedSet<E> makeObject() {
        return TransformedSortedSet.transformingSortedSet(new TreeSet(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Override
    public SortedSet<E> makeFullCollection() {
        TreeSet set = new TreeSet();
        set.addAll(Arrays.asList(this.getFullElements()));
        return TransformedSortedSet.transformingSortedSet(set, TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    public void testTransformedSet() {
        TransformedSortedSet set = TransformedSortedSet.transformingSortedSet(new TreeSet(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedSortedSetTest.assertEquals((int)0, (int)set.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < els.length; ++i) {
            set.add(els[i]);
            TransformedSortedSetTest.assertEquals((int)(i + 1), (int)set.size());
            TransformedSortedSetTest.assertEquals((boolean)true, (boolean)set.contains(Integer.valueOf((String)els[i])));
        }
        TransformedSortedSetTest.assertEquals((boolean)true, (boolean)set.remove(Integer.valueOf((String)els[0])));
    }

    public void testTransformedSet_decorateTransform() {
        TreeSet originalSet = new TreeSet();
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        Collections.addAll(originalSet, els);
        Set set = TransformedSortedSet.transformedSet(originalSet, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedSortedSetTest.assertEquals((int)els.length, (int)set.size());
        for (Object el : els) {
            TransformedSortedSetTest.assertEquals((boolean)true, (boolean)set.contains(Integer.valueOf((String)el)));
        }
        TransformedSortedSetTest.assertEquals((boolean)true, (boolean)set.remove(Integer.valueOf((String)els[0])));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

