/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.Flat3Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flat3MapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final Integer THREE = 3;
    private static final String TEN = "10";
    private static final String TWENTY = "20";
    private static final String THIRTY = "30";

    public Flat3MapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(Flat3MapTest.class);
    }

    @Override
    public Flat3Map<K, V> makeObject() {
        return new Flat3Map();
    }

    public void testEquals1() {
        Flat3Map<K, V> map1 = this.makeObject();
        map1.put((Object)"a", (Object)"testA");
        map1.put((Object)"b", (Object)"testB");
        Flat3Map<K, V> map2 = this.makeObject();
        map2.put((Object)"a", (Object)"testB");
        map2.put((Object)"b", (Object)"testA");
        Flat3MapTest.assertEquals((boolean)false, (boolean)map1.equals(map2));
    }

    public void testEquals2() {
        Flat3Map<K, V> map1 = this.makeObject();
        map1.put((Object)"a", (Object)"testA");
        map1.put((Object)"b", (Object)"testB");
        Flat3Map<K, V> map2 = this.makeObject();
        map2.put((Object)"a", (Object)"testB");
        map2.put((Object)"c", (Object)"testA");
        Flat3MapTest.assertEquals((boolean)false, (boolean)map1.equals(map2));
    }

    public void testClone2() {
        Flat3Map<K, V> map = this.makeObject();
        Flat3MapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        Flat3MapTest.assertEquals((int)2, (int)map.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)TWO));
        Flat3MapTest.assertSame((Object)TEN, (Object)map.get((Object)ONE));
        Flat3MapTest.assertSame((Object)TWENTY, (Object)map.get((Object)TWO));
        Flat3Map cloned = map.clone();
        Flat3MapTest.assertEquals((int)2, (int)cloned.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)TWO));
        Flat3MapTest.assertSame((Object)TEN, (Object)cloned.get((Object)ONE));
        Flat3MapTest.assertSame((Object)TWENTY, (Object)cloned.get((Object)TWO));
        map.put((Object)TEN, (Object)ONE);
        map.put((Object)TWENTY, (Object)TWO);
        Flat3MapTest.assertEquals((int)4, (int)map.size());
        Flat3MapTest.assertEquals((int)2, (int)cloned.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)TWO));
        Flat3MapTest.assertSame((Object)TEN, (Object)cloned.get((Object)ONE));
        Flat3MapTest.assertSame((Object)TWENTY, (Object)cloned.get((Object)TWO));
    }

    public void testClone4() {
        Flat3Map<K, V> map = this.makeObject();
        Flat3MapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)TEN, (Object)ONE);
        map.put((Object)TWENTY, (Object)TWO);
        Flat3Map cloned = map.clone();
        Flat3MapTest.assertEquals((int)4, (int)map.size());
        Flat3MapTest.assertEquals((int)4, (int)cloned.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)TWO));
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)TEN));
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)TWENTY));
        Flat3MapTest.assertSame((Object)TEN, (Object)cloned.get((Object)ONE));
        Flat3MapTest.assertSame((Object)TWENTY, (Object)cloned.get((Object)TWO));
        Flat3MapTest.assertSame((Object)ONE, (Object)cloned.get((Object)TEN));
        Flat3MapTest.assertSame((Object)TWO, (Object)cloned.get((Object)TWENTY));
        map.clear();
        Flat3MapTest.assertEquals((int)0, (int)map.size());
        Flat3MapTest.assertEquals((int)4, (int)cloned.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)TWO));
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)TEN));
        Flat3MapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)TWENTY));
        Flat3MapTest.assertSame((Object)TEN, (Object)cloned.get((Object)ONE));
        Flat3MapTest.assertSame((Object)TWENTY, (Object)cloned.get((Object)TWO));
        Flat3MapTest.assertSame((Object)ONE, (Object)cloned.get((Object)TEN));
        Flat3MapTest.assertSame((Object)TWO, (Object)cloned.get((Object)TWENTY));
    }

    public void testSerialisation0() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(map);
        byte[] bytes = bout.toByteArray();
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bin);
        Flat3Map ser = (Flat3Map)in.readObject();
        in.close();
        Flat3MapTest.assertEquals((int)0, (int)map.size());
        Flat3MapTest.assertEquals((int)0, (int)ser.size());
    }

    public void testSerialisation2() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(map);
        byte[] bytes = bout.toByteArray();
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bin);
        Flat3Map ser = (Flat3Map)in.readObject();
        in.close();
        Flat3MapTest.assertEquals((int)2, (int)map.size());
        Flat3MapTest.assertEquals((int)2, (int)ser.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)ser.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)ser.containsKey((Object)TWO));
        Flat3MapTest.assertEquals((Object)TEN, (Object)ser.get((Object)ONE));
        Flat3MapTest.assertEquals((Object)TWENTY, (Object)ser.get((Object)TWO));
    }

    public void testSerialisation4() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)TEN, (Object)ONE);
        map.put((Object)TWENTY, (Object)TWO);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(map);
        byte[] bytes = bout.toByteArray();
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bin);
        Flat3Map ser = (Flat3Map)in.readObject();
        in.close();
        Flat3MapTest.assertEquals((int)4, (int)map.size());
        Flat3MapTest.assertEquals((int)4, (int)ser.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)ser.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)ser.containsKey((Object)TWO));
        Flat3MapTest.assertEquals((boolean)true, (boolean)ser.containsKey((Object)TEN));
        Flat3MapTest.assertEquals((boolean)true, (boolean)ser.containsKey((Object)TWENTY));
        Flat3MapTest.assertEquals((Object)TEN, (Object)ser.get((Object)ONE));
        Flat3MapTest.assertEquals((Object)TWENTY, (Object)ser.get((Object)TWO));
        Flat3MapTest.assertEquals((Object)ONE, (Object)ser.get((Object)TEN));
        Flat3MapTest.assertEquals((Object)TWO, (Object)ser.get((Object)TWENTY));
    }

    public void testEntryIteratorSetValue1() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = (Map.Entry)it.next();
        entry.setValue("NewValue");
        Flat3MapTest.assertEquals((int)3, (int)map.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)TWO));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)THREE));
        Flat3MapTest.assertEquals((Object)"NewValue", (Object)map.get((Object)ONE));
        Flat3MapTest.assertEquals((Object)TWENTY, (Object)map.get((Object)TWO));
        Flat3MapTest.assertEquals((Object)THIRTY, (Object)map.get((Object)THREE));
    }

    public void testEntryIteratorSetValue2() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        Iterator it = map.entrySet().iterator();
        it.next();
        Map.Entry entry = (Map.Entry)it.next();
        entry.setValue("NewValue");
        Flat3MapTest.assertEquals((int)3, (int)map.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)TWO));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)THREE));
        Flat3MapTest.assertEquals((Object)TEN, (Object)map.get((Object)ONE));
        Flat3MapTest.assertEquals((Object)"NewValue", (Object)map.get((Object)TWO));
        Flat3MapTest.assertEquals((Object)THIRTY, (Object)map.get((Object)THREE));
    }

    public void testEntryIteratorSetValue3() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        Iterator it = map.entrySet().iterator();
        it.next();
        it.next();
        Map.Entry entry = (Map.Entry)it.next();
        entry.setValue("NewValue");
        Flat3MapTest.assertEquals((int)3, (int)map.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)TWO));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)THREE));
        Flat3MapTest.assertEquals((Object)TEN, (Object)map.get((Object)ONE));
        Flat3MapTest.assertEquals((Object)TWENTY, (Object)map.get((Object)TWO));
        Flat3MapTest.assertEquals((Object)"NewValue", (Object)map.get((Object)THREE));
    }

    public void testMapIteratorSetValue1() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        MapIterator it = map.mapIterator();
        it.next();
        it.setValue((Object)"NewValue");
        Flat3MapTest.assertEquals((int)3, (int)map.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)TWO));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)THREE));
        Flat3MapTest.assertEquals((Object)"NewValue", (Object)map.get((Object)ONE));
        Flat3MapTest.assertEquals((Object)TWENTY, (Object)map.get((Object)TWO));
        Flat3MapTest.assertEquals((Object)THIRTY, (Object)map.get((Object)THREE));
    }

    public void testMapIteratorSetValue2() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        MapIterator it = map.mapIterator();
        it.next();
        it.next();
        it.setValue((Object)"NewValue");
        Flat3MapTest.assertEquals((int)3, (int)map.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)TWO));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)THREE));
        Flat3MapTest.assertEquals((Object)TEN, (Object)map.get((Object)ONE));
        Flat3MapTest.assertEquals((Object)"NewValue", (Object)map.get((Object)TWO));
        Flat3MapTest.assertEquals((Object)THIRTY, (Object)map.get((Object)THREE));
    }

    public void testMapIteratorSetValue3() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        MapIterator it = map.mapIterator();
        it.next();
        it.next();
        it.next();
        it.setValue((Object)"NewValue");
        Flat3MapTest.assertEquals((int)3, (int)map.size());
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)ONE));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)TWO));
        Flat3MapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)THREE));
        Flat3MapTest.assertEquals((Object)TEN, (Object)map.get((Object)ONE));
        Flat3MapTest.assertEquals((Object)TWENTY, (Object)map.get((Object)TWO));
        Flat3MapTest.assertEquals((Object)"NewValue", (Object)map.get((Object)THREE));
    }

    @Override
    public BulkTest bulkTestMapIterator() {
        return new TestFlatMapIterator();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    public void testCollections261() {
        Flat3Map m = new Flat3Map();
        m.put((Object)1, (Object)1);
        m.put((Object)0, (Object)0);
        Flat3MapTest.assertEquals((Object)1, (Object)m.remove((Object)1));
        Flat3MapTest.assertEquals((Object)0, (Object)m.remove((Object)0));
        m.put((Object)2, (Object)2);
        m.put((Object)1, (Object)1);
        m.put((Object)0, (Object)0);
        Flat3MapTest.assertEquals((Object)2, (Object)m.remove((Object)2));
        Flat3MapTest.assertEquals((Object)1, (Object)m.remove((Object)1));
        Flat3MapTest.assertEquals((Object)0, (Object)m.remove((Object)0));
    }

    public void testToString() {
        Flat3Map m = new Flat3Map();
        String string0 = m.toString();
        Flat3MapTest.assertNotNull((Object)string0);
        m.put((Object)1, (Object)1);
        String string1 = m.toString();
        Flat3MapTest.assertNotNull((Object)string1);
        Flat3MapTest.assertNotSame((Object)string0, (Object)string1);
        m.put((Object)0, (Object)0);
        String string2 = m.toString();
        Flat3MapTest.assertNotNull((Object)string2);
        Flat3MapTest.assertNotSame((Object)string0, (Object)string2);
        Flat3MapTest.assertNotSame((Object)string1, (Object)string2);
        m.put((Object)2, (Object)2);
        String string3 = m.toString();
        Flat3MapTest.assertNotNull((Object)string3);
        Flat3MapTest.assertNotSame((Object)string0, (Object)string3);
        Flat3MapTest.assertNotSame((Object)string1, (Object)string3);
        Flat3MapTest.assertNotSame((Object)string2, (Object)string3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestFlatMapIterator
    extends AbstractMapIteratorTest<K, V> {
        public TestFlatMapIterator() {
            super("TestFlatMapIterator");
        }

        @Override
        public V[] addSetValues() {
            return Flat3MapTest.this.getNewSampleValues();
        }

        @Override
        public boolean supportsRemove() {
            return Flat3MapTest.this.isRemoveSupported();
        }

        @Override
        public boolean supportsSetValue() {
            return Flat3MapTest.this.isSetValueSupported();
        }

        @Override
        public MapIterator<K, V> makeEmptyIterator() {
            Flat3MapTest.this.resetEmpty();
            return Flat3MapTest.this.getMap().mapIterator();
        }

        @Override
        public MapIterator<K, V> makeObject() {
            Flat3MapTest.this.resetFull();
            return Flat3MapTest.this.getMap().mapIterator();
        }

        @Override
        public IterableMap<K, V> getMap() {
            return Flat3MapTest.this.getMap();
        }

        @Override
        public Map<K, V> getConfirmedMap() {
            return Flat3MapTest.this.getConfirmed();
        }

        @Override
        public void verify() {
            super.verify();
            Flat3MapTest.this.verify();
        }
    }
}

