/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;
import org.apache.commons.collections4.map.AbstractMapTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIterableMapTest<K, V>
extends AbstractMapTest<K, V> {
    public AbstractIterableMapTest(String testName) {
        super(testName);
    }

    @Override
    public abstract IterableMap<K, V> makeObject();

    @Override
    public IterableMap<K, V> makeFullMap() {
        return (IterableMap)super.makeFullMap();
    }

    public void testFailFastEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        if (!this.isFailFastExpected()) {
            return;
        }
        this.resetFull();
        Iterator it = this.getMap().entrySet().iterator();
        Map.Entry val = (Map.Entry)it.next();
        this.getMap().remove(val.getKey());
        try {
            it.next();
            AbstractIterableMapTest.fail();
        }
        catch (ConcurrentModificationException ex) {
            // empty catch block
        }
        this.resetFull();
        it = this.getMap().entrySet().iterator();
        it.next();
        this.getMap().clear();
        try {
            it.next();
            AbstractIterableMapTest.fail();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void testFailFastKeySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        if (!this.isFailFastExpected()) {
            return;
        }
        this.resetFull();
        Iterator it = this.getMap().keySet().iterator();
        Object val = it.next();
        this.getMap().remove(val);
        try {
            it.next();
            AbstractIterableMapTest.fail();
        }
        catch (ConcurrentModificationException ex) {
            // empty catch block
        }
        this.resetFull();
        it = this.getMap().keySet().iterator();
        it.next();
        this.getMap().clear();
        try {
            it.next();
            AbstractIterableMapTest.fail();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void testFailFastValues() {
        if (!this.isRemoveSupported()) {
            return;
        }
        if (!this.isFailFastExpected()) {
            return;
        }
        this.resetFull();
        Iterator it = this.getMap().values().iterator();
        it.next();
        this.getMap().remove(this.getMap().keySet().iterator().next());
        try {
            it.next();
            AbstractIterableMapTest.fail();
        }
        catch (ConcurrentModificationException ex) {
            // empty catch block
        }
        this.resetFull();
        it = this.getMap().values().iterator();
        it.next();
        this.getMap().clear();
        try {
            it.next();
            AbstractIterableMapTest.fail();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public BulkTest bulkTestMapIterator() {
        return new InnerTestMapIterator();
    }

    @Override
    public IterableMap<K, V> getMap() {
        return (IterableMap)super.getMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InnerTestMapIterator
    extends AbstractMapIteratorTest<K, V> {
        public InnerTestMapIterator() {
            super("InnerTestMapIterator");
        }

        @Override
        public V[] addSetValues() {
            return AbstractIterableMapTest.this.getNewSampleValues();
        }

        @Override
        public boolean supportsRemove() {
            return AbstractIterableMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isGetStructuralModify() {
            return AbstractIterableMapTest.this.isGetStructuralModify();
        }

        @Override
        public boolean supportsSetValue() {
            return AbstractIterableMapTest.this.isSetValueSupported();
        }

        @Override
        public MapIterator<K, V> makeEmptyIterator() {
            AbstractIterableMapTest.this.resetEmpty();
            return AbstractIterableMapTest.this.getMap().mapIterator();
        }

        @Override
        public MapIterator<K, V> makeObject() {
            AbstractIterableMapTest.this.resetFull();
            return AbstractIterableMapTest.this.getMap().mapIterator();
        }

        @Override
        public Map<K, V> getMap() {
            return AbstractIterableMapTest.this.getMap();
        }

        @Override
        public Map<K, V> getConfirmedMap() {
            return AbstractIterableMapTest.this.getConfirmed();
        }

        @Override
        public void verify() {
            super.verify();
            AbstractIterableMapTest.this.verify();
        }
    }
}

