/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.PredicatedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicatedListTest<E>
extends AbstractListTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = new Predicate<E>(){

        public boolean evaluate(E o) {
            return o instanceof String;
        }
    };

    public PredicatedListTest(String testName) {
        super(testName);
    }

    protected List<E> decorateList(List<E> list, Predicate<E> predicate) {
        return PredicatedList.predicatedList(list, predicate);
    }

    @Override
    public List<E> makeObject() {
        return this.decorateList(new ArrayList(), this.truePredicate);
    }

    @Override
    public E[] getFullElements() {
        return new Object[]{"1", "3", "5", "7", "2", "4", "6"};
    }

    public List<E> makeTestList() {
        return this.decorateList(new ArrayList(), this.testPredicate);
    }

    public void testIllegalAdd() {
        List<Integer> list = this.makeTestList();
        Integer i = 3;
        try {
            list.add(i);
            PredicatedListTest.fail((String)"Integer should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedListTest.assertTrue((String)"Collection shouldn't contain illegal element", (!list.contains(i) ? 1 : 0) != 0);
    }

    public void testIllegalAddAll() {
        List list = this.makeTestList();
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add("one");
        elements.add("two");
        elements.add(3);
        elements.add("four");
        try {
            list.addAll(0, elements);
            PredicatedListTest.fail((String)"Integer should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedListTest.assertTrue((String)"List shouldn't contain illegal element", (!list.contains("one") ? 1 : 0) != 0);
        PredicatedListTest.assertTrue((String)"List shouldn't contain illegal element", (!list.contains("two") ? 1 : 0) != 0);
        PredicatedListTest.assertTrue((String)"List shouldn't contain illegal element", (!list.contains(3) ? 1 : 0) != 0);
        PredicatedListTest.assertTrue((String)"List shouldn't contain illegal element", (!list.contains("four") ? 1 : 0) != 0);
    }

    public void testIllegalSet() {
        List<Integer> list = this.makeTestList();
        try {
            list.set(0, 3);
            PredicatedListTest.fail((String)"Integer should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLegalAddAll() {
        List<String> list = this.makeTestList();
        list.add("zero");
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("one");
        elements.add("two");
        elements.add("three");
        list.addAll(1, elements);
        PredicatedListTest.assertTrue((String)"List should contain legal element", (boolean)list.contains("zero"));
        PredicatedListTest.assertTrue((String)"List should contain legal element", (boolean)list.contains("one"));
        PredicatedListTest.assertTrue((String)"List should contain legal element", (boolean)list.contains("two"));
        PredicatedListTest.assertTrue((String)"List should contain legal element", (boolean)list.contains("three"));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

