/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.list.AbstractLinkedListTest;
import org.apache.commons.collections4.list.CursorableLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorableLinkedListTest<E>
extends AbstractLinkedListTest<E> {
    private CursorableLinkedList<E> list;

    public CursorableLinkedListTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(CursorableLinkedListTest.class);
    }

    public void setUp() {
        this.list = new CursorableLinkedList();
    }

    @Override
    public CursorableLinkedList<E> makeObject() {
        return new CursorableLinkedList();
    }

    public void testAdd() {
        CursorableLinkedListTest.assertEquals((String)"[]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.add((Object)1));
        CursorableLinkedListTest.assertEquals((String)"[1]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.add((Object)2));
        CursorableLinkedListTest.assertEquals((String)"[1, 2]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.add((Object)3));
        CursorableLinkedListTest.assertEquals((String)"[1, 2, 3]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.addFirst((Object)0));
        CursorableLinkedListTest.assertEquals((String)"[0, 1, 2, 3]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.addLast((Object)4));
        CursorableLinkedListTest.assertEquals((String)"[0, 1, 2, 3, 4]", (String)this.list.toString());
        this.list.add(0, (Object)-2);
        CursorableLinkedListTest.assertEquals((String)"[-2, 0, 1, 2, 3, 4]", (String)this.list.toString());
        this.list.add(1, (Object)-1);
        CursorableLinkedListTest.assertEquals((String)"[-2, -1, 0, 1, 2, 3, 4]", (String)this.list.toString());
        this.list.add(7, (Object)5);
        CursorableLinkedListTest.assertEquals((String)"[-2, -1, 0, 1, 2, 3, 4, 5]", (String)this.list.toString());
        LinkedList<String> list2 = new LinkedList<String>();
        list2.add("A");
        list2.add("B");
        list2.add("C");
        CursorableLinkedListTest.assertTrue((boolean)this.list.addAll(list2));
        CursorableLinkedListTest.assertEquals((String)"[-2, -1, 0, 1, 2, 3, 4, 5, A, B, C]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.addAll(3, list2));
        CursorableLinkedListTest.assertEquals((String)"[-2, -1, 0, A, B, C, 1, 2, 3, 4, 5, A, B, C]", (String)this.list.toString());
    }

    public void testClear() {
        CursorableLinkedListTest.assertEquals((int)0, (int)this.list.size());
        CursorableLinkedListTest.assertTrue((boolean)this.list.isEmpty());
        this.list.clear();
        CursorableLinkedListTest.assertEquals((int)0, (int)this.list.size());
        CursorableLinkedListTest.assertTrue((boolean)this.list.isEmpty());
        this.list.add((Object)"element");
        CursorableLinkedListTest.assertEquals((int)1, (int)this.list.size());
        CursorableLinkedListTest.assertTrue((!this.list.isEmpty() ? 1 : 0) != 0);
        this.list.clear();
        CursorableLinkedListTest.assertEquals((int)0, (int)this.list.size());
        CursorableLinkedListTest.assertTrue((boolean)this.list.isEmpty());
        this.list.add((Object)"element1");
        this.list.add((Object)"element2");
        CursorableLinkedListTest.assertEquals((int)2, (int)this.list.size());
        CursorableLinkedListTest.assertTrue((!this.list.isEmpty() ? 1 : 0) != 0);
        this.list.clear();
        CursorableLinkedListTest.assertEquals((int)0, (int)this.list.size());
        CursorableLinkedListTest.assertTrue((boolean)this.list.isEmpty());
        for (int i = 0; i < 1000; ++i) {
            this.list.add((Object)i);
        }
        CursorableLinkedListTest.assertEquals((int)1000, (int)this.list.size());
        CursorableLinkedListTest.assertTrue((!this.list.isEmpty() ? 1 : 0) != 0);
        this.list.clear();
        CursorableLinkedListTest.assertEquals((int)0, (int)this.list.size());
        CursorableLinkedListTest.assertTrue((boolean)this.list.isEmpty());
    }

    public void testContains() {
        CursorableLinkedListTest.assertTrue((!this.list.contains((Object)"A") ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((boolean)this.list.add((Object)"A"));
        CursorableLinkedListTest.assertTrue((boolean)this.list.contains((Object)"A"));
        CursorableLinkedListTest.assertTrue((boolean)this.list.add((Object)"B"));
        CursorableLinkedListTest.assertTrue((boolean)this.list.contains((Object)"A"));
        CursorableLinkedListTest.assertTrue((boolean)this.list.addFirst((Object)"a"));
        CursorableLinkedListTest.assertTrue((boolean)this.list.contains((Object)"A"));
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"a"));
        CursorableLinkedListTest.assertTrue((boolean)this.list.contains((Object)"A"));
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"A"));
        CursorableLinkedListTest.assertTrue((!this.list.contains((Object)"A") ? 1 : 0) != 0);
    }

    public void testContainsAll() {
        CursorableLinkedListTest.assertTrue((boolean)this.list.containsAll(this.list));
        LinkedList<String> list2 = new LinkedList<String>();
        CursorableLinkedListTest.assertTrue((boolean)this.list.containsAll(list2));
        list2.add("A");
        CursorableLinkedListTest.assertTrue((!this.list.containsAll(list2) ? 1 : 0) != 0);
        this.list.add((Object)"B");
        this.list.add((Object)"A");
        CursorableLinkedListTest.assertTrue((boolean)this.list.containsAll(list2));
        list2.add("B");
        CursorableLinkedListTest.assertTrue((boolean)this.list.containsAll(list2));
        list2.add("C");
        CursorableLinkedListTest.assertTrue((!this.list.containsAll(list2) ? 1 : 0) != 0);
        this.list.add((Object)"C");
        CursorableLinkedListTest.assertTrue((boolean)this.list.containsAll(list2));
        list2.add("C");
        CursorableLinkedListTest.assertTrue((boolean)this.list.containsAll(list2));
        CursorableLinkedListTest.assertTrue((boolean)this.list.containsAll(this.list));
    }

    public void testCursorNavigation() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor it = this.list.cursor();
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"2", (Object)it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"2", (Object)it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"2", (Object)it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"4", (Object)it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"5", (Object)it.next());
        CursorableLinkedListTest.assertTrue((!it.hasNext() ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"5", (Object)it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"4", (Object)it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"2", (Object)it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        it.close();
    }

    public void testCursorSet() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor it = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)it.next());
        it.set((Object)"a");
        CursorableLinkedListTest.assertEquals((Object)"a", (Object)it.previous());
        it.set((Object)"A");
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)it.next());
        CursorableLinkedListTest.assertEquals((Object)"2", (Object)it.next());
        it.set((Object)"B");
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)it.next());
        CursorableLinkedListTest.assertEquals((Object)"4", (Object)it.next());
        it.set((Object)"D");
        CursorableLinkedListTest.assertEquals((Object)"5", (Object)it.next());
        it.set((Object)"E");
        CursorableLinkedListTest.assertEquals((String)"[A, B, 3, D, E]", (String)this.list.toString());
        it.close();
    }

    public void testCursorRemove() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor it = this.list.cursor();
        try {
            it.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)it.next());
        CursorableLinkedListTest.assertEquals((Object)"2", (Object)it.next());
        CursorableLinkedListTest.assertEquals((String)"[1, 2, 3, 4, 5]", (String)this.list.toString());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[1, 3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)it.next());
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)it.previous());
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)it.previous());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)it.next());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[4, 5]", (String)this.list.toString());
        try {
            it.remove();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CursorableLinkedListTest.assertEquals((Object)"4", (Object)it.next());
        CursorableLinkedListTest.assertEquals((Object)"5", (Object)it.next());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[4]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"4", (Object)it.previous());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[]", (String)this.list.toString());
        it.close();
    }

    public void testCursorAdd() {
        CursorableLinkedList.Cursor it = this.list.cursor();
        it.add((Object)"1");
        CursorableLinkedListTest.assertEquals((String)"[1]", (String)this.list.toString());
        it.add((Object)"3");
        CursorableLinkedListTest.assertEquals((String)"[1, 3]", (String)this.list.toString());
        it.add((Object)"5");
        CursorableLinkedListTest.assertEquals((String)"[1, 3, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"5", (Object)it.previous());
        it.add((Object)"4");
        CursorableLinkedListTest.assertEquals((String)"[1, 3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"4", (Object)it.previous());
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)it.previous());
        it.add((Object)"2");
        CursorableLinkedListTest.assertEquals((String)"[1, 2, 3, 4, 5]", (String)this.list.toString());
        it.close();
    }

    public void testCursorConcurrentModification() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        this.list.add((Object)"7");
        this.list.add((Object)"9");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedList.Cursor c2 = this.list.cursor();
        Iterator li = this.list.iterator();
        CursorableLinkedListTest.assertEquals((Object)"1", li.next());
        CursorableLinkedListTest.assertEquals((Object)"2", li.next());
        li.remove();
        CursorableLinkedListTest.assertEquals((Object)"3", li.next());
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)c2.next());
        c1.remove();
        CursorableLinkedListTest.assertEquals((Object)"5", (Object)c2.next());
        c2.add((Object)"6");
        CursorableLinkedListTest.assertEquals((Object)"5", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"6", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"7", (Object)c1.next());
        this.list.add(0, (Object)"0");
        this.list.add(5, (Object)"8");
        CursorableLinkedListTest.assertEquals((Object)"8", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"9", (Object)c1.next());
        c1.add((Object)"10");
        CursorableLinkedListTest.assertEquals((Object)"7", (Object)c2.next());
        CursorableLinkedListTest.assertEquals((Object)"8", (Object)c2.next());
        CursorableLinkedListTest.assertEquals((Object)"9", (Object)c2.next());
        CursorableLinkedListTest.assertEquals((Object)"10", (Object)c2.next());
        try {
            c2.next();
            CursorableLinkedListTest.fail();
        }
        catch (NoSuchElementException nse) {
            // empty catch block
        }
        try {
            li.next();
            CursorableLinkedListTest.fail();
        }
        catch (ConcurrentModificationException cme) {
            // empty catch block
        }
        c1.close();
        c2.close();
    }

    public void testCursorNextIndexMid() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Iterator li = this.list.iterator();
        CursorableLinkedListTest.assertEquals((Object)"1", li.next());
        CursorableLinkedListTest.assertEquals((Object)"2", li.next());
        li.remove();
        CursorableLinkedListTest.assertEquals((int)0, (int)c1.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)c1.next());
    }

    public void testCursorNextIndexFirst() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((int)0, (int)c1.nextIndex());
        this.list.remove(0);
        CursorableLinkedListTest.assertEquals((int)0, (int)c1.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"2", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)c1.next());
    }

    public void testCursorNextIndexAddBefore() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((int)0, (int)c1.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)c1.next());
        this.list.add(0, (Object)"0");
        CursorableLinkedListTest.assertEquals((int)2, (int)c1.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"2", (Object)c1.next());
    }

    public void testCursorNextIndexAddNext() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((int)0, (int)c1.nextIndex());
        this.list.add(0, (Object)"0");
        CursorableLinkedListTest.assertEquals((int)0, (int)c1.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"0", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)c1.next());
    }

    public void testCursorNextIndexAddAfter() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((int)0, (int)c1.nextIndex());
        this.list.add(1, (Object)"0");
        CursorableLinkedListTest.assertEquals((int)0, (int)c1.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"0", (Object)c1.next());
    }

    public void testInternalState_CursorNextNextPreviousRemoveIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.previous());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)this.list.remove(1));
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.currentRemovedByAnother);
        CursorableLinkedListTest.assertEquals(null, (Object)c1.current);
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, C]", (String)this.list.toString());
        c1.remove();
        CursorableLinkedListTest.assertEquals((String)"[A, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextRemoveIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)this.list.remove(1));
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals((boolean)false, (boolean)c1.currentRemovedByAnother);
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.current.value);
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, C]", (String)this.list.toString());
        c1.remove();
        CursorableLinkedListTest.assertEquals((String)"[C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextRemoveIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)this.list.remove(1));
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.currentRemovedByAnother);
        CursorableLinkedListTest.assertEquals(null, (Object)c1.current);
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, C]", (String)this.list.toString());
        c1.remove();
        CursorableLinkedListTest.assertEquals((String)"[A, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextNextRemoveIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)this.list.remove(1));
        CursorableLinkedListTest.assertEquals((boolean)false, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((boolean)false, (boolean)c1.currentRemovedByAnother);
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.current.value);
        CursorableLinkedListTest.assertEquals((Object)"D", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, C, D]", (String)this.list.toString());
        c1.remove();
        CursorableLinkedListTest.assertEquals((String)"[A, D]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextPreviousRemoveByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.previous());
        c1.remove();
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals((boolean)false, (boolean)c1.currentRemovedByAnother);
        CursorableLinkedListTest.assertEquals(null, (Object)c1.current);
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextRemoveByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        c1.remove();
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals((boolean)false, (boolean)c1.currentRemovedByAnother);
        CursorableLinkedListTest.assertEquals(null, (Object)c1.current);
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextPreviousAddIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.previous());
        this.list.add(1, (Object)"Z");
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.current.value);
        CursorableLinkedListTest.assertEquals((Object)"Z", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, Z, B, C]", (String)this.list.toString());
        c1.remove();
        CursorableLinkedListTest.assertEquals((String)"[A, Z, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextAddIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        this.list.add(1, (Object)"Z");
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.current.value);
        CursorableLinkedListTest.assertEquals((Object)"Z", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, Z, B, C]", (String)this.list.toString());
        c1.remove();
        CursorableLinkedListTest.assertEquals((String)"[Z, B, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextAddIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        this.list.add(1, (Object)"Z");
        CursorableLinkedListTest.assertEquals((boolean)false, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.current.value);
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, Z, B, C]", (String)this.list.toString());
        c1.remove();
        CursorableLinkedListTest.assertEquals((String)"[A, Z, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextPreviousAddByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.previous());
        c1.add((Object)"Z");
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)2, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals(null, (Object)c1.current);
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, Z, B, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextAddByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        c1.add((Object)"Z");
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)3, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals((boolean)false, (boolean)c1.currentRemovedByAnother);
        CursorableLinkedListTest.assertEquals(null, (Object)c1.current);
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, B, Z, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextRemoveByListSetByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        this.list.remove(1);
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals(null, (Object)c1.current);
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, C]", (String)this.list.toString());
        try {
            c1.set((Object)"Z");
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextPreviousSetByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.previous());
        c1.set((Object)"Z");
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)1, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals((Object)"Z", (Object)c1.current.value);
        CursorableLinkedListTest.assertEquals((Object)"Z", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, Z, C]", (String)this.list.toString());
        c1.remove();
        CursorableLinkedListTest.assertEquals((String)"[A, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInternalState_CursorNextNextSetByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)c1.next());
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)c1.next());
        c1.set((Object)"Z");
        CursorableLinkedListTest.assertEquals((boolean)true, (boolean)c1.nextIndexValid);
        CursorableLinkedListTest.assertEquals((int)2, (int)c1.nextIndex);
        CursorableLinkedListTest.assertEquals((Object)"Z", (Object)c1.current.value);
        CursorableLinkedListTest.assertEquals((Object)"C", (Object)c1.next.value);
        CursorableLinkedListTest.assertEquals((String)"[A, Z, C]", (String)this.list.toString());
        c1.remove();
        CursorableLinkedListTest.assertEquals((String)"[A, C]", (String)this.list.toString());
        try {
            c1.remove();
            CursorableLinkedListTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testEqualsAndHashCode() {
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals(this.list));
        CursorableLinkedListTest.assertEquals((int)this.list.hashCode(), (int)this.list.hashCode());
        this.list.add((Object)"A");
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals(this.list));
        CursorableLinkedListTest.assertEquals((int)this.list.hashCode(), (int)this.list.hashCode());
        CursorableLinkedList list2 = new CursorableLinkedList();
        CursorableLinkedListTest.assertTrue((!this.list.equals((Object)list2) ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((!list2.equals(this.list) ? 1 : 0) != 0);
        LinkedList<String> list3 = new LinkedList<String>();
        CursorableLinkedListTest.assertTrue((!this.list.equals(list3) ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((!list3.equals(this.list) ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((boolean)list2.equals(list3));
        CursorableLinkedListTest.assertTrue((boolean)list3.equals(list2));
        CursorableLinkedListTest.assertEquals((int)list2.hashCode(), (int)list3.hashCode());
        list2.add((Object)"A");
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals((Object)list2));
        CursorableLinkedListTest.assertTrue((boolean)list2.equals(this.list));
        CursorableLinkedListTest.assertTrue((!list2.equals(list3) ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((!list3.equals(list2) ? 1 : 0) != 0);
        list3.add("A");
        CursorableLinkedListTest.assertTrue((boolean)list2.equals(list3));
        CursorableLinkedListTest.assertTrue((boolean)list3.equals(list2));
        CursorableLinkedListTest.assertEquals((int)list2.hashCode(), (int)list3.hashCode());
        this.list.add((Object)"B");
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals(this.list));
        CursorableLinkedListTest.assertTrue((!this.list.equals((Object)list2) ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((!list2.equals(this.list) ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((!this.list.equals(list3) ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((!list3.equals(this.list) ? 1 : 0) != 0);
        list2.add((Object)"B");
        list3.add("B");
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals(this.list));
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals((Object)list2));
        CursorableLinkedListTest.assertTrue((boolean)list2.equals(this.list));
        CursorableLinkedListTest.assertTrue((boolean)list2.equals(list3));
        CursorableLinkedListTest.assertTrue((boolean)list3.equals(list2));
        CursorableLinkedListTest.assertEquals((int)list2.hashCode(), (int)list3.hashCode());
        this.list.add((Object)"C");
        list2.add((Object)"C");
        list3.add("C");
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals(this.list));
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals((Object)list2));
        CursorableLinkedListTest.assertTrue((boolean)list2.equals(this.list));
        CursorableLinkedListTest.assertTrue((boolean)list2.equals(list3));
        CursorableLinkedListTest.assertTrue((boolean)list3.equals(list2));
        CursorableLinkedListTest.assertEquals((int)this.list.hashCode(), (int)list2.hashCode());
        CursorableLinkedListTest.assertEquals((int)list2.hashCode(), (int)list3.hashCode());
        this.list.add((Object)"D");
        list2.addFirst((Object)"D");
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals(this.list));
        CursorableLinkedListTest.assertTrue((!this.list.equals((Object)list2) ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((!list2.equals(this.list) ? 1 : 0) != 0);
    }

    public void testGet() {
        try {
            this.list.get(0);
            CursorableLinkedListTest.fail((String)"shouldn't get here");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        CursorableLinkedListTest.assertTrue((boolean)this.list.add((Object)"A"));
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)this.list.get(0));
        CursorableLinkedListTest.assertTrue((boolean)this.list.add((Object)"B"));
        CursorableLinkedListTest.assertEquals((Object)"A", (Object)this.list.get(0));
        CursorableLinkedListTest.assertEquals((Object)"B", (Object)this.list.get(1));
        try {
            this.list.get(-1);
            CursorableLinkedListTest.fail((String)"shouldn't get here");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.list.get(2);
            CursorableLinkedListTest.fail((String)"shouldn't get here");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testIndexOf() {
        CursorableLinkedListTest.assertEquals((int)-1, (int)this.list.indexOf((Object)"A"));
        CursorableLinkedListTest.assertEquals((int)-1, (int)this.list.lastIndexOf((Object)"A"));
        this.list.add((Object)"A");
        CursorableLinkedListTest.assertEquals((int)0, (int)this.list.indexOf((Object)"A"));
        CursorableLinkedListTest.assertEquals((int)0, (int)this.list.lastIndexOf((Object)"A"));
        CursorableLinkedListTest.assertEquals((int)-1, (int)this.list.indexOf((Object)"B"));
        CursorableLinkedListTest.assertEquals((int)-1, (int)this.list.lastIndexOf((Object)"B"));
        this.list.add((Object)"B");
        CursorableLinkedListTest.assertEquals((int)0, (int)this.list.indexOf((Object)"A"));
        CursorableLinkedListTest.assertEquals((int)0, (int)this.list.lastIndexOf((Object)"A"));
        CursorableLinkedListTest.assertEquals((int)1, (int)this.list.indexOf((Object)"B"));
        CursorableLinkedListTest.assertEquals((int)1, (int)this.list.lastIndexOf((Object)"B"));
        this.list.addFirst((Object)"B");
        CursorableLinkedListTest.assertEquals((int)1, (int)this.list.indexOf((Object)"A"));
        CursorableLinkedListTest.assertEquals((int)1, (int)this.list.lastIndexOf((Object)"A"));
        CursorableLinkedListTest.assertEquals((int)0, (int)this.list.indexOf((Object)"B"));
        CursorableLinkedListTest.assertEquals((int)2, (int)this.list.lastIndexOf((Object)"B"));
    }

    public void testIsEmpty() {
        CursorableLinkedListTest.assertTrue((boolean)this.list.isEmpty());
        this.list.add((Object)"element");
        CursorableLinkedListTest.assertTrue((!this.list.isEmpty() ? 1 : 0) != 0);
        this.list.remove((Object)"element");
        CursorableLinkedListTest.assertTrue((boolean)this.list.isEmpty());
        this.list.add((Object)"element");
        CursorableLinkedListTest.assertTrue((!this.list.isEmpty() ? 1 : 0) != 0);
        this.list.clear();
        CursorableLinkedListTest.assertTrue((boolean)this.list.isEmpty());
    }

    public void testIterator() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        Iterator it = this.list.iterator();
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertEquals((Object)"1", it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertEquals((Object)"2", it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertEquals((Object)"3", it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertEquals((Object)"4", it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertEquals((Object)"5", it.next());
        CursorableLinkedListTest.assertTrue((!it.hasNext() ? 1 : 0) != 0);
        it = this.list.iterator();
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertEquals((Object)"1", it.next());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[2, 3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertEquals((Object)"2", it.next());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertEquals((Object)"3", it.next());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertEquals((Object)"4", it.next());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[5]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertEquals((Object)"5", it.next());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((!it.hasNext() ? 1 : 0) != 0);
    }

    public void testListIteratorNavigation() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        ListIterator it = this.list.listIterator();
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        CursorableLinkedListTest.assertEquals((int)-1, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)0, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"1", it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)0, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)1, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"1", it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        CursorableLinkedListTest.assertEquals((int)-1, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)0, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"1", it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)0, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)1, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"2", it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)1, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)2, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"2", it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)0, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)1, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"2", it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)1, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)2, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"3", it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)2, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)3, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"4", it.next());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)3, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)4, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"5", it.next());
        CursorableLinkedListTest.assertTrue((!it.hasNext() ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)4, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)5, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"5", it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)3, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)4, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"4", it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)2, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)3, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"3", it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)1, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)2, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"2", it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((boolean)it.hasPrevious());
        CursorableLinkedListTest.assertEquals((int)0, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)1, (int)it.nextIndex());
        CursorableLinkedListTest.assertEquals((Object)"1", it.previous());
        CursorableLinkedListTest.assertTrue((boolean)it.hasNext());
        CursorableLinkedListTest.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        CursorableLinkedListTest.assertEquals((int)-1, (int)it.previousIndex());
        CursorableLinkedListTest.assertEquals((int)0, (int)it.nextIndex());
    }

    @Override
    public void testListIteratorSet() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        ListIterator it = this.list.listIterator();
        CursorableLinkedListTest.assertEquals((Object)"1", it.next());
        it.set("a");
        CursorableLinkedListTest.assertEquals((Object)"a", it.previous());
        it.set("A");
        CursorableLinkedListTest.assertEquals((Object)"A", it.next());
        CursorableLinkedListTest.assertEquals((Object)"2", it.next());
        it.set("B");
        CursorableLinkedListTest.assertEquals((Object)"3", it.next());
        CursorableLinkedListTest.assertEquals((Object)"4", it.next());
        it.set("D");
        CursorableLinkedListTest.assertEquals((Object)"5", it.next());
        it.set("E");
        CursorableLinkedListTest.assertEquals((String)"[A, B, 3, D, E]", (String)this.list.toString());
    }

    public void testListIteratorRemove() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        ListIterator it = this.list.listIterator();
        try {
            it.remove();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        CursorableLinkedListTest.assertEquals((Object)"1", it.next());
        CursorableLinkedListTest.assertEquals((Object)"2", it.next());
        CursorableLinkedListTest.assertEquals((String)"[1, 2, 3, 4, 5]", (String)this.list.toString());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[1, 3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"3", it.next());
        CursorableLinkedListTest.assertEquals((Object)"3", it.previous());
        CursorableLinkedListTest.assertEquals((Object)"1", it.previous());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((!it.hasPrevious() ? 1 : 0) != 0);
        CursorableLinkedListTest.assertEquals((Object)"3", it.next());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[4, 5]", (String)this.list.toString());
        try {
            it.remove();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CursorableLinkedListTest.assertEquals((Object)"4", it.next());
        CursorableLinkedListTest.assertEquals((Object)"5", it.next());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[4]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"4", it.previous());
        it.remove();
        CursorableLinkedListTest.assertEquals((String)"[]", (String)this.list.toString());
    }

    @Override
    public void testListIteratorAdd() {
        ListIterator it = this.list.listIterator();
        it.add("1");
        CursorableLinkedListTest.assertEquals((String)"[1]", (String)this.list.toString());
        it.add("3");
        CursorableLinkedListTest.assertEquals((String)"[1, 3]", (String)this.list.toString());
        it.add("5");
        CursorableLinkedListTest.assertEquals((String)"[1, 3, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"5", it.previous());
        it.add("4");
        CursorableLinkedListTest.assertEquals((String)"[1, 3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"4", it.previous());
        CursorableLinkedListTest.assertEquals((Object)"3", it.previous());
        it.add("2");
        CursorableLinkedListTest.assertEquals((String)"[1, 2, 3, 4, 5]", (String)this.list.toString());
    }

    public void testRemoveAll() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        HashSet<String> set = new HashSet<String>();
        set.add("A");
        set.add("2");
        set.add("C");
        set.add("4");
        set.add("D");
        CursorableLinkedListTest.assertTrue((boolean)this.list.removeAll(set));
        CursorableLinkedListTest.assertEquals((String)"[1, 3, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((!this.list.removeAll(set) ? 1 : 0) != 0);
    }

    public void testRemoveByIndex() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        CursorableLinkedListTest.assertEquals((String)"[1, 2, 3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)this.list.remove(0));
        CursorableLinkedListTest.assertEquals((String)"[2, 3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)this.list.remove(1));
        CursorableLinkedListTest.assertEquals((String)"[2, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"4", (Object)this.list.remove(1));
        CursorableLinkedListTest.assertEquals((String)"[2, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"5", (Object)this.list.remove(1));
        CursorableLinkedListTest.assertEquals((String)"[2]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((Object)"2", (Object)this.list.remove(0));
        CursorableLinkedListTest.assertEquals((String)"[]", (String)this.list.toString());
    }

    public void testRemove() {
        this.list.add((Object)"1");
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        CursorableLinkedListTest.assertEquals((String)"[1, 1, 2, 3, 4, 5, 2, 3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((!this.list.remove((Object)"6") ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"5"));
        CursorableLinkedListTest.assertEquals((String)"[1, 1, 2, 3, 4, 2, 3, 4, 5]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"5"));
        CursorableLinkedListTest.assertEquals((String)"[1, 1, 2, 3, 4, 2, 3, 4]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((!this.list.remove((Object)"5") ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"1"));
        CursorableLinkedListTest.assertEquals((String)"[1, 2, 3, 4, 2, 3, 4]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"1"));
        CursorableLinkedListTest.assertEquals((String)"[2, 3, 4, 2, 3, 4]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"2"));
        CursorableLinkedListTest.assertEquals((String)"[3, 4, 2, 3, 4]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"2"));
        CursorableLinkedListTest.assertEquals((String)"[3, 4, 3, 4]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"3"));
        CursorableLinkedListTest.assertEquals((String)"[4, 3, 4]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"3"));
        CursorableLinkedListTest.assertEquals((String)"[4, 4]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"4"));
        CursorableLinkedListTest.assertEquals((String)"[4]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((boolean)this.list.remove((Object)"4"));
        CursorableLinkedListTest.assertEquals((String)"[]", (String)this.list.toString());
    }

    public void testRetainAll() {
        this.list.add((Object)"1");
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        this.list.add((Object)"5");
        HashSet<String> set = new HashSet<String>();
        set.add("A");
        set.add("2");
        set.add("C");
        set.add("4");
        set.add("D");
        CursorableLinkedListTest.assertTrue((boolean)this.list.retainAll(set));
        CursorableLinkedListTest.assertEquals((String)"[2, 2, 4, 4]", (String)this.list.toString());
        CursorableLinkedListTest.assertTrue((!this.list.retainAll(set) ? 1 : 0) != 0);
    }

    public void testSet() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        CursorableLinkedListTest.assertEquals((String)"[1, 2, 3, 4, 5]", (String)this.list.toString());
        this.list.set(0, (Object)"A");
        CursorableLinkedListTest.assertEquals((String)"[A, 2, 3, 4, 5]", (String)this.list.toString());
        this.list.set(1, (Object)"B");
        CursorableLinkedListTest.assertEquals((String)"[A, B, 3, 4, 5]", (String)this.list.toString());
        this.list.set(2, (Object)"C");
        CursorableLinkedListTest.assertEquals((String)"[A, B, C, 4, 5]", (String)this.list.toString());
        this.list.set(3, (Object)"D");
        CursorableLinkedListTest.assertEquals((String)"[A, B, C, D, 5]", (String)this.list.toString());
        this.list.set(4, (Object)"E");
        CursorableLinkedListTest.assertEquals((String)"[A, B, C, D, E]", (String)this.list.toString());
    }

    public void testSubList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        CursorableLinkedListTest.assertEquals((String)"[A, B, C, D, E]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((String)"[A, B, C, D, E]", (String)this.list.subList(0, 5).toString());
        CursorableLinkedListTest.assertEquals((String)"[B, C, D, E]", (String)this.list.subList(1, 5).toString());
        CursorableLinkedListTest.assertEquals((String)"[C, D, E]", (String)this.list.subList(2, 5).toString());
        CursorableLinkedListTest.assertEquals((String)"[D, E]", (String)this.list.subList(3, 5).toString());
        CursorableLinkedListTest.assertEquals((String)"[E]", (String)this.list.subList(4, 5).toString());
        CursorableLinkedListTest.assertEquals((String)"[]", (String)this.list.subList(5, 5).toString());
    }

    public void testSubListAddEnd() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        List sublist = this.list.subList(5, 5);
        sublist.add("F");
        CursorableLinkedListTest.assertEquals((String)"[A, B, C, D, E, F]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((String)"[F]", (String)sublist.toString());
        sublist.add("G");
        CursorableLinkedListTest.assertEquals((String)"[A, B, C, D, E, F, G]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((String)"[F, G]", (String)sublist.toString());
    }

    public void testSubListAddBegin() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        List sublist = this.list.subList(0, 0);
        sublist.add("a");
        CursorableLinkedListTest.assertEquals((String)"[a, A, B, C, D, E]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((String)"[a]", (String)sublist.toString());
        sublist.add("b");
        CursorableLinkedListTest.assertEquals((String)"[a, b, A, B, C, D, E]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((String)"[a, b]", (String)sublist.toString());
    }

    public void testSubListAddMiddle() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        List sublist = this.list.subList(1, 3);
        sublist.add("a");
        CursorableLinkedListTest.assertEquals((String)"[A, B, C, a, D, E]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((String)"[B, C, a]", (String)sublist.toString());
        sublist.add("b");
        CursorableLinkedListTest.assertEquals((String)"[A, B, C, a, b, D, E]", (String)this.list.toString());
        CursorableLinkedListTest.assertEquals((String)"[B, C, a, b]", (String)sublist.toString());
    }

    public void testSubListRemove() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        List sublist = this.list.subList(1, 4);
        CursorableLinkedListTest.assertEquals((String)"[B, C, D]", (String)sublist.toString());
        CursorableLinkedListTest.assertEquals((String)"[A, B, C, D, E]", (String)this.list.toString());
        sublist.remove("C");
        CursorableLinkedListTest.assertEquals((String)"[B, D]", (String)sublist.toString());
        CursorableLinkedListTest.assertEquals((String)"[A, B, D, E]", (String)this.list.toString());
        sublist.remove(1);
        CursorableLinkedListTest.assertEquals((String)"[B]", (String)sublist.toString());
        CursorableLinkedListTest.assertEquals((String)"[A, B, E]", (String)this.list.toString());
        sublist.clear();
        CursorableLinkedListTest.assertEquals((String)"[]", (String)sublist.toString());
        CursorableLinkedListTest.assertEquals((String)"[A, E]", (String)this.list.toString());
    }

    public void testToArray() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        Object[] elts = this.list.toArray();
        CursorableLinkedListTest.assertEquals((Object)"1", (Object)elts[0]);
        CursorableLinkedListTest.assertEquals((Object)"2", (Object)elts[1]);
        CursorableLinkedListTest.assertEquals((Object)"3", (Object)elts[2]);
        CursorableLinkedListTest.assertEquals((Object)"4", (Object)elts[3]);
        CursorableLinkedListTest.assertEquals((Object)"5", (Object)elts[4]);
        CursorableLinkedListTest.assertEquals((int)5, (int)elts.length);
        String[] elts2 = (String[])this.list.toArray((Object[])new String[0]);
        CursorableLinkedListTest.assertEquals((String)"1", (String)elts2[0]);
        CursorableLinkedListTest.assertEquals((String)"2", (String)elts2[1]);
        CursorableLinkedListTest.assertEquals((String)"3", (String)elts2[2]);
        CursorableLinkedListTest.assertEquals((String)"4", (String)elts2[3]);
        CursorableLinkedListTest.assertEquals((String)"5", (String)elts2[4]);
        CursorableLinkedListTest.assertEquals((int)5, (int)elts2.length);
        Object[] elts3 = new String[5];
        CursorableLinkedListTest.assertSame((Object)elts3, (Object)this.list.toArray(elts3));
        CursorableLinkedListTest.assertEquals((String)"1", (String)elts3[0]);
        CursorableLinkedListTest.assertEquals((String)"2", (String)elts3[1]);
        CursorableLinkedListTest.assertEquals((String)"3", (String)elts3[2]);
        CursorableLinkedListTest.assertEquals((String)"4", (String)elts3[3]);
        CursorableLinkedListTest.assertEquals((String)"5", (String)elts3[4]);
        CursorableLinkedListTest.assertEquals((int)5, (int)elts3.length);
        Object[] elts4 = new String[3];
        String[] elts4b = (String[])this.list.toArray(elts4);
        CursorableLinkedListTest.assertTrue((elts4 != elts4b ? 1 : 0) != 0);
        CursorableLinkedListTest.assertEquals((String)"1", (String)elts4b[0]);
        CursorableLinkedListTest.assertEquals((String)"2", (String)elts4b[1]);
        CursorableLinkedListTest.assertEquals((String)"3", (String)elts4b[2]);
        CursorableLinkedListTest.assertEquals((String)"4", (String)elts4b[3]);
        CursorableLinkedListTest.assertEquals((String)"5", (String)elts4b[4]);
        CursorableLinkedListTest.assertEquals((int)5, (int)elts4b.length);
    }

    public void testSerialization() throws Exception {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        out.writeObject(this.list);
        out.flush();
        out.close();
        ByteArrayInputStream bufin = new ByteArrayInputStream(buf.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bufin);
        Object list2 = in.readObject();
        CursorableLinkedListTest.assertTrue((this.list != list2 ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((boolean)list2.equals(this.list));
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals(list2));
    }

    public void testSerializationWithOpenCursor() throws Exception {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        out.writeObject(this.list);
        out.flush();
        out.close();
        ByteArrayInputStream bufin = new ByteArrayInputStream(buf.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bufin);
        Object list2 = in.readObject();
        CursorableLinkedListTest.assertTrue((this.list != list2 ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((boolean)list2.equals(this.list));
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals(list2));
    }

    public void testLongSerialization() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            this.list.add((Object)i);
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        out.writeObject(this.list);
        out.flush();
        out.close();
        ByteArrayInputStream bufin = new ByteArrayInputStream(buf.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bufin);
        Object list2 = in.readObject();
        CursorableLinkedListTest.assertTrue((this.list != list2 ? 1 : 0) != 0);
        CursorableLinkedListTest.assertTrue((boolean)list2.equals(this.list));
        CursorableLinkedListTest.assertTrue((boolean)this.list.equals(list2));
    }

    @Override
    public String[] ignoredTests() {
        String[] ignored;
        ArrayList<String> list = new ArrayList<String>();
        String prefix = "CursorableLinkedListTest";
        String bulk = ".bulkTestSubList";
        for (String element : ignored = new String[]{".testEmptyListSerialization", ".testFullListSerialization", ".testEmptyListCompatibility", ".testFullListCompatibility", ".testSimpleSerialization", ".testCanonicalEmptyCollectionExists", ".testCanonicalFullCollectionExists", ".testSerializeDeserializeThenCompare"}) {
            list.add("CursorableLinkedListTest.bulkTestSubList" + element);
            list.add("CursorableLinkedListTest.bulkTestSubList.bulkTestSubList" + element);
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

