/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.iterators.AbstractListIteratorTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListTest<E>
extends AbstractCollectionTest<E> {
    public AbstractListTest(String testName) {
        super(testName);
    }

    public boolean isSetSupported() {
        return true;
    }

    @Override
    public void verify() {
        super.verify();
        Collection list1 = this.getCollection();
        Collection list2 = this.getConfirmed();
        AbstractListTest.assertEquals((String)"List should equal confirmed", (Object)list1, (Object)list2);
        AbstractListTest.assertEquals((String)"Confirmed should equal list", (Object)list2, (Object)list1);
        AbstractListTest.assertEquals((String)"Hash codes should be equal", (int)list1.hashCode(), (int)list2.hashCode());
        int i = 0;
        Iterator iterator1 = list1.iterator();
        Iterator iterator2 = list2.iterator();
        Object[] array = list1.toArray();
        while (iterator2.hasNext()) {
            AbstractListTest.assertTrue((String)"List iterator should have next", (boolean)iterator1.hasNext());
            Object o1 = iterator1.next();
            Object o2 = iterator2.next();
            AbstractListTest.assertEquals((String)"Iterator elements should be equal", o1, o2);
            o2 = list1.get(i);
            AbstractListTest.assertEquals((String)"get should return correct element", o1, o2);
            o2 = array[i];
            AbstractListTest.assertEquals((String)"toArray should have correct element", o1, o2);
            ++i;
        }
    }

    @Override
    public boolean isEqualsCheckable() {
        return true;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    @Override
    public abstract List<E> makeObject();

    @Override
    public List<E> makeFullCollection() {
        Collection list = this.makeObject();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    @Override
    public List<E> getCollection() {
        return (List)super.getCollection();
    }

    @Override
    public List<E> getConfirmed() {
        return (List)super.getConfirmed();
    }

    public void testListAddByIndexBoundsChecking() {
        Collection list;
        if (!this.isAddSupported()) {
            return;
        }
        Object element = this.getOtherElements()[0];
        try {
            list = this.makeObject();
            list.add(Integer.MIN_VALUE, element);
            AbstractListTest.fail((String)"List.add should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeObject();
            list.add(-1, element);
            AbstractListTest.fail((String)"List.add should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeObject();
            list.add(1, element);
            AbstractListTest.fail((String)"List.add should throw IndexOutOfBoundsException [1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeObject();
            list.add(Integer.MAX_VALUE, element);
            AbstractListTest.fail((String)"List.add should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListAddByIndexBoundsChecking2() {
        Collection list;
        if (!this.isAddSupported()) {
            return;
        }
        Object element = this.getOtherElements()[0];
        try {
            list = this.makeFullCollection();
            list.add(Integer.MIN_VALUE, element);
            AbstractListTest.fail((String)"List.add should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeFullCollection();
            list.add(-1, element);
            AbstractListTest.fail((String)"List.add should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeFullCollection();
            list.add(list.size() + 1, element);
            AbstractListTest.fail((String)"List.add should throw IndexOutOfBoundsException [size + 1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeFullCollection();
            list.add(Integer.MAX_VALUE, element);
            AbstractListTest.fail((String)"List.add should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListAddByIndex() {
        if (!this.isAddSupported()) {
            return;
        }
        Object element = this.getOtherElements()[0];
        int max = this.getFullElements().length;
        for (int i = 0; i <= max; ++i) {
            this.resetFull();
            this.getCollection().add(i, element);
            this.getConfirmed().add(i, element);
            this.verify();
        }
    }

    public void testListEquals() {
        this.resetEmpty();
        Collection list = this.getCollection();
        AbstractListTest.assertEquals((String)"Empty lists should be equal", (boolean)true, (boolean)list.equals(this.getConfirmed()));
        this.verify();
        AbstractListTest.assertEquals((String)"Empty list should equal self", (boolean)true, (boolean)list.equals(list));
        this.verify();
        Collection list2 = Arrays.asList(this.getFullElements());
        AbstractListTest.assertEquals((String)"Empty list shouldn't equal full", (boolean)false, (boolean)list.equals(list2));
        this.verify();
        list2 = Arrays.asList(this.getOtherElements());
        AbstractListTest.assertEquals((String)"Empty list shouldn't equal other", (boolean)false, (boolean)list.equals(list2));
        this.verify();
        this.resetFull();
        list = this.getCollection();
        AbstractListTest.assertEquals((String)"Full lists should be equal", (boolean)true, (boolean)list.equals(this.getConfirmed()));
        this.verify();
        AbstractListTest.assertEquals((String)"Full list should equal self", (boolean)true, (boolean)list.equals(list));
        this.verify();
        list2 = this.makeObject();
        AbstractListTest.assertEquals((String)"Full list shouldn't equal empty", (boolean)false, (boolean)list.equals(list2));
        this.verify();
        list2 = Arrays.asList(this.getOtherElements());
        AbstractListTest.assertEquals((String)"Full list shouldn't equal other", (boolean)false, (boolean)list.equals(list2));
        this.verify();
        list2 = Arrays.asList(this.getFullElements());
        if (list2.size() < 2 && this.isAddSupported()) {
            list.addAll(Arrays.asList(this.getOtherElements()));
            this.getConfirmed().addAll(Arrays.asList(this.getOtherElements()));
            list2 = new ArrayList(list2);
            list2.addAll(Arrays.asList(this.getOtherElements()));
        }
        if (list2.size() > 1) {
            Collections.reverse(list2);
            AbstractListTest.assertEquals((String)"Full list shouldn't equal full list with same elements but different order", (boolean)false, (boolean)list.equals(list2));
            this.verify();
        }
        this.resetFull();
        list = this.getCollection();
        AbstractListTest.assertEquals((String)"List shouldn't equal String", (boolean)false, (boolean)list.equals(""));
        this.verify();
        final List listForC = Arrays.asList(this.getFullElements());
        AbstractCollection c = new AbstractCollection<E>(){

            @Override
            public int size() {
                return listForC.size();
            }

            @Override
            public Iterator<E> iterator() {
                return listForC.iterator();
            }
        };
        AbstractListTest.assertEquals((String)"List shouldn't equal nonlist with same elements in same order", (boolean)false, (boolean)list.equals(c));
        this.verify();
    }

    public void testListHashCode() {
        this.resetEmpty();
        int hash1 = this.getCollection().hashCode();
        int hash2 = this.getConfirmed().hashCode();
        AbstractListTest.assertEquals((String)"Empty lists should have equal hashCodes", (int)hash1, (int)hash2);
        this.verify();
        this.resetFull();
        hash1 = this.getCollection().hashCode();
        hash2 = this.getConfirmed().hashCode();
        AbstractListTest.assertEquals((String)"Full lists should have equal hashCodes", (int)hash1, (int)hash2);
        this.verify();
    }

    public void testListGetByIndex() {
        this.resetFull();
        Collection list = this.getCollection();
        E[] elements = this.getFullElements();
        for (int i = 0; i < elements.length; ++i) {
            AbstractListTest.assertEquals((String)"List should contain correct elements", elements[i], list.get(i));
            this.verify();
        }
    }

    public void testListGetByIndexBoundsChecking() {
        Collection list = this.makeObject();
        try {
            list.get(Integer.MIN_VALUE);
            AbstractListTest.fail((String)"List.get should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(-1);
            AbstractListTest.fail((String)"List.get should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(0);
            AbstractListTest.fail((String)"List.get should throw IndexOutOfBoundsException [0]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(1);
            AbstractListTest.fail((String)"List.get should throw IndexOutOfBoundsException [1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(Integer.MAX_VALUE);
            AbstractListTest.fail((String)"List.get should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListGetByIndexBoundsChecking2() {
        Collection list = this.makeFullCollection();
        try {
            list.get(Integer.MIN_VALUE);
            AbstractListTest.fail((String)"List.get should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(-1);
            AbstractListTest.fail((String)"List.get should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(this.getFullElements().length);
            AbstractListTest.fail((String)"List.get should throw IndexOutOfBoundsException [size]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(Integer.MAX_VALUE);
            AbstractListTest.fail((String)"List.get should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListIndexOf() {
        E[] other;
        this.resetFull();
        Collection list1 = this.getCollection();
        Collection list2 = this.getConfirmed();
        for (Object element : list2) {
            AbstractListTest.assertEquals((String)"indexOf should return correct result", (int)list1.indexOf(element), (int)list2.indexOf(element));
            this.verify();
        }
        for (Object element : other = this.getOtherElements()) {
            AbstractListTest.assertEquals((String)"indexOf should return -1 for nonexistent element", (int)-1, (int)list1.indexOf(element));
            this.verify();
        }
    }

    public void testListLastIndexOf() {
        E[] other;
        this.resetFull();
        Collection list1 = this.getCollection();
        Collection list2 = this.getConfirmed();
        for (Object element : list2) {
            AbstractListTest.assertEquals((String)"lastIndexOf should return correct result", (int)list1.lastIndexOf(element), (int)list2.lastIndexOf(element));
            this.verify();
        }
        for (Object element : other = this.getOtherElements()) {
            AbstractListTest.assertEquals((String)"lastIndexOf should return -1 for nonexistent element", (int)-1, (int)list1.lastIndexOf(element));
            this.verify();
        }
    }

    public void testListSetByIndexBoundsChecking() {
        if (!this.isSetSupported()) {
            return;
        }
        Collection list = this.makeObject();
        Object element = this.getOtherElements()[0];
        try {
            list.set(Integer.MIN_VALUE, element);
            AbstractListTest.fail((String)"List.set should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(-1, element);
            AbstractListTest.fail((String)"List.set should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(0, element);
            AbstractListTest.fail((String)"List.set should throw IndexOutOfBoundsException [0]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(1, element);
            AbstractListTest.fail((String)"List.set should throw IndexOutOfBoundsException [1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(Integer.MAX_VALUE, element);
            AbstractListTest.fail((String)"List.set should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListSetByIndexBoundsChecking2() {
        if (!this.isSetSupported()) {
            return;
        }
        Collection list = this.makeFullCollection();
        Object element = this.getOtherElements()[0];
        try {
            list.set(Integer.MIN_VALUE, element);
            AbstractListTest.fail((String)"List.set should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(-1, element);
            AbstractListTest.fail((String)"List.set should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(this.getFullElements().length, element);
            AbstractListTest.fail((String)"List.set should throw IndexOutOfBoundsException [size]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(Integer.MAX_VALUE, element);
            AbstractListTest.fail((String)"List.set should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListSetByIndex() {
        if (!this.isSetSupported()) {
            return;
        }
        this.resetFull();
        E[] elements = this.getFullElements();
        E[] other = this.getOtherElements();
        for (int i = 0; i < elements.length; ++i) {
            Object n = other[i % other.length];
            Object v = this.getCollection().set(i, n);
            AbstractListTest.assertEquals((String)"Set should return correct element", elements[i], v);
            this.getConfirmed().set(i, n);
            this.verify();
        }
    }

    public void testUnsupportedSet() {
        if (this.isSetSupported()) {
            return;
        }
        this.resetFull();
        try {
            this.getCollection().set(0, this.getFullElements()[0]);
            AbstractListTest.fail((String)"Emtpy collection should not support set.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verify();
    }

    public void testListRemoveByIndexBoundsChecking() {
        if (!this.isRemoveSupported()) {
            return;
        }
        Collection list = this.makeObject();
        try {
            list.remove(Integer.MIN_VALUE);
            AbstractListTest.fail((String)"List.remove should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(-1);
            AbstractListTest.fail((String)"List.remove should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(0);
            AbstractListTest.fail((String)"List.remove should throw IndexOutOfBoundsException [0]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(1);
            AbstractListTest.fail((String)"List.remove should throw IndexOutOfBoundsException [1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(Integer.MAX_VALUE);
            AbstractListTest.fail((String)"List.remove should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListRemoveByIndexBoundsChecking2() {
        if (!this.isRemoveSupported()) {
            return;
        }
        Collection list = this.makeFullCollection();
        try {
            list.remove(Integer.MIN_VALUE);
            AbstractListTest.fail((String)"List.remove should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(-1);
            AbstractListTest.fail((String)"List.remove should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(this.getFullElements().length);
            AbstractListTest.fail((String)"List.remove should throw IndexOutOfBoundsException [size]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(Integer.MAX_VALUE);
            AbstractListTest.fail((String)"List.remove should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListRemoveByIndex() {
        if (!this.isRemoveSupported()) {
            return;
        }
        int max = this.getFullElements().length;
        for (int i = 0; i < max; ++i) {
            this.resetFull();
            Object o1 = this.getCollection().remove(i);
            Object o2 = this.getConfirmed().remove(i);
            AbstractListTest.assertEquals((String)"remove should return correct element", o1, o2);
            this.verify();
        }
    }

    public void testListListIterator() {
        this.resetFull();
        this.forwardTest(this.getCollection().listIterator(), 0);
        this.backwardTest(this.getCollection().listIterator(), 0);
    }

    public void testListListIteratorByIndex() {
        int i;
        this.resetFull();
        try {
            this.getCollection().listIterator(-1);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.resetFull();
        try {
            this.getCollection().listIterator(this.getCollection().size() + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.resetFull();
        for (i = 0; i <= this.getConfirmed().size(); ++i) {
            this.forwardTest(this.getCollection().listIterator(i), i);
            this.backwardTest(this.getCollection().listIterator(i), i);
        }
        this.resetFull();
        for (i = 0; i <= this.getConfirmed().size(); ++i) {
            this.backwardTest(this.getCollection().listIterator(i), i);
        }
    }

    public void testListListIteratorPreviousRemoveNext() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        if (this.getCollection().size() < 4) {
            return;
        }
        ListIterator it = this.getCollection().listIterator();
        Object zero = it.next();
        Object one = it.next();
        Object two = it.next();
        Object two2 = it.previous();
        Object one2 = it.previous();
        AbstractListTest.assertEquals(one, one2);
        AbstractListTest.assertEquals(two, two2);
        AbstractListTest.assertEquals(zero, this.getCollection().get(0));
        AbstractListTest.assertEquals(one, this.getCollection().get(1));
        AbstractListTest.assertEquals(two, this.getCollection().get(2));
        it.remove();
        AbstractListTest.assertEquals(zero, this.getCollection().get(0));
        AbstractListTest.assertEquals(two, this.getCollection().get(1));
        Object two3 = it.next();
        AbstractListTest.assertEquals(two, two3);
        AbstractListTest.assertEquals((this.getCollection().size() > 2 ? 1 : 0) != 0, (boolean)it.hasNext());
        AbstractListTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
    }

    public void testListListIteratorPreviousRemovePrevious() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        if (this.getCollection().size() < 4) {
            return;
        }
        ListIterator it = this.getCollection().listIterator();
        Object zero = it.next();
        Object one = it.next();
        Object two = it.next();
        Object two2 = it.previous();
        Object one2 = it.previous();
        AbstractListTest.assertEquals(one, one2);
        AbstractListTest.assertEquals(two, two2);
        AbstractListTest.assertEquals(zero, this.getCollection().get(0));
        AbstractListTest.assertEquals(one, this.getCollection().get(1));
        AbstractListTest.assertEquals(two, this.getCollection().get(2));
        it.remove();
        AbstractListTest.assertEquals(zero, this.getCollection().get(0));
        AbstractListTest.assertEquals(two, this.getCollection().get(1));
        Object zero3 = it.previous();
        AbstractListTest.assertEquals(zero, zero3);
        AbstractListTest.assertEquals((boolean)false, (boolean)it.hasPrevious());
        AbstractListTest.assertEquals((this.getCollection().size() > 2 ? 1 : 0) != 0, (boolean)it.hasNext());
    }

    public void testListListIteratorNextRemoveNext() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        if (this.getCollection().size() < 4) {
            return;
        }
        ListIterator it = this.getCollection().listIterator();
        Object zero = it.next();
        Object one = it.next();
        Object two = it.next();
        AbstractListTest.assertEquals(zero, this.getCollection().get(0));
        AbstractListTest.assertEquals(one, this.getCollection().get(1));
        AbstractListTest.assertEquals(two, this.getCollection().get(2));
        Object three = this.getCollection().get(3);
        it.remove();
        AbstractListTest.assertEquals(zero, this.getCollection().get(0));
        AbstractListTest.assertEquals(one, this.getCollection().get(1));
        Object three2 = it.next();
        AbstractListTest.assertEquals(three, three2);
        AbstractListTest.assertEquals((this.getCollection().size() > 3 ? 1 : 0) != 0, (boolean)it.hasNext());
        AbstractListTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
    }

    public void testListListIteratorNextRemovePrevious() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        if (this.getCollection().size() < 4) {
            return;
        }
        ListIterator it = this.getCollection().listIterator();
        Object zero = it.next();
        Object one = it.next();
        Object two = it.next();
        AbstractListTest.assertEquals(zero, this.getCollection().get(0));
        AbstractListTest.assertEquals(one, this.getCollection().get(1));
        AbstractListTest.assertEquals(two, this.getCollection().get(2));
        it.remove();
        AbstractListTest.assertEquals(zero, this.getCollection().get(0));
        AbstractListTest.assertEquals(one, this.getCollection().get(1));
        Object one2 = it.previous();
        AbstractListTest.assertEquals(one, one2);
        AbstractListTest.assertEquals((boolean)true, (boolean)it.hasNext());
        AbstractListTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
    }

    private void forwardTest(ListIterator<E> iter, int i) {
        Collection list = this.getCollection();
        int max = this.getFullElements().length;
        while (i < max) {
            AbstractListTest.assertTrue((String)"Iterator should have next", (boolean)iter.hasNext());
            AbstractListTest.assertEquals((String)"Iterator.nextIndex should work", (int)i, (int)iter.nextIndex());
            AbstractListTest.assertEquals((String)"Iterator.previousIndex should work", (int)(i - 1), (int)iter.previousIndex());
            E o = iter.next();
            AbstractListTest.assertEquals((String)"Iterator returned correct element", list.get(i), o);
            ++i;
        }
        AbstractListTest.assertTrue((String)"Iterator shouldn't have next", (!iter.hasNext() ? 1 : 0) != 0);
        AbstractListTest.assertEquals((String)"nextIndex should be size", (int)max, (int)iter.nextIndex());
        AbstractListTest.assertEquals((String)"previousIndex should be size - 1", (int)(max - 1), (int)iter.previousIndex());
        try {
            iter.next();
            AbstractListTest.fail((String)"Exhausted iterator should raise NoSuchElement");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    private void backwardTest(ListIterator<E> iter, int i) {
        Collection list = this.getCollection();
        while (i > 0) {
            AbstractListTest.assertTrue((String)("Iterator should have previous, i:" + i), (boolean)iter.hasPrevious());
            AbstractListTest.assertEquals((String)("Iterator.nextIndex should work, i:" + i), (int)i, (int)iter.nextIndex());
            AbstractListTest.assertEquals((String)("Iterator.previousIndex should work, i:" + i), (int)(i - 1), (int)iter.previousIndex());
            E o = iter.previous();
            AbstractListTest.assertEquals((String)"Iterator returned correct element", list.get(i - 1), o);
            --i;
        }
        AbstractListTest.assertTrue((String)"Iterator shouldn't have previous", (!iter.hasPrevious() ? 1 : 0) != 0);
        int nextIndex = iter.nextIndex();
        AbstractListTest.assertEquals((String)"nextIndex should be 0", (int)0, (int)nextIndex);
        int prevIndex = iter.previousIndex();
        AbstractListTest.assertEquals((String)"previousIndex should be -1", (int)-1, (int)prevIndex);
        try {
            iter.previous();
            AbstractListTest.fail((String)"Exhausted iterator should raise NoSuchElement");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    public void testListIteratorAdd() {
        if (!this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        Collection list1 = this.getCollection();
        Collection list2 = this.getConfirmed();
        E[] elements = this.getFullElements();
        ListIterator iter1 = list1.listIterator();
        ListIterator iter2 = list2.listIterator();
        for (Object element : elements) {
            iter1.add(element);
            iter2.add(element);
            this.verify();
        }
        this.resetFull();
        iter1 = this.getCollection().listIterator();
        iter2 = this.getConfirmed().listIterator();
        for (Object element : elements) {
            iter1.next();
            iter2.next();
            iter1.add(element);
            iter2.add(element);
            this.verify();
        }
    }

    public void testListIteratorSet() {
        if (!this.isSetSupported()) {
            return;
        }
        E[] elements = this.getFullElements();
        this.resetFull();
        ListIterator iter1 = this.getCollection().listIterator();
        ListIterator iter2 = this.getConfirmed().listIterator();
        for (Object element : elements) {
            iter1.next();
            iter2.next();
            iter1.set(element);
            iter2.set(element);
            this.verify();
        }
    }

    public void testEmptyListSerialization() throws IOException, ClassNotFoundException {
        Collection list = this.makeObject();
        if (!(list instanceof Serializable) || !this.isTestSerialization()) {
            return;
        }
        byte[] objekt = this.writeExternalFormToBytes((Serializable)((Object)list));
        List list2 = (List)this.readExternalFormFromBytes(objekt);
        AbstractListTest.assertEquals((String)"Both lists are empty", (int)0, (int)list.size());
        AbstractListTest.assertEquals((String)"Both lists are empty", (int)0, (int)list2.size());
    }

    public void testFullListSerialization() throws IOException, ClassNotFoundException {
        Collection list = this.makeFullCollection();
        int size = this.getFullElements().length;
        if (!(list instanceof Serializable) || !this.isTestSerialization()) {
            return;
        }
        byte[] objekt = this.writeExternalFormToBytes((Serializable)((Object)list));
        List list2 = (List)this.readExternalFormFromBytes(objekt);
        AbstractListTest.assertEquals((String)"Both lists are same size", (int)size, (int)list.size());
        AbstractListTest.assertEquals((String)"Both lists are same size", (int)size, (int)list2.size());
    }

    public void testEmptyListCompatibility() throws IOException, ClassNotFoundException {
        Collection list = this.makeObject();
        if (list instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            List list2 = (List)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(list));
            AbstractListTest.assertEquals((String)"List is empty", (int)0, (int)list2.size());
            AbstractListTest.assertEquals((Object)list, (Object)list2);
        }
    }

    public void testFullListCompatibility() throws IOException, ClassNotFoundException {
        Collection list = this.makeFullCollection();
        if (list instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            List list2 = (List)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(list));
            if (list2.size() == 4) {
                return;
            }
            AbstractListTest.assertEquals((String)"List is the right size", (int)list.size(), (int)list2.size());
            AbstractListTest.assertEquals((Object)list, (Object)list2);
        }
    }

    public BulkTest bulkTestSubList() {
        if (this.getFullElements().length - 6 < 10) {
            return null;
        }
        return new BulkTestSubList(this);
    }

    public void testListSubListFailFastOnAdd() {
        if (!this.isFailFastSupported()) {
            return;
        }
        if (!this.isAddSupported()) {
            return;
        }
        this.resetFull();
        int size = this.getCollection().size();
        List sub = this.getCollection().subList(1, size);
        this.getCollection().add(this.getOtherElements()[0]);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().add(0, this.getOtherElements()[0]);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().addAll(Arrays.asList(this.getOtherElements()));
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().addAll(0, Arrays.asList(this.getOtherElements()));
        this.failFastAll(sub);
    }

    public void testListSubListFailFastOnRemove() {
        if (!this.isFailFastSupported()) {
            return;
        }
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.getCollection().size();
        List sub = this.getCollection().subList(1, size);
        this.getCollection().remove(0);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().remove(this.getFullElements()[2]);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().removeAll(Arrays.asList(this.getFullElements()));
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().retainAll(Arrays.asList(this.getOtherElements()));
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().clear();
        this.failFastAll(sub);
    }

    protected void failFastAll(List<E> list) {
        Method[] methods;
        for (Method method : methods = List.class.getMethods()) {
            this.failFastMethod(list, method);
        }
    }

    protected void failFastMethod(List<E> list, Method m) {
        if (m.getName().equals("equals")) {
            return;
        }
        Object element = this.getOtherElements()[0];
        Set c = Collections.singleton(element);
        Class<?>[] types = m.getParameterTypes();
        Object[] params = new Object[types.length];
        for (int i = 0; i < params.length; ++i) {
            if (types[i] == Integer.TYPE) {
                params[i] = 0;
                continue;
            }
            if (types[i] == Collection.class) {
                params[i] = c;
                continue;
            }
            if (types[i] == Object.class) {
                params[i] = element;
                continue;
            }
            if (types[i] != Object[].class) continue;
            params[i] = new Object[0];
        }
        try {
            m.invoke(list, params);
            AbstractListTest.fail((String)(m.getName() + " should raise ConcurrentModification"));
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ConcurrentModificationException) {
                return;
            }
            AbstractListTest.fail((String)(m.getName() + " raised unexpected " + e));
        }
    }

    public BulkTest bulkTestListIterator() {
        return new TestListIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestListIterator
    extends AbstractListIteratorTest<E> {
        public TestListIterator() {
            super("TestListIterator");
        }

        @Override
        public E addSetValue() {
            return AbstractListTest.this.getOtherElements()[0];
        }

        @Override
        public boolean supportsRemove() {
            return AbstractListTest.this.isRemoveSupported();
        }

        @Override
        public boolean supportsAdd() {
            return AbstractListTest.this.isAddSupported();
        }

        @Override
        public boolean supportsSet() {
            return AbstractListTest.this.isSetSupported();
        }

        @Override
        public ListIterator<E> makeEmptyIterator() {
            AbstractListTest.this.resetEmpty();
            return AbstractListTest.this.getCollection().listIterator();
        }

        @Override
        public ListIterator<E> makeObject() {
            AbstractListTest.this.resetFull();
            return AbstractListTest.this.getCollection().listIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BulkTestSubList<E>
    extends AbstractListTest<E> {
        private final AbstractListTest<E> outer;

        public BulkTestSubList(AbstractListTest<E> outer) {
            super("");
            this.outer = outer;
        }

        @Override
        public E[] getFullElements() {
            List l = Arrays.asList(this.outer.getFullElements());
            return l.subList(3, l.size() - 3).toArray();
        }

        @Override
        public E[] getOtherElements() {
            return this.outer.getOtherElements();
        }

        @Override
        public boolean isAddSupported() {
            return this.outer.isAddSupported();
        }

        @Override
        public boolean isSetSupported() {
            return this.outer.isSetSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return this.outer.isRemoveSupported();
        }

        @Override
        public List<E> makeObject() {
            return this.outer.makeFullCollection().subList(4, 4);
        }

        @Override
        public List<E> makeFullCollection() {
            int size = this.getFullElements().length;
            return this.outer.makeFullCollection().subList(3, size - 3);
        }

        @Override
        public void resetEmpty() {
            this.outer.resetFull();
            this.setCollection(this.outer.getCollection().subList(4, 4));
            this.setConfirmed(this.outer.getConfirmed().subList(4, 4));
        }

        @Override
        public void resetFull() {
            this.outer.resetFull();
            int size = this.outer.getConfirmed().size();
            this.setCollection(this.outer.getCollection().subList(3, size - 3));
            this.setConfirmed(this.outer.getConfirmed().subList(3, size - 3));
        }

        @Override
        public void verify() {
            super.verify();
            this.outer.verify();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }
    }
}

