/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;
import org.apache.commons.collections4.iterators.UnmodifiableMapIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableMapIteratorTest<K, V>
extends AbstractMapIteratorTest<K, V> {
    public UnmodifiableMapIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public MapIterator<K, V> makeEmptyIterator() {
        return UnmodifiableMapIterator.unmodifiableMapIterator((MapIterator)new DualHashBidiMap().mapIterator());
    }

    @Override
    public MapIterator<K, V> makeObject() {
        return UnmodifiableMapIterator.unmodifiableMapIterator((MapIterator)this.getMap().mapIterator());
    }

    @Override
    public IterableMap<K, V> getMap() {
        DualHashBidiMap testMap = new DualHashBidiMap();
        testMap.put((Object)"A", (Object)"a");
        testMap.put((Object)"B", (Object)"b");
        testMap.put((Object)"C", (Object)"c");
        return testMap;
    }

    @Override
    public Map<K, V> getConfirmedMap() {
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("A", "a");
        testMap.put("B", "b");
        testMap.put("C", "c");
        return testMap;
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public boolean supportsSetValue() {
        return false;
    }

    public void testMapIterator() {
        UnmodifiableMapIteratorTest.assertTrue((boolean)(this.makeEmptyIterator() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        MapIterator it = this.makeObject();
        UnmodifiableMapIteratorTest.assertSame(it, (Object)UnmodifiableMapIterator.unmodifiableMapIterator(it));
        it = this.getMap().mapIterator();
        UnmodifiableMapIteratorTest.assertTrue((it != UnmodifiableMapIterator.unmodifiableMapIterator((MapIterator)it) ? 1 : 0) != 0);
        try {
            UnmodifiableMapIterator.unmodifiableMapIterator(null);
            UnmodifiableMapIteratorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

