/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.IndexedCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedCollectionTest
extends AbstractCollectionTest<String> {
    public IndexedCollectionTest(String name) {
        super(name);
    }

    protected Collection<String> decorateCollection(Collection<String> collection) {
        return IndexedCollection.nonUniqueIndexedCollection(collection, (Transformer)new IntegerTransformer());
    }

    protected IndexedCollection<Integer, String> decorateUniqueCollection(Collection<String> collection) {
        return IndexedCollection.uniqueIndexedCollection(collection, (Transformer)new IntegerTransformer());
    }

    @Override
    public Collection<String> makeObject() {
        return this.decorateCollection(new ArrayList<String>());
    }

    @Override
    public Collection<String> makeConfirmedCollection() {
        return new ArrayList<String>();
    }

    public String[] getFullElements() {
        return new String[]{"1", "3", "5", "7", "2", "4", "6"};
    }

    public String[] getOtherElements() {
        return new String[]{"9", "88", "678", "87", "98", "78", "99"};
    }

    @Override
    public Collection<String> makeFullCollection() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(this.getFullElements()));
        return this.decorateCollection(list);
    }

    @Override
    public Collection<String> makeConfirmedFullCollection() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    public Collection<String> makeTestCollection() {
        return this.decorateCollection(new ArrayList<String>());
    }

    public Collection<String> makeUniqueTestCollection() {
        return this.decorateUniqueCollection(new ArrayList<String>());
    }

    @Override
    protected boolean skipSerializedCanonicalTests() {
        return true;
    }

    public void testAddedObjectsCanBeRetrievedByKey() throws Exception {
        Collection<String> coll = this.makeTestCollection();
        coll.add("12");
        coll.add("16");
        coll.add("1");
        coll.addAll(Arrays.asList("2", "3", "4"));
        IndexedCollection indexed = (IndexedCollection)coll;
        IndexedCollectionTest.assertEquals((String)"12", (String)((String)indexed.get((Object)12)));
        IndexedCollectionTest.assertEquals((String)"16", (String)((String)indexed.get((Object)16)));
        IndexedCollectionTest.assertEquals((String)"1", (String)((String)indexed.get((Object)1)));
        IndexedCollectionTest.assertEquals((String)"2", (String)((String)indexed.get((Object)2)));
        IndexedCollectionTest.assertEquals((String)"3", (String)((String)indexed.get((Object)3)));
        IndexedCollectionTest.assertEquals((String)"4", (String)((String)indexed.get((Object)4)));
    }

    public void testEnsureDuplicateObjectsCauseException() throws Exception {
        Collection<String> coll = this.makeUniqueTestCollection();
        coll.add("1");
        try {
            coll.add("1");
            IndexedCollectionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDecoratedCollectionIsIndexedOnCreation() throws Exception {
        Collection<String> original = this.makeFullCollection();
        IndexedCollection<Integer, String> indexed = this.decorateUniqueCollection(original);
        IndexedCollectionTest.assertEquals((String)"1", (String)((String)indexed.get((Object)1)));
        IndexedCollectionTest.assertEquals((String)"2", (String)((String)indexed.get((Object)2)));
        IndexedCollectionTest.assertEquals((String)"3", (String)((String)indexed.get((Object)3)));
    }

    public void testReindexUpdatesIndexWhenDecoratedCollectionIsModifiedSeparately() throws Exception {
        ArrayList<String> original = new ArrayList<String>();
        IndexedCollection<Integer, String> indexed = this.decorateUniqueCollection(original);
        original.add("1");
        original.add("2");
        original.add("3");
        IndexedCollectionTest.assertNull((Object)indexed.get((Object)1));
        IndexedCollectionTest.assertNull((Object)indexed.get((Object)2));
        IndexedCollectionTest.assertNull((Object)indexed.get((Object)3));
        indexed.reindex();
        IndexedCollectionTest.assertEquals((String)"1", (String)((String)indexed.get((Object)1)));
        IndexedCollectionTest.assertEquals((String)"2", (String)((String)indexed.get((Object)2)));
        IndexedCollectionTest.assertEquals((String)"3", (String)((String)indexed.get((Object)3)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntegerTransformer
    implements Transformer<String, Integer>,
    Serializable {
        private static final long serialVersionUID = 809439581555072949L;

        private IntegerTransformer() {
        }

        public Integer transform(String input) {
            return Integer.valueOf(input);
        }
    }
}

