/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.AbstractObjectTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionTest<E>
extends AbstractObjectTest {
    private Collection<E> collection;
    private Collection<E> confirmed;

    public AbstractCollectionTest(String testName) {
        super(testName);
    }

    public boolean areEqualElementsDistinguishable() {
        return false;
    }

    public boolean isAddSupported() {
        return true;
    }

    public boolean isRemoveSupported() {
        return true;
    }

    public boolean isNullSupported() {
        return true;
    }

    public boolean isFailFastSupported() {
        return false;
    }

    @Override
    public boolean isEqualsCheckable() {
        return false;
    }

    public void verify() {
        int confirmedSize = this.getConfirmed().size();
        AbstractCollectionTest.assertEquals((String)"Collection size should match confirmed collection's", (int)confirmedSize, (int)this.getCollection().size());
        AbstractCollectionTest.assertEquals((String)"Collection isEmpty() result should match confirmed collection's", (boolean)this.getConfirmed().isEmpty(), (boolean)this.getCollection().isEmpty());
        Object[] confirmedValues = new Object[confirmedSize];
        Iterator<E> iter = this.getConfirmed().iterator();
        int pos = 0;
        while (iter.hasNext()) {
            confirmedValues[pos++] = iter.next();
        }
        boolean[] matched = new boolean[confirmedSize];
        for (E o : this.getCollection()) {
            boolean match = false;
            for (int i = 0; i < confirmedSize; ++i) {
                if (matched[i] || o != confirmedValues[i] && (o == null || !o.equals(confirmedValues[i]))) continue;
                matched[i] = true;
                match = true;
                break;
            }
            if (match) continue;
            AbstractCollectionTest.fail((String)("Collection should not contain a value that the confirmed collection does not have: " + o + "\nTest: " + this.getCollection() + "\nReal: " + this.getConfirmed()));
        }
        for (int i = 0; i < confirmedSize; ++i) {
            if (matched[i]) continue;
            AbstractCollectionTest.fail((String)("Collection should contain all values that are in the confirmed collection\nTest: " + this.getCollection() + "\nReal: " + this.getConfirmed()));
        }
    }

    public void resetEmpty() {
        this.setCollection((Collection<E>)this.makeObject());
        this.setConfirmed(this.makeConfirmedCollection());
    }

    public void resetFull() {
        this.setCollection(this.makeFullCollection());
        this.setConfirmed(this.makeConfirmedFullCollection());
    }

    public abstract Collection<E> makeConfirmedCollection();

    public abstract Collection<E> makeConfirmedFullCollection();

    @Override
    public abstract Collection<E> makeObject();

    public Collection<E> makeFullCollection() {
        Object c = this.makeObject();
        c.addAll(Arrays.asList(this.getFullElements()));
        return c;
    }

    public Map.Entry<E, E> cloneMapEntry(Map.Entry<E, E> entry) {
        HashMap<E, E> map = new HashMap<E, E>();
        map.put(entry.getKey(), entry.getValue());
        return map.entrySet().iterator().next();
    }

    public E[] getFullElements() {
        if (this.isNullSupported()) {
            ArrayList<E> list = new ArrayList<E>();
            list.addAll(Arrays.asList(this.getFullNonNullElements()));
            list.add(4, null);
            return list.toArray();
        }
        return (Object[])this.getFullNonNullElements().clone();
    }

    public E[] getOtherElements() {
        return this.getOtherNonNullElements();
    }

    public E[] getFullNonNullElements() {
        return new Object[]{new String(""), new String("One"), 2, "Three", 4, "One", new Double(5.0), new Float(6.0f), "Seven", "Eight", new String("Nine"), 10, new Short(11), new Long(12L), "Thirteen", "14", "15", new Byte(16)};
    }

    public E[] getOtherNonNullElements() {
        return new Object[]{0, new Float(0.0f), new Double(0.0), "Zero", new Short(0), new Byte(0), new Long(0L), new Character('\u0000'), "0"};
    }

    public Object[] getFullNonNullStringElements() {
        return new Object[]{"If", "the", "dull", "substance", "of", "my", "flesh", "were", "thought", "Injurious", "distance", "could", "not", "stop", "my", "way"};
    }

    public Object[] getOtherNonNullStringElements() {
        return new Object[]{"For", "then", "despite", "space", "I", "would", "be", "brought", "From", "limits", "far", "remote", "where", "thou", "dost", "stay"};
    }

    public void testCollectionAdd() {
        E[] elements;
        if (!this.isAddSupported()) {
            return;
        }
        for (E element : elements = this.getFullElements()) {
            this.resetEmpty();
            boolean r = this.getCollection().add(element);
            this.getConfirmed().add(element);
            this.verify();
            AbstractCollectionTest.assertTrue((String)"Empty collection changed after add", (boolean)r);
            AbstractCollectionTest.assertEquals((String)"Collection size is 1 after first add", (int)1, (int)this.getCollection().size());
        }
        this.resetEmpty();
        int size = 0;
        for (E element : elements) {
            boolean r = this.getCollection().add(element);
            this.getConfirmed().add(element);
            this.verify();
            if (r) {
                ++size;
            }
            AbstractCollectionTest.assertEquals((String)"Collection size should grow after add", (int)size, (int)this.getCollection().size());
            AbstractCollectionTest.assertTrue((String)"Collection should contain added element", (boolean)this.getCollection().contains(element));
        }
    }

    public void testCollectionAddAll() {
        if (!this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        E[] elements = this.getFullElements();
        boolean r = this.getCollection().addAll(Arrays.asList(elements));
        this.getConfirmed().addAll(Arrays.asList(elements));
        this.verify();
        AbstractCollectionTest.assertTrue((String)"Empty collection should change after addAll", (boolean)r);
        for (E element : elements) {
            AbstractCollectionTest.assertTrue((String)"Collection should contain added element", (boolean)this.getCollection().contains(element));
        }
        this.resetFull();
        int size = this.getCollection().size();
        elements = this.getOtherElements();
        r = this.getCollection().addAll(Arrays.asList(elements));
        this.getConfirmed().addAll(Arrays.asList(elements));
        this.verify();
        AbstractCollectionTest.assertTrue((String)"Full collection should change after addAll", (boolean)r);
        for (E element : elements) {
            AbstractCollectionTest.assertTrue((String)"Full collection should contain added element", (boolean)this.getCollection().contains(element));
        }
        AbstractCollectionTest.assertEquals((String)"Size should increase after addAll", (int)(size + elements.length), (int)this.getCollection().size());
        this.resetFull();
        size = this.getCollection().size();
        r = this.getCollection().addAll(Arrays.asList(this.getFullElements()));
        this.getConfirmed().addAll(Arrays.asList(this.getFullElements()));
        this.verify();
        if (r) {
            AbstractCollectionTest.assertTrue((String)"Size should increase if addAll returns true", (size < this.getCollection().size() ? 1 : 0) != 0);
        } else {
            AbstractCollectionTest.assertEquals((String)"Size should not change if addAll returns false", (int)size, (int)this.getCollection().size());
        }
    }

    public void testUnsupportedAdd() {
        if (this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            this.getCollection().add(this.getFullNonNullElements()[0]);
            AbstractCollectionTest.fail((String)"Empty collection should not support add.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        try {
            this.getCollection().addAll(Arrays.asList(this.getFullElements()));
            AbstractCollectionTest.fail((String)"Empty collection should not support addAll.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        try {
            this.getCollection().add(this.getFullNonNullElements()[0]);
            AbstractCollectionTest.fail((String)"Full collection should not support add.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        try {
            this.getCollection().addAll(Arrays.asList(this.getOtherElements()));
            AbstractCollectionTest.fail((String)"Full collection should not support addAll.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verify();
    }

    public void testCollectionClear() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        this.getCollection().clear();
        this.verify();
        this.resetFull();
        this.getCollection().clear();
        this.getConfirmed().clear();
        this.verify();
    }

    public void testCollectionContains() {
        int i;
        this.resetEmpty();
        E[] elements = this.getFullElements();
        for (i = 0; i < elements.length; ++i) {
            AbstractCollectionTest.assertTrue((String)("Empty collection shouldn't contain element[" + i + "]"), (!this.getCollection().contains(elements[i]) ? 1 : 0) != 0);
        }
        this.verify();
        elements = this.getOtherElements();
        for (i = 0; i < elements.length; ++i) {
            AbstractCollectionTest.assertTrue((String)("Empty collection shouldn't contain element[" + i + "]"), (!this.getCollection().contains(elements[i]) ? 1 : 0) != 0);
        }
        this.verify();
        this.resetFull();
        elements = this.getFullElements();
        for (i = 0; i < elements.length; ++i) {
            AbstractCollectionTest.assertTrue((String)("Full collection should contain element[" + i + "]"), (boolean)this.getCollection().contains(elements[i]));
        }
        this.verify();
        this.resetFull();
        for (E element : elements = this.getOtherElements()) {
            AbstractCollectionTest.assertTrue((String)"Full collection shouldn't contain element", (!this.getCollection().contains(element) ? 1 : 0) != 0);
        }
    }

    public void testCollectionContainsAll() {
        int min;
        this.resetEmpty();
        Collection<E> col = new HashSet<E>();
        AbstractCollectionTest.assertTrue((String)"Every Collection should contain all elements of an empty Collection.", (boolean)this.getCollection().containsAll(col));
        col.addAll(Arrays.asList(this.getOtherElements()));
        AbstractCollectionTest.assertTrue((String)"Empty Collection shouldn't contain all elements of a non-empty Collection.", (!this.getCollection().containsAll(col) ? 1 : 0) != 0);
        this.verify();
        this.resetFull();
        AbstractCollectionTest.assertTrue((String)"Full collection shouldn't contain other elements", (!this.getCollection().containsAll(col) ? 1 : 0) != 0);
        col.clear();
        col.addAll(Arrays.asList(this.getFullElements()));
        AbstractCollectionTest.assertTrue((String)"Full collection should containAll full elements", (boolean)this.getCollection().containsAll(col));
        this.verify();
        int n = min = this.getFullElements().length < 2 ? 0 : 2;
        int max = this.getFullElements().length == 1 ? 1 : (this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5);
        col = Arrays.asList(this.getFullElements()).subList(min, max);
        AbstractCollectionTest.assertTrue((String)"Full collection should containAll partial full elements", (boolean)this.getCollection().containsAll(col));
        AbstractCollectionTest.assertTrue((String)"Full collection should containAll itself", (boolean)this.getCollection().containsAll(this.getCollection()));
        this.verify();
        col = new ArrayList();
        col.addAll(Arrays.asList(this.getFullElements()));
        col.addAll(Arrays.asList(this.getFullElements()));
        AbstractCollectionTest.assertTrue((String)"Full collection should containAll duplicate full elements", (boolean)this.getCollection().containsAll(col));
        this.verify();
    }

    public void testCollectionIsEmpty() {
        this.resetEmpty();
        AbstractCollectionTest.assertEquals((String)"New Collection should be empty.", (boolean)true, (boolean)this.getCollection().isEmpty());
        this.verify();
        this.resetFull();
        AbstractCollectionTest.assertEquals((String)"Full collection shouldn't be empty", (boolean)false, (boolean)this.getCollection().isEmpty());
        this.verify();
    }

    public void testCollectionIterator() {
        this.resetEmpty();
        Iterator<E> it1 = this.getCollection().iterator();
        AbstractCollectionTest.assertEquals((String)"Iterator for empty Collection shouldn't have next.", (boolean)false, (boolean)it1.hasNext());
        try {
            it1.next();
            AbstractCollectionTest.fail((String)"Iterator at end of Collection should throw NoSuchElementException when next is called.");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        it1 = this.getCollection().iterator();
        for (int i = 0; i < this.getCollection().size(); ++i) {
            AbstractCollectionTest.assertTrue((String)"Iterator for full collection should haveNext", (boolean)it1.hasNext());
            it1.next();
        }
        AbstractCollectionTest.assertTrue((String)"Iterator should be finished", (!it1.hasNext() ? 1 : 0) != 0);
        ArrayList<E> list = new ArrayList<E>();
        it1 = this.getCollection().iterator();
        for (int i = 0; i < this.getCollection().size(); ++i) {
            E next = it1.next();
            AbstractCollectionTest.assertTrue((String)"Collection should contain element returned by its iterator", (boolean)this.getCollection().contains(next));
            list.add(next);
        }
        try {
            it1.next();
            AbstractCollectionTest.fail((String)"iterator.next() should raise NoSuchElementException after it finishes");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.verify();
    }

    public void testCollectionIteratorRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            this.getCollection().iterator().remove();
            AbstractCollectionTest.fail((String)"New iterator.remove should raise IllegalState");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.verify();
        try {
            Iterator<E> iter = this.getCollection().iterator();
            iter.hasNext();
            iter.remove();
            AbstractCollectionTest.fail((String)"New iterator.remove should raise IllegalState even after hasNext");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        int size = this.getCollection().size();
        Iterator<E> iter = this.getCollection().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Map.Entry) {
                o = this.cloneMapEntry((Map.Entry)o);
            }
            iter.remove();
            if (!this.areEqualElementsDistinguishable()) {
                this.getConfirmed().remove(o);
                this.verify();
            }
            AbstractCollectionTest.assertEquals((String)"Collection should shrink by one after iterator.remove", (int)(--size), (int)this.getCollection().size());
        }
        AbstractCollectionTest.assertTrue((String)"Collection should be empty after iterator purge", (boolean)this.getCollection().isEmpty());
        this.resetFull();
        iter = this.getCollection().iterator();
        iter.next();
        iter.remove();
        try {
            iter.remove();
            AbstractCollectionTest.fail((String)"Second iter.remove should raise IllegalState");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCollectionRemove() {
        E[] elements;
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        for (E element : elements = this.getFullElements()) {
            AbstractCollectionTest.assertTrue((String)"Shouldn't remove nonexistent element", (!this.getCollection().remove(element) ? 1 : 0) != 0);
            this.verify();
        }
        E[] other = this.getOtherElements();
        this.resetFull();
        for (E element : other) {
            AbstractCollectionTest.assertTrue((String)"Shouldn't remove nonexistent other element", (!this.getCollection().remove(element) ? 1 : 0) != 0);
            this.verify();
        }
        int size = this.getCollection().size();
        for (E element : elements) {
            this.resetFull();
            AbstractCollectionTest.assertTrue((String)("Collection should remove extant element: " + element), (boolean)this.getCollection().remove(element));
            if (!this.areEqualElementsDistinguishable()) {
                this.getConfirmed().remove(element);
                this.verify();
            }
            AbstractCollectionTest.assertEquals((String)"Collection should shrink after remove", (int)(size - 1), (int)this.getCollection().size());
        }
    }

    public void testCollectionRemoveAll() {
        int min;
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        AbstractCollectionTest.assertTrue((String)"Empty collection removeAll should return false for empty input", (!this.getCollection().removeAll(Collections.EMPTY_SET) ? 1 : 0) != 0);
        this.verify();
        AbstractCollectionTest.assertTrue((String)"Empty collection removeAll should return false for nonempty input", (!this.getCollection().removeAll(new ArrayList<E>(this.getCollection())) ? 1 : 0) != 0);
        this.verify();
        this.resetFull();
        AbstractCollectionTest.assertTrue((String)"Full collection removeAll should return false for empty input", (!this.getCollection().removeAll(Collections.EMPTY_SET) ? 1 : 0) != 0);
        this.verify();
        AbstractCollectionTest.assertTrue((String)"Full collection removeAll should return false for other elements", (!this.getCollection().removeAll(Arrays.asList(this.getOtherElements())) ? 1 : 0) != 0);
        this.verify();
        AbstractCollectionTest.assertTrue((String)"Full collection removeAll should return true for full elements", (boolean)this.getCollection().removeAll(new HashSet<E>(this.getCollection())));
        this.getConfirmed().removeAll(new HashSet<E>(this.getConfirmed()));
        this.verify();
        this.resetFull();
        int size = this.getCollection().size();
        int n = min = this.getFullElements().length < 2 ? 0 : 2;
        int max = this.getFullElements().length == 1 ? 1 : (this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5);
        List<E> all = Arrays.asList(this.getFullElements()).subList(min, max);
        AbstractCollectionTest.assertTrue((String)"Full collection removeAll should work", (boolean)this.getCollection().removeAll(all));
        this.getConfirmed().removeAll(all);
        this.verify();
        AbstractCollectionTest.assertTrue((String)"Collection should shrink after removeAll", (this.getCollection().size() < size ? 1 : 0) != 0);
        for (Object element : all) {
            AbstractCollectionTest.assertTrue((String)"Collection shouldn't contain removed element", (!this.getCollection().contains(element) ? 1 : 0) != 0);
        }
    }

    public void testCollectionRetainAll() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        List<E> elements = Arrays.asList(this.getFullElements());
        List<E> other = Arrays.asList(this.getOtherElements());
        AbstractCollectionTest.assertTrue((String)"Empty retainAll() should return false", (!this.getCollection().retainAll(Collections.EMPTY_SET) ? 1 : 0) != 0);
        this.verify();
        AbstractCollectionTest.assertTrue((String)"Empty retainAll() should return false", (!this.getCollection().retainAll(elements) ? 1 : 0) != 0);
        this.verify();
        this.resetFull();
        AbstractCollectionTest.assertTrue((String)"Collection should change from retainAll empty", (boolean)this.getCollection().retainAll(Collections.EMPTY_SET));
        this.getConfirmed().retainAll(Collections.EMPTY_SET);
        this.verify();
        this.resetFull();
        AbstractCollectionTest.assertTrue((String)"Collection changed from retainAll other", (boolean)this.getCollection().retainAll(other));
        this.getConfirmed().retainAll(other);
        this.verify();
        this.resetFull();
        int size = this.getCollection().size();
        AbstractCollectionTest.assertTrue((String)"Collection shouldn't change from retainAll elements", (!this.getCollection().retainAll(elements) ? 1 : 0) != 0);
        this.verify();
        AbstractCollectionTest.assertEquals((String)"Collection size shouldn't change", (int)size, (int)this.getCollection().size());
        if (this.getFullElements().length > 1) {
            this.resetFull();
            size = this.getCollection().size();
            int min = this.getFullElements().length < 2 ? 0 : 2;
            int max = this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5;
            AbstractCollectionTest.assertTrue((String)"Collection should changed by partial retainAll", (boolean)this.getCollection().retainAll(elements.subList(min, max)));
            this.getConfirmed().retainAll(elements.subList(min, max));
            this.verify();
            for (E element : this.getCollection()) {
                AbstractCollectionTest.assertTrue((String)"Collection only contains retained element", (boolean)elements.subList(min, max).contains(element));
            }
        }
        this.resetFull();
        HashSet<E> set = new HashSet<E>(elements);
        size = this.getCollection().size();
        AbstractCollectionTest.assertTrue((String)"Collection shouldn't change from retainAll without duplicate elements", (!this.getCollection().retainAll(set) ? 1 : 0) != 0);
        this.verify();
        AbstractCollectionTest.assertEquals((String)"Collection size didn't change from nonduplicate retainAll", (int)size, (int)this.getCollection().size());
    }

    public void testCollectionSize() {
        this.resetEmpty();
        AbstractCollectionTest.assertEquals((String)"Size of new Collection is 0.", (int)0, (int)this.getCollection().size());
        this.resetFull();
        AbstractCollectionTest.assertTrue((String)"Size of full collection should be greater than zero", (this.getCollection().size() > 0 ? 1 : 0) != 0);
    }

    public void testCollectionToArray() {
        this.resetEmpty();
        AbstractCollectionTest.assertEquals((String)"Empty Collection should return empty array for toArray", (int)0, (int)this.getCollection().toArray().length);
        this.resetFull();
        Object[] array = this.getCollection().toArray();
        AbstractCollectionTest.assertEquals((String)"Full collection toArray should be same size as collection", (int)array.length, (int)this.getCollection().size());
        Object[] confirmedArray = this.getConfirmed().toArray();
        AbstractCollectionTest.assertEquals((String)"length of array from confirmed collection should match the length of the collection's array", (int)confirmedArray.length, (int)array.length);
        boolean[] matched = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            AbstractCollectionTest.assertTrue((String)"Collection should contain element in toArray", (boolean)this.getCollection().contains(array[i]));
            boolean match = false;
            for (int j = 0; j < array.length; ++j) {
                if (matched[j] || array[i] != confirmedArray[j] && (array[i] == null || !array[i].equals(confirmedArray[j]))) continue;
                matched[j] = true;
                match = true;
                break;
            }
            if (match) continue;
            AbstractCollectionTest.fail((String)("element " + i + " in returned array should be found " + "in the confirmed collection's array"));
        }
        for (boolean element : matched) {
            AbstractCollectionTest.assertEquals((String)"Collection should return all its elements in toArray", (boolean)true, (boolean)element);
        }
    }

    public void testCollectionToArray2() {
        this.resetEmpty();
        Object[] a = new Object[]{new Object(), null, null};
        Object[] array = this.getCollection().toArray(a);
        AbstractCollectionTest.assertEquals((String)"Given array shouldn't shrink", (Object)array, (Object)a);
        AbstractCollectionTest.assertNull((String)"Last element should be set to null", (Object)a[0]);
        this.verify();
        this.resetFull();
        try {
            array = this.getCollection().toArray(new Void[0]);
            AbstractCollectionTest.fail((String)"toArray(new Void[0]) should raise ArrayStore");
        }
        catch (ArrayStoreException e) {
            // empty catch block
        }
        this.verify();
        try {
            array = this.getCollection().toArray((T[])null);
            AbstractCollectionTest.fail((String)"toArray(null) should raise NPE");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.verify();
        array = this.getCollection().toArray(new Object[0]);
        a = this.getCollection().toArray();
        AbstractCollectionTest.assertEquals((String)"toArrays should be equal", Arrays.asList(array), Arrays.asList(a));
        HashSet classes = new HashSet();
        for (Object element : array) {
            classes.add(element == null ? null : element.getClass());
        }
        if (classes.size() > 1) {
            return;
        }
        Class<Map.Entry> cl = (Class<Map.Entry>)classes.iterator().next();
        if (Map.Entry.class.isAssignableFrom(cl)) {
            cl = Map.Entry.class;
        }
        a = (Object[])Array.newInstance(cl, 0);
        array = this.getCollection().toArray(a);
        AbstractCollectionTest.assertEquals((String)"toArray(Object[]) should return correct array type", a.getClass(), array.getClass());
        AbstractCollectionTest.assertEquals((String)"type-specific toArrays should be equal", Arrays.asList(array), Arrays.asList(this.getCollection().toArray()));
        this.verify();
    }

    public void testCollectionToString() {
        this.resetEmpty();
        AbstractCollectionTest.assertTrue((String)"toString shouldn't return null", (this.getCollection().toString() != null ? 1 : 0) != 0);
        this.resetFull();
        AbstractCollectionTest.assertTrue((String)"toString shouldn't return null", (this.getCollection().toString() != null ? 1 : 0) != 0);
    }

    public void testUnsupportedRemove() {
        if (this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            this.getCollection().clear();
            AbstractCollectionTest.fail((String)"clear should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        try {
            this.getCollection().remove(null);
            AbstractCollectionTest.fail((String)"remove should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        try {
            this.getCollection().removeAll(null);
            AbstractCollectionTest.fail((String)"removeAll should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        try {
            this.getCollection().retainAll(null);
            AbstractCollectionTest.fail((String)"retainAll should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        try {
            Iterator<E> iterator = this.getCollection().iterator();
            iterator.next();
            iterator.remove();
            AbstractCollectionTest.fail((String)"iterator.remove should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verify();
    }

    public void testCollectionIteratorFailFast() {
        List<E> sublist;
        Iterator<E> iter;
        if (!this.isFailFastSupported()) {
            return;
        }
        if (this.isAddSupported()) {
            this.resetFull();
            try {
                iter = this.getCollection().iterator();
                E o = this.getOtherElements()[0];
                this.getCollection().add(o);
                this.getConfirmed().add(o);
                iter.next();
                AbstractCollectionTest.fail((String)"next after add should raise ConcurrentModification");
            }
            catch (ConcurrentModificationException e) {
                // empty catch block
            }
            this.verify();
            this.resetFull();
            try {
                iter = this.getCollection().iterator();
                this.getCollection().addAll(Arrays.asList(this.getOtherElements()));
                this.getConfirmed().addAll(Arrays.asList(this.getOtherElements()));
                iter.next();
                AbstractCollectionTest.fail((String)"next after addAll should raise ConcurrentModification");
            }
            catch (ConcurrentModificationException e) {
                // empty catch block
            }
            this.verify();
        }
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        try {
            iter = this.getCollection().iterator();
            this.getCollection().clear();
            iter.next();
            AbstractCollectionTest.fail((String)"next after clear should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException e) {
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.resetFull();
        try {
            iter = this.getCollection().iterator();
            this.getCollection().remove(this.getFullElements()[0]);
            iter.next();
            AbstractCollectionTest.fail((String)"next after remove should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        this.resetFull();
        try {
            iter = this.getCollection().iterator();
            sublist = Arrays.asList(this.getFullElements()).subList(2, 5);
            this.getCollection().removeAll(sublist);
            iter.next();
            AbstractCollectionTest.fail((String)"next after removeAll should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        this.resetFull();
        try {
            iter = this.getCollection().iterator();
            sublist = Arrays.asList(this.getFullElements()).subList(2, 5);
            this.getCollection().retainAll(sublist);
            iter.next();
            AbstractCollectionTest.fail((String)"next after retainAll should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Override
    public void testSerializeDeserializeThenCompare() throws Exception {
        Object dest;
        ObjectInputStream in;
        ObjectOutputStream out;
        ByteArrayOutputStream buffer;
        Collection<E> obj = this.makeObject();
        if (obj instanceof Serializable && this.isTestSerialization()) {
            buffer = new ByteArrayOutputStream();
            out = new ObjectOutputStream(buffer);
            out.writeObject(obj);
            out.close();
            in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            dest = in.readObject();
            in.close();
            if (this.isEqualsCheckable()) {
                AbstractCollectionTest.assertEquals((String)"obj != deserialize(serialize(obj)) - EMPTY Collection", obj, (Object)dest);
            }
        }
        if ((obj = this.makeFullCollection()) instanceof Serializable && this.isTestSerialization()) {
            buffer = new ByteArrayOutputStream();
            out = new ObjectOutputStream(buffer);
            out.writeObject(obj);
            out.close();
            in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            dest = in.readObject();
            in.close();
            if (this.isEqualsCheckable()) {
                AbstractCollectionTest.assertEquals((String)"obj != deserialize(serialize(obj)) - FULL Collection", obj, (Object)dest);
            }
        }
    }

    public Collection<E> getCollection() {
        return this.collection;
    }

    public void setCollection(Collection<E> collection) {
        this.collection = collection;
    }

    public Collection<E> getConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(Collection<E> confirmed) {
        this.confirmed = confirmed;
    }

    protected static void assertNotCollectionContains(Collection<?> coll, Object element) {
        try {
            AbstractCollectionTest.assertFalse((boolean)coll.contains(element));
        }
        catch (ClassCastException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected static void assertNotCollectionContainsAll(Collection<?> coll, Collection<?> sub) {
        try {
            AbstractCollectionTest.assertFalse((boolean)coll.containsAll(sub));
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected static void assertNotRemoveFromCollection(Collection<?> coll, Object element) {
        try {
            AbstractCollectionTest.assertFalse((boolean)coll.remove(element));
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected static void assertNotRemoveAllFromCollection(Collection<?> coll, Collection<?> sub) {
        try {
            AbstractCollectionTest.assertFalse((boolean)coll.removeAll(sub));
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

