/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Comparator;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.AbstractSortedBagTest;
import org.apache.commons.collections4.bag.PredicatedSortedBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.functors.TruePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicatedSortedBagTest<T>
extends AbstractSortedBagTest<T> {
    private final SortedBag<T> nullBag = null;
    protected Predicate<T> truePredicate = TruePredicate.truePredicate();

    public PredicatedSortedBagTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(PredicatedSortedBagTest.class);
    }

    protected Predicate<T> stringPredicate() {
        return new Predicate<T>(){

            public boolean evaluate(T o) {
                return o instanceof String;
            }
        };
    }

    protected SortedBag<T> decorateBag(SortedBag<T> bag, Predicate<T> predicate) {
        return PredicatedSortedBag.predicatedSortedBag(bag, predicate);
    }

    @Override
    public SortedBag<T> makeObject() {
        return this.decorateBag((SortedBag<T>)new TreeBag(), this.truePredicate);
    }

    protected SortedBag<T> makeTestBag() {
        return this.decorateBag((SortedBag<T>)new TreeBag(), this.stringPredicate());
    }

    public void testDecorate() {
        SortedBag<T> bag = this.decorateBag((SortedBag<T>)new TreeBag(), this.stringPredicate());
        ((PredicatedSortedBag)bag).decorated();
        try {
            this.decorateBag((SortedBag<T>)new TreeBag(), null);
            PredicatedSortedBagTest.fail((String)"Expecting IllegalArgumentException for null predicate");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.decorateBag(this.nullBag, this.stringPredicate());
            PredicatedSortedBagTest.fail((String)"Expecting IllegalArgumentException for null bag");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSortOrder() {
        SortedBag<T> bag = this.decorateBag((SortedBag<T>)new TreeBag(), this.stringPredicate());
        String one = "one";
        String two = "two";
        String three = "three";
        bag.add((Object)"one");
        bag.add((Object)"two");
        bag.add((Object)"three");
        PredicatedSortedBagTest.assertEquals((String)"first element", (Object)bag.first(), (Object)"one");
        PredicatedSortedBagTest.assertEquals((String)"last element", (Object)bag.last(), (Object)"two");
        Comparator c = bag.comparator();
        PredicatedSortedBagTest.assertTrue((String)"natural order, so comparator should be null", (c == null ? 1 : 0) != 0);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

