/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Get;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.Put;
import org.apache.commons.collections4.SplitMapUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.functors.NOPTransformer;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.collections4.splitmap.TransformedSplitMap;

public class SplitMapUtilsTest
extends BulkTest {
    private Map<String, Integer> backingMap;
    private TransformedSplitMap<String, String, String, Integer> transformedMap;
    private final Transformer<String, Integer> stringToInt = new Transformer<String, Integer>(){

        public Integer transform(String input) {
            return Integer.valueOf(input);
        }
    };

    public SplitMapUtilsTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.backingMap = new HashMap<String, Integer>();
        this.transformedMap = TransformedSplitMap.transformingMap(this.backingMap, (Transformer)NOPTransformer.nopTransformer(), this.stringToInt);
        for (int i = 0; i < 10; ++i) {
            this.transformedMap.put((Object)String.valueOf(i), (Object)String.valueOf(i));
        }
    }

    public void testReadableMap() {
        final IterableMap map = SplitMapUtils.readableMap(this.transformedMap);
        for (int i = 0; i < 10; ++i) {
            SplitMapUtilsTest.assertFalse((boolean)map.containsValue((Object)String.valueOf(i)));
            SplitMapUtilsTest.assertEquals((int)i, (int)((Integer)map.get((Object)String.valueOf(i))));
        }
        MapIterator it = map.mapIterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            SplitMapUtilsTest.assertEquals((String)k, (String)((String)it.getKey()));
            SplitMapUtilsTest.assertEquals((Object)Integer.valueOf(k), (Object)it.getValue());
        }
        SplitMapUtilsTest.assertTrue((boolean)(map instanceof Unmodifiable));
        int sz = map.size();
        this.attemptPutOperation(new Runnable(){

            public void run() {
                map.clear();
            }
        });
        SplitMapUtilsTest.assertEquals((int)sz, (int)map.size());
        this.attemptPutOperation(new Runnable(){

            public void run() {
                map.put((Object)"foo", (Object)100);
            }
        });
        final HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("foo", 100);
        m.put("bar", 200);
        m.put("baz", 300);
        this.attemptPutOperation(new Runnable(){

            public void run() {
                map.putAll((Map)m);
            }
        });
        IterableMap other = SplitMapUtils.readableMap(this.transformedMap);
        SplitMapUtilsTest.assertEquals((Object)other, (Object)map);
        SplitMapUtilsTest.assertEquals((int)other.hashCode(), (int)map.hashCode());
        for (int i = 0; i < 10; ++i) {
            SplitMapUtilsTest.assertEquals((int)i, (int)((Integer)map.remove((Object)String.valueOf(i))));
            SplitMapUtilsTest.assertEquals((int)(--sz), (int)map.size());
        }
        SplitMapUtilsTest.assertTrue((boolean)map.isEmpty());
        SplitMapUtilsTest.assertSame((Object)map, (Object)SplitMapUtils.readableMap((Get)map));
    }

    public void testAlreadyReadableMap() {
        HashedMap hashedMap = new HashedMap();
        SplitMapUtilsTest.assertSame((Object)hashedMap, (Object)SplitMapUtils.readableMap((Get)hashedMap));
    }

    public void testWritableMap() {
        final Map map = SplitMapUtils.writableMap(this.transformedMap);
        this.attemptGetOperation(new Runnable(){

            public void run() {
                map.get(null);
            }
        });
        this.attemptGetOperation(new Runnable(){

            public void run() {
                map.entrySet();
            }
        });
        this.attemptGetOperation(new Runnable(){

            public void run() {
                map.keySet();
            }
        });
        this.attemptGetOperation(new Runnable(){

            public void run() {
                map.values();
            }
        });
        this.attemptGetOperation(new Runnable(){

            public void run() {
                map.size();
            }
        });
        this.attemptGetOperation(new Runnable(){

            public void run() {
                map.isEmpty();
            }
        });
        this.attemptGetOperation(new Runnable(){

            public void run() {
                map.containsKey(null);
            }
        });
        this.attemptGetOperation(new Runnable(){

            public void run() {
                map.containsValue(null);
            }
        });
        this.attemptGetOperation(new Runnable(){

            public void run() {
                map.remove(null);
            }
        });
        Map other = SplitMapUtils.writableMap(this.transformedMap);
        SplitMapUtilsTest.assertEquals((Object)other, (Object)map);
        SplitMapUtilsTest.assertEquals((int)other.hashCode(), (int)map.hashCode());
        int sz = this.backingMap.size();
        SplitMapUtilsTest.assertFalse((boolean)this.backingMap.containsKey("foo"));
        map.put("new", "66");
        SplitMapUtilsTest.assertEquals((int)(++sz), (int)this.backingMap.size());
        HashMap<String, String> more = new HashMap<String, String>();
        more.put("foo", "77");
        more.put("bar", "88");
        more.put("baz", "99");
        map.putAll(more);
        SplitMapUtilsTest.assertEquals((int)(sz + more.size()), (int)this.backingMap.size());
        map.clear();
        SplitMapUtilsTest.assertTrue((boolean)this.backingMap.isEmpty());
        SplitMapUtilsTest.assertSame((Object)map, (Object)SplitMapUtils.writableMap((Put)((Put)map)));
    }

    public void testAlreadyWritableMap() {
        HashedMap hashedMap = new HashedMap();
        SplitMapUtilsTest.assertSame((Object)hashedMap, (Object)SplitMapUtils.writableMap((Put)hashedMap));
    }

    private void attemptGetOperation(Runnable r) {
        this.attemptMapOperation("Put exposed as writable Map must not allow Get operations", r);
    }

    private void attemptPutOperation(Runnable r) {
        this.attemptMapOperation("Get exposed as writable Map must not allow Put operations", r);
    }

    private void attemptMapOperation(String s, Runnable r) {
        try {
            r.run();
            SplitMapUtilsTest.fail((String)s);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

