/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import junit.framework.Test;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.BagUtils;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.bag.PredicatedBag;
import org.apache.commons.collections4.bag.PredicatedSortedBag;
import org.apache.commons.collections4.bag.SynchronizedBag;
import org.apache.commons.collections4.bag.SynchronizedSortedBag;
import org.apache.commons.collections4.bag.TransformedBag;
import org.apache.commons.collections4.bag.TransformedSortedBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.bag.UnmodifiableBag;
import org.apache.commons.collections4.bag.UnmodifiableSortedBag;
import org.apache.commons.collections4.functors.TruePredicate;

public class BagUtilsTest
extends BulkTest {
    protected Class<?> stringClass = this.getName().getClass();
    protected Predicate<Object> truePredicate = TruePredicate.truePredicate();
    protected Transformer<Object, Object> nopTransformer = TransformerUtils.nopTransformer();

    public BagUtilsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return BulkTest.makeSuite(BagUtilsTest.class);
    }

    public void testSynchronizedBag() {
        Bag bag = BagUtils.synchronizedBag((Bag)new HashBag());
        BagUtilsTest.assertTrue((String)"Returned object should be a SynchronizedBag.", (boolean)(bag instanceof SynchronizedBag));
        try {
            BagUtils.synchronizedBag(null);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null bag.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUnmodifiableBag() {
        Bag bag = BagUtils.unmodifiableBag((Bag)new HashBag());
        BagUtilsTest.assertTrue((String)"Returned object should be an UnmodifiableBag.", (boolean)(bag instanceof UnmodifiableBag));
        try {
            BagUtils.unmodifiableBag(null);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null bag.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        BagUtilsTest.assertSame((String)"UnmodifiableBag shall not be decorated", (Object)bag, (Object)BagUtils.unmodifiableBag((Bag)bag));
    }

    public void testPredicatedBag() {
        Bag bag = BagUtils.predicatedBag((Bag)new HashBag(), this.truePredicate);
        BagUtilsTest.assertTrue((String)"Returned object should be a PredicatedBag.", (boolean)(bag instanceof PredicatedBag));
        try {
            BagUtils.predicatedBag(null, this.truePredicate);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null bag.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BagUtils.predicatedBag((Bag)new HashBag(), null);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTransformedBag() {
        Bag bag = BagUtils.transformingBag((Bag)new HashBag(), this.nopTransformer);
        BagUtilsTest.assertTrue((String)"Returned object should be an TransformedBag.", (boolean)(bag instanceof TransformedBag));
        try {
            BagUtils.transformingBag(null, this.nopTransformer);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null bag.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BagUtils.transformingBag((Bag)new HashBag(), null);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null transformer.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSynchronizedSortedBag() {
        SortedBag bag = BagUtils.synchronizedSortedBag((SortedBag)new TreeBag());
        BagUtilsTest.assertTrue((String)"Returned object should be a SynchronizedSortedBag.", (boolean)(bag instanceof SynchronizedSortedBag));
        try {
            BagUtils.synchronizedSortedBag(null);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null bag.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUnmodifiableSortedBag() {
        SortedBag bag = BagUtils.unmodifiableSortedBag((SortedBag)new TreeBag());
        BagUtilsTest.assertTrue((String)"Returned object should be an UnmodifiableSortedBag.", (boolean)(bag instanceof UnmodifiableSortedBag));
        try {
            BagUtils.unmodifiableSortedBag(null);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null bag.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        BagUtilsTest.assertSame((String)"UnmodifiableSortedBag shall not be decorated", (Object)bag, (Object)BagUtils.unmodifiableSortedBag((SortedBag)bag));
    }

    public void testPredicatedSortedBag() {
        SortedBag bag = BagUtils.predicatedSortedBag((SortedBag)new TreeBag(), this.truePredicate);
        BagUtilsTest.assertTrue((String)"Returned object should be a PredicatedSortedBag.", (boolean)(bag instanceof PredicatedSortedBag));
        try {
            BagUtils.predicatedSortedBag(null, this.truePredicate);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null bag.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BagUtils.predicatedSortedBag((SortedBag)new TreeBag(), null);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTransformedSortedBag() {
        SortedBag bag = BagUtils.transformingSortedBag((SortedBag)new TreeBag(), this.nopTransformer);
        BagUtilsTest.assertTrue((String)"Returned object should be an TransformedSortedBag", (boolean)(bag instanceof TransformedSortedBag));
        try {
            BagUtils.transformingSortedBag(null, this.nopTransformer);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null bag.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BagUtils.transformingSortedBag((SortedBag)new TreeBag(), null);
            BagUtilsTest.fail((String)"Expecting IllegalArgumentException for null transformer.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

