/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cocoon.sitemap.node;

import java.util.Map;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SitemapNodeFactory implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    public SitemapNode createNode(String type, Map<String, String> parameters) {
        try {
            String beanName = SitemapNode.class.getName() + "/" + type;
            SitemapNode sitemapNode = (SitemapNode) this.applicationContext.getBean(beanName, SitemapNode.class);
            sitemapNode.setParameters(parameters);
            return sitemapNode;
        } catch (Exception e) {
            throw new IllegalArgumentException("A node of type '" + type + "' could not be created.", e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
