/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sample.generation;

import org.apache.cocoon.pipeline.caching.AbstractCacheKey;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.pipeline.util.MurmurHashCodeBuilder;
import org.apache.cocoon.sample.generation.TimestampGenerator;

public class CachingTimestampGenerator
extends TimestampGenerator
implements CachingPipelineComponent {
    private static final int CACHING_PERIOD = 1500;

    public CacheKey constructCacheKey() {
        return new CacheKeyImplementation(System.currentTimeMillis());
    }

    private final class CacheKeyImplementation
    extends AbstractCacheKey {
        private static final long serialVersionUID = 1L;
        private final long timestamp;

        public CacheKeyImplementation(long timestamp) {
            this.timestamp = timestamp;
        }

        public boolean equals(Object obj) {
            return obj instanceof CacheKeyImplementation;
        }

        public long getLastModified() {
            return this.timestamp;
        }

        public int hashCode() {
            return new MurmurHashCodeBuilder().append(((Object)((Object)this)).getClass().getName()).toHashCode();
        }

        public boolean isValid(CacheKey other) {
            if (!(other instanceof CacheKeyImplementation)) {
                return false;
            }
            CacheKeyImplementation otherCacheKey = (CacheKeyImplementation)other;
            return Math.abs(this.timestamp - otherCacheKey.timestamp) < 1500L;
        }
    }
}

