/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.selection.Selector;

public class CookieSelector
extends AbstractLogEnabled
implements Configurable,
Selector,
ThreadSafe {
    protected String defaultName;

    public void configure(Configuration config) throws ConfigurationException {
        this.defaultName = config.getChild("cookie-name").getValue(null);
    }

    public boolean select(String expression, Map objectModel, Parameters parameters) {
        String name = parameters.getParameter("cookie-name", this.defaultName);
        if (name == null) {
            this.getLogger().warn("No cookie name given -- failing.");
            return false;
        }
        Cookie[] cookies = ObjectModelHelper.getRequest((Map)objectModel).getCookies();
        if (cookies == null) {
            this.getLogger().debug("Cookie '" + name + "' not set -- failing");
            return false;
        }
        String value = null;
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            value = cookies[i].getValue();
            break;
        }
        if (value == null) {
            this.getLogger().debug("Cookie '" + name + "' not set -- failing");
            return false;
        }
        return value.equals(expression);
    }
}

