/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;
import org.apache.cocoon.components.modules.input.ModuleHolder;

public class SelectMetaInputModule
extends AbstractMetaModule
implements ThreadSafe {
    private Map whenTest;
    private ModuleHolder expression;
    private ModuleHolder otherwise;
    private String parameter;

    public SelectMetaInputModule() {
        this.defaultInput = null;
    }

    public void configure(Configuration config) throws ConfigurationException {
        String name;
        int i;
        Configuration[] expr = config.getChildren("input-module");
        if (expr == null || expr.length != 1) {
            throw new ConfigurationException("Need to have exactly one input-module element.");
        }
        this.parameter = config.getChild("parameter").getValue();
        Configuration[] whens = config.getChildren("when");
        Configuration[] others = config.getChildren("otherwise");
        if (whens == null && others == null || (whens == null || whens.length == 0) && (others == null || others.length == 0)) {
            throw new ConfigurationException("Need to have at least one when or otherwise element.");
        }
        if (others != null && others.length > 1) {
            throw new ConfigurationException("Need to have at most one otherwise element.");
        }
        this.whenTest = new TreeMap();
        for (i = 0; i < expr.length; ++i) {
            name = expr[i].getAttribute("name");
            this.expression = new ModuleHolder(name, expr[i], null);
        }
        if (others != null) {
            for (i = 0; i < others.length; ++i) {
                name = others[i].getAttribute("name");
                this.otherwise = new ModuleHolder(name, others[i], null);
            }
        }
        if (whens != null) {
            for (i = 0; i < whens.length; ++i) {
                name = whens[i].getAttribute("name");
                this.whenTest.put(whens[i].getAttribute("test"), new ModuleHolder(name, whens[i], null));
            }
        }
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object result = this.getAttribute(name, modeConf, objectModel, false);
        return result;
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object result = this.getAttribute(name, modeConf, objectModel, true);
        return result != null ? (Object[])result : null;
    }

    private Object getAttribute(String name, Configuration modeConf, Map objectModel, boolean getValues) throws ConfigurationException {
        Object[] result;
        boolean dynamicConfig;
        if (!this.initialized) {
            this.lazy_initialize();
        }
        ModuleHolder expression = this.expression;
        ModuleHolder otherwise = this.otherwise;
        ModuleHolder module = null;
        String parameter = this.parameter;
        boolean needRelease = false;
        boolean bl = dynamicConfig = modeConf != null && modeConf.getChildren().length > 0;
        if (dynamicConfig) {
            expression = null;
            otherwise = null;
            needRelease = true;
            Configuration[] expr = modeConf.getChildren("input-module");
            Configuration[] other = modeConf.getChildren("otherwise");
            if (expr != null && expr.length == 1) {
                expression = new ModuleHolder(expr[0].getAttribute("name"), expr[0]);
            }
            if (other != null && other.length == 1) {
                otherwise = new ModuleHolder(other[0].getAttribute("name"), other[0]);
            }
            parameter = modeConf.getChild("parameter").getValue();
        }
        String value = (String)this.getValue(parameter, objectModel, expression.input, expression.name, expression.config);
        if (needRelease) {
            this.releaseModule(expression.input);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((dynamicConfig ? "(dyn)" : "(static)") + " select (" + value + ") from " + expression.name + ":" + parameter);
        }
        if (dynamicConfig && value != null) {
            Configuration[] whens = modeConf.getChildren("when");
            if (whens != null && whens.length > 0) {
                int i;
                boolean found = false;
                for (i = 0; !found && i < whens.length; ++i) {
                    if (!whens[i].getAttribute("test").equals(value)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    module = new ModuleHolder(whens[i].getAttribute("name"), whens[i]);
                }
            }
        } else if (value != null) {
            module = (ModuleHolder)this.whenTest.get(value);
        }
        if (module != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("found matching when : " + module.name);
            }
        } else {
            module = otherwise;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("using otherwise : " + module.name);
            }
        }
        if (getValues) {
            result = module == null ? null : this.getValues(name, objectModel, module);
        } else {
            Object object = result = module == null ? null : this.getValue(name, objectModel, module);
        }
        if (needRelease && module != null) {
            this.releaseModule(module.input);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Obtained value : " + result);
        }
        return result;
    }

    public void dispose() {
        this.releaseModule(this.expression.input);
        this.expression = null;
        if (this.otherwise != null) {
            this.releaseModule(this.otherwise.input);
            this.otherwise = null;
        }
        Iterator i = this.whenTest.values().iterator();
        while (i.hasNext()) {
            ModuleHolder holder = (ModuleHolder)i.next();
            this.releaseModule(holder.input);
        }
        this.whenTest = null;
        super.dispose();
    }

    public synchronized void lazy_initialize() {
        if (this.initialized) {
            return;
        }
        super.lazy_initialize();
        if (this.expression != null) {
            this.expression.input = this.obtainModule(this.expression.name);
        }
        if (this.otherwise != null) {
            this.otherwise.input = this.obtainModule(this.otherwise.name);
        }
        if (this.whenTest != null) {
            Iterator i = this.whenTest.values().iterator();
            while (i.hasNext()) {
                ModuleHolder moduleHolder = (ModuleHolder)i.next();
                moduleHolder.input = this.obtainModule(moduleHolder.name);
            }
        }
    }
}

