/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;
import org.apache.cocoon.util.HashMap;

public class DigestMetaModule
extends AbstractMetaModule
implements ThreadSafe {
    private String defaultAlgorithm = "SHA";
    private String defaultProvider;
    private String defaultSalt = "salt";
    private String defaultEncode = "false";
    static final int ENCODING_NONE = 0;
    static final int ENCODING_STR = 1;
    static final int ENCODING_URL = 2;
    static final int ENCODING_HEX = 3;
    private static final HashMap encodingNames;
    static char[] hexChar;

    public void configure(Configuration config) throws ConfigurationException {
        this.inputConf = config.getChild("input-module");
        this.defaultInput = this.inputConf.getAttribute("name", this.defaultInput);
        this.defaultAlgorithm = this.inputConf.getAttribute("algorithm", this.defaultAlgorithm);
        this.defaultProvider = this.inputConf.getAttribute("provider", this.defaultProvider);
        this.defaultSalt = this.inputConf.getAttribute("salt", this.defaultSalt);
        this.defaultEncode = this.inputConf.getAttribute("encode", "false");
        this.defaultAlgorithm = config.getChild("algorithm").getValue(this.defaultAlgorithm);
        this.defaultProvider = config.getChild("provider").getValue(this.defaultProvider);
        this.defaultSalt = config.getChild("salt").getValue(this.defaultSalt);
        this.defaultEncode = config.getChild("encode").getValue(this.defaultEncode);
        if (encodingNames.get((Object)this.defaultEncode) == null) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Requested encoding is unknown: " + this.defaultEncode);
            }
            this.defaultEncode = "false";
        }
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        block10: {
            Object value;
            if (!this.initialized) {
                this.lazy_initialize();
            }
            if (this.defaultInput == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("No input module given. FAILING");
                }
                return null;
            }
            Configuration inputConfig = null;
            String inputName = null;
            String algorithm = this.defaultAlgorithm;
            String provider = this.defaultProvider;
            String salt = this.defaultSalt;
            int encode = (Integer)encodingNames.get((Object)this.defaultEncode);
            if (modeConf != null) {
                inputName = modeConf.getChild("input-module").getAttribute("name", null);
                if (inputName != null) {
                    inputConfig = modeConf.getChild("input-module");
                }
                algorithm = modeConf.getAttribute("algorithm", algorithm);
                provider = modeConf.getAttribute("provider", provider);
                salt = modeConf.getAttribute("salt", salt);
                encode = (Integer)encodingNames.get((Object)modeConf.getAttribute("encode", this.defaultEncode));
                algorithm = modeConf.getChild("algorithm").getValue(algorithm);
                provider = modeConf.getChild("provider").getValue(provider);
                salt = modeConf.getChild("salt").getValue(salt);
                encode = (Integer)encodingNames.get((Object)modeConf.getChild("encode").getValue(this.defaultEncode));
            }
            if ((value = this.getValue(name, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig)) != null) {
                try {
                    MessageDigest md = provider == null ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
                    md.update((salt + (value instanceof String ? (String)value : value.toString())).getBytes());
                    return this.encodeByteArray(md.digest(), encode);
                }
                catch (NoSuchAlgorithmException nsae) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("A problem occurred acquiring digest algorithm '" + algorithm + (provider == null ? "" : "' from '" + provider) + "': " + nsae.getMessage());
                    }
                }
                catch (NoSuchProviderException nspe) {
                    if (!this.getLogger().isWarnEnabled()) break block10;
                    this.getLogger().warn("A problem occurred acquiring digest algorithm '" + algorithm + (provider == null ? "" : "' from '" + provider) + "': " + nspe.getMessage());
                }
            }
        }
        return null;
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Configuration inputConfig = null;
        String inputName = null;
        if (modeConf != null && (inputName = modeConf.getChild("input-module").getAttribute("name", null)) != null) {
            inputConfig = modeConf.getChild("input-module");
        }
        Iterator names = this.getNames(objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
        return names;
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object[] result;
        block11: {
            if (!this.initialized) {
                this.lazy_initialize();
            }
            if (this.defaultInput == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("No input module given. FAILING");
                }
                return null;
            }
            Configuration inputConfig = null;
            String inputName = null;
            String algorithm = this.defaultAlgorithm;
            String provider = this.defaultProvider;
            String salt = this.defaultSalt;
            int encode = (Integer)encodingNames.get((Object)this.defaultEncode);
            if (modeConf != null) {
                inputName = modeConf.getChild("input-module").getAttribute("name", null);
                if (inputName != null) {
                    inputConfig = modeConf.getChild("input-module");
                }
                algorithm = modeConf.getAttribute("algorithm", algorithm);
                provider = modeConf.getAttribute("provider", provider);
                salt = modeConf.getAttribute("salt", salt);
                encode = (Integer)encodingNames.get((Object)modeConf.getAttribute("encode", this.defaultEncode));
                algorithm = modeConf.getChild("algorithm").getValue(algorithm);
                provider = modeConf.getChild("provider").getValue(provider);
                salt = modeConf.getChild("salt").getValue(salt);
                encode = (Integer)encodingNames.get((Object)modeConf.getChild("encode").getValue(this.defaultEncode));
            }
            Object[] values = this.getValues(name, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
            result = null;
            if (values != null) {
                try {
                    MessageDigest md = provider == null ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
                    result = new Object[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        md.update((salt + (values[i] instanceof String ? (String)values[i] : values[i].toString())).getBytes());
                        result[i] = this.encodeByteArray(md.digest(), encode);
                    }
                    return result;
                }
                catch (NoSuchAlgorithmException nsae) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("A problem occurred acquiring digest algorithm '" + algorithm + (provider == null ? "" : "' from '" + provider) + "': " + nsae.getMessage());
                    }
                }
                catch (NoSuchProviderException nspe) {
                    if (!this.getLogger().isWarnEnabled()) break block11;
                    this.getLogger().warn("A problem occurred acquiring digest algorithm '" + algorithm + (provider == null ? "" : "' from '" + provider) + "': " + nspe.getMessage());
                }
            }
        }
        return result;
    }

    Object encodeByteArray(byte[] b, int encode) {
        String result = null;
        switch (encode) {
            case 3: {
                result = DigestMetaModule.byte2Hex(b);
                break;
            }
            case 1: {
                try {
                    result = new String(b, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    if (!this.getLogger().isErrorEnabled()) break;
                    this.getLogger().error("UTF-8 not supported -- cannot convert message digest to String.");
                }
                break;
            }
            case 2: {
                try {
                    String str = new String(b, "UTF-8");
                    result = URLEncoder.encode(str, "utf-8");
                }
                catch (UnsupportedEncodingException uee) {
                    if (!this.getLogger().isErrorEnabled()) break;
                    this.getLogger().error("UTF-8 not supported -- cannot convert message digest to String.");
                }
                break;
            }
            case 0: {
                break;
            }
        }
        return result;
    }

    static String byte2Hex(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    static {
        HashMap names = new HashMap();
        names.put((Object)"false", (Object)new Integer(0));
        names.put((Object)"no", (Object)new Integer(0));
        names.put((Object)"none", (Object)new Integer(0));
        names.put((Object)"string", (Object)new Integer(1));
        names.put((Object)"yes", (Object)new Integer(2));
        names.put((Object)"true", (Object)new Integer(2));
        names.put((Object)"hex", (Object)new Integer(3));
        encodingNames = names;
        Object var0 = null;
        hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

