/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.environment.ObjectModelHelper;

public class CookieModule
extends AbstractInputModule
implements ThreadSafe {
    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        String value;
        Cookie cookie = (Cookie)this.getCookieMap(objectModel).get(name);
        String string = value = cookie == null ? null : cookie.getValue();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Cookie[" + name + "]=" + value);
        }
        return value;
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return this.getCookieMap(objectModel).keySet().iterator();
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Map allCookies = this.getCookieMap(objectModel);
        Iterator it = allCookies.values().iterator();
        LinkedList<String> matched = new LinkedList<String>();
        while (it.hasNext()) {
            Cookie cookie = (Cookie)it.next();
            if (!cookie.getName().matches(name)) continue;
            matched.add(cookie.getValue());
        }
        return matched.toArray();
    }

    protected Map getCookieMap(Map objectModel) {
        return ObjectModelHelper.getRequest((Map)objectModel).getCookieMap();
    }
}

