/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractConfigurableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class RequestParameterExistsAction
extends AbstractConfigurableAction
implements ThreadSafe {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String params;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap<String, String> results = new HashMap<String, String>();
        HashMap<Integer, StringParts> items = new HashMap<Integer, StringParts>();
        int wildcards = 0;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("checking default parameters");
        }
        Iterator reqParams = this.settings.values().iterator();
        while (reqParams.hasNext()) {
            String paramName = (String)reqParams.next();
            StringParts sp = this.splitParameter(paramName);
            if (sp != null) {
                items.put(new Integer(wildcards++), sp);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("(default) deferring " + paramName);
                continue;
            }
            String paramValue = request.getParameter(paramName);
            if (paramValue == null) {
                return null;
            }
            results.put(paramName, paramValue);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("checking sitemap parameters");
        }
        if ((params = parameters.getParameter("parameters", null)) != null) {
            StringTokenizer st = new StringTokenizer(params);
            while (st.hasMoreTokens()) {
                String paramName = st.nextToken();
                StringParts sp = this.splitParameter(paramName);
                if (sp != null) {
                    items.put(new Integer(wildcards++), sp);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("deferring " + paramName);
                    continue;
                }
                String paramValue = request.getParameter(paramName);
                if (paramValue == null) {
                    return null;
                }
                results.put(paramName, paramValue);
            }
        }
        if (wildcards != 0) {
            String paramName;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("deferred checking for parameters: " + wildcards);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(" checking first");
            }
            HashMap<String, Boolean> values = new HashMap<String, Boolean>();
            StringParts sp1 = (StringParts)items.get(new Integer(0));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("  Parameter is [" + sp1.prefix + " * " + sp1.pstfix + "] ");
            }
            Enumeration requestParams = request.getParameterNames();
            Boolean dummy = Boolean.TRUE;
            while (requestParams.hasMoreElements()) {
                String paramValue;
                paramName = (String)requestParams.nextElement();
                String match = this.getMatch(paramName, sp1);
                if (match == null) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("  value is >" + match + "< " + sp1.prefix.length() + " " + paramName.length() + " " + sp1.pstfix.length());
                }
                values.put(match, dummy);
                ++sp1.count;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("   Parameter " + sp1.prefix + "*" + sp1.pstfix + " matches " + paramName + " (" + sp1.count + " so far)");
                }
                if ((paramValue = request.getParameter(paramName)) == null) {
                    return null;
                }
                results.put(paramName, paramValue);
            }
            if (sp1.count == 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("   Parameter " + sp1.prefix + "*" + sp1.pstfix + " matches " + sp1.count);
                }
                return null;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(" checking others");
            }
            requestParams = request.getParameterNames();
            while (requestParams.hasMoreElements()) {
                paramName = (String)requestParams.nextElement();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("  checking request parameter " + paramName);
                }
                for (int i = wildcards - 1; i > 0; --i) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("   checking against " + i);
                    }
                    StringParts sp = (StringParts)items.get(new Integer(i));
                    String match = this.getMatch(paramName, sp);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("   Parameter is [" + sp.prefix + " * " + sp.pstfix + "] ");
                    }
                    if (match == null) continue;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("   Parameter " + sp.prefix + "*" + sp.pstfix + " matches " + paramName + " (" + sp.count + " so far)");
                    }
                    if (values.containsKey(match)) {
                        String paramValue;
                        ++sp.count;
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("   " + paramName + " (verified)");
                        }
                        if ((paramValue = request.getParameter(paramName)) == null) {
                            return null;
                        }
                        results.put(paramName, paramValue);
                        continue;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Match " + match + "not found for " + sp1.prefix + "*" + sp1.pstfix + " but for " + sp.prefix + "*" + sp.pstfix);
                    }
                    return null;
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("checking number of matches");
            }
            for (int i = wildcards - 1; i > 0; --i) {
                StringParts sp = (StringParts)items.get(new Integer(i));
                if (sp.count != sp1.count) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Found " + sp.count + " matches for " + sp.prefix + "*" + sp.pstfix + " but expected " + sp1.count);
                    }
                    return null;
                }
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Found " + sp.count + " matches for " + sp.prefix + "*" + sp.pstfix + " as expected");
            }
        }
        return Collections.unmodifiableMap(results);
    }

    protected StringParts splitParameter(String paramName) {
        int idx = paramName.indexOf("*");
        if (idx != -1) {
            return new StringParts(paramName.substring(0, idx), paramName.substring(idx + 1));
        }
        return null;
    }

    protected String getMatch(String paramName, StringParts sp) {
        if (paramName.startsWith(sp.prefix) && paramName.endsWith(sp.pstfix)) {
            return paramName.substring(sp.prefix.length(), paramName.length() - sp.pstfix.length());
        }
        return null;
    }

    protected class StringParts {
        String prefix = null;
        String pstfix = null;
        int count = 0;

        public StringParts(String pre, String post) {
            this.prefix = pre;
            this.pstfix = post;
        }
    }
}

