/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.cocoon.stax.sample.test;

import static org.junit.Assert.assertTrue;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;

import org.apache.cocoon.pipeline.NonCachingPipeline;
import org.apache.cocoon.pipeline.Pipeline;
import org.apache.cocoon.stax.StAXPipelineComponent;
import org.apache.cocoon.stax.component.XMLGenerator;
import org.apache.cocoon.stax.component.XMLSerializer;
import org.apache.cocoon.stax.sample.src.DaisyLinkRewriteTransformer;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Test;

/**
 * Contains unit tests for the DaisyLinkRewriteTransformer.
 */
public class DaisyLinkRewriteTransformerTest {

    /**
     * Tests the DaisyLinkRewriteTransformer by using the a reference input and output from the SAX implementation.
     */
    @Test
    public void testUserTransformation() throws Exception {
        InputStream input = DaisyLinkRewriteTransformerTest.class.getResource(
        "/org/apache/cocoon/stax/sample/daisy-document-input.xml").openStream();

        ByteArrayOutputStream out = new ByteArrayOutputStream();

        Pipeline<StAXPipelineComponent> pipe = new NonCachingPipeline<StAXPipelineComponent>();
        pipe.addComponent(new XMLGenerator(input));
        pipe.addComponent(new DaisyLinkRewriteTransformer("site/test/"));
        pipe.addComponent(new XMLSerializer());
        pipe.setup(out);
        pipe.execute();

        input.close();
        String created = out.toString();
        out.close();

        String correctOne = IOUtils.toString(DaisyLinkRewriteTransformerTest.class.getResource("/org/apache/cocoon/stax/sample/daisy-document-result.xml").openStream());
        XMLUnit.setIgnoreWhitespace(true);
        Diff myDiff = new Diff(correctOne, created);
        assertTrue("pieces of XML are similar " + myDiff, myDiff.similar());
    }
}
